/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.sdk.common;

import android.util.Base64;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

@JNINamespace(value="liteav::license")
public class LicenseCheckerPlatformAndroid {
    private static final String TAG = "LicenseCheckerPlatformAndroid";
    private static final String ALGORITHM_RSA = "RSA";
    private static final String ALGORITHM_SHA256WITH_RSA = "SHA256WithRSA";
    private static final String ALGORITHM_AES = "AES";
    private static final String ALGORITHM_AES_CBC_PKCS5PADDING = "AES/CBC/PKCS5Padding";

    @CalledByNative
    public static boolean verifyLicense(byte[] data, byte[] sign, byte[] publicKey) {
        if (data == null || data.length == 0 || sign == null || sign.length == 0 || publicKey == null || publicKey.length == 0) {
            Log.w(TAG, "verifyLicense: invalid parameter.", new Object[0]);
            return false;
        }
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base64.decode((byte[])publicKey, (int)0));
            PublicKey publicKey2 = KeyFactory.getInstance(ALGORITHM_RSA).generatePublic(x509EncodedKeySpec);
            Signature signature = Signature.getInstance(ALGORITHM_SHA256WITH_RSA);
            signature.initVerify(publicKey2);
            signature.update(Base64.decode((byte[])data, (int)0));
            return signature.verify(Base64.decode((byte[])sign, (int)0));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException generalSecurityException) {
            generalSecurityException.printStackTrace();
            return false;
        }
    }

    @CalledByNative
    public static String decryptLicense(byte[] ciphertext, byte[] key, byte[] iv) {
        if (ciphertext == null || ciphertext.length == 0 || key == null || key.length == 0 || iv == null || iv.length == 0) {
            Log.w(TAG, "decryptLicense: invalid parameter.", new Object[0]);
            return "";
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, ALGORITHM_AES);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM_AES_CBC_PKCS5PADDING);
            cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            byte[] byArray = cipher.doFinal(Base64.decode((byte[])ciphertext, (int)0));
            return new String(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CalledByNative
    public static String getPackageFile(String fileName) {
        byte[] byArray;
        InputStream inputStream;
        block13: {
            inputStream = null;
            inputStream = ContextUtils.getApplicationContext().getAssets().open(fileName);
            byArray = new byte[inputStream.available()];
            if (inputStream.read(byArray) > 0) break block13;
            String string = "";
            if (inputStream == null) return string;
            try {
                inputStream.close();
                return string;
            }
            catch (IOException iOException) {}
            return string;
        }
        inputStream.close();
        String string = new String(byArray);
        if (inputStream == null) return string;
        try {
            inputStream.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException iOException) {
            try {
                Log.w(TAG, "read asset file failed.", iOException);
                if (inputStream == null) return "";
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                inputStream.close();
                return "";
            }
            catch (IOException iOException3) {}
            return "";
        }
    }
}

