/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.txcplayer.ext.host;

import android.content.Context;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.txcplayer.ext.host.IPluginBase;
import com.tencent.liteav.txcplayer.ext.host.PluginCallback;
import com.tencent.liteav.txcplayer.ext.host.PluginManager;
import com.tencent.liteav.txcplayer.ext.service.RenderProcessService;
import java.util.Map;

public class HostEngine {
    public static final String TAG = "HostEngine";
    private Context mAppContext;
    private boolean mIsInit = false;
    private static HostEngine mInstance;

    private HostEngine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HostEngine getInstance() {
        if (mInstance != null) return mInstance;
        Class<HostEngine> clazz = HostEngine.class;
        synchronized (HostEngine.class) {
            if (mInstance != null) return mInstance;
            mInstance = new HostEngine();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public synchronized void init(Context appContext) {
        LiteavLog.d(TAG, "[init], appContext=" + appContext + " ,mIsInit=" + this.mIsInit);
        if (this.mIsInit) {
            return;
        }
        this.mAppContext = appContext;
        this.onCreate();
        this.mIsInit = true;
    }

    public Context getAppContext() {
        return this.mAppContext;
    }

    public void onCreate() {
        LiteavLog.d(TAG, "[onCreate]");
        PluginManager.getInstance().loadPlugin();
    }

    public void onDestroy() {
        LiteavLog.d(TAG, "[onDestroy]");
        PluginManager.getInstance().unLoadPlugin();
    }

    public void sendSyncRequestToPlugin(int destPluginId, int functionId, Map<String, Object> inParams, Map<String, Object> outParams) {
        IPluginBase iPluginBase = PluginManager.getInstance().getPluginInstance(destPluginId);
        if (iPluginBase != null) {
            iPluginBase.handleSyncRequest(destPluginId, functionId, inParams, outParams);
            return;
        }
        LiteavLog.w(TAG, "[sendSyncRequestToPlugin], destPluginId=" + destPluginId + " is not loaded");
    }

    public void sendAsyncRequestToPlugin(int destPluginId, int functionId, Map<String, Object> inParams, PluginCallback callback) {
        IPluginBase iPluginBase = PluginManager.getInstance().getPluginInstance(destPluginId);
        if (iPluginBase != null) {
            iPluginBase.handleAsyncRequest(destPluginId, functionId, inParams, callback);
            return;
        }
        LiteavLog.w(TAG, "[sendAsyncRequestToPlugin], destPluginId=" + destPluginId + " is not loaded");
    }

    public void sendSyncRequestHandleByHost(int functionId, Map<String, Object> inParams, Map<String, Object> outParams) {
        this.handleSyncRequestHandleByHost(functionId, inParams, outParams);
    }

    public void handleSyncRequestHandleByHost(int functionId, Map<String, Object> inParams, Map<String, Object> outParams) {
        LiteavLog.w(TAG, "[handleSyncRequestHandleByHost], functionId=" + functionId + " ,inParams=" + inParams + " ,outParams=" + outParams);
        switch (functionId) {
            case 1: {
                int n2 = RenderProcessService.getInstance().getVodLicenseFeature();
                if (outParams == null) break;
                outParams.put("KEY_RET_PARAM1", n2);
            }
        }
    }

    public boolean checkAndLoadPlugin(int pluginId) {
        LiteavLog.i(TAG, "[checkAndLoadPlugin], pluginId=".concat(String.valueOf(pluginId)));
        return PluginManager.getInstance().checkAndLoadPlugin(pluginId);
    }
}

