/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.txcplayer.ext.host;

import android.text.TextUtils;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.txcplayer.ext.config.PluginConfigCenter;
import com.tencent.liteav.txcplayer.ext.host.HostEngine;
import com.tencent.liteav.txcplayer.ext.host.IPluginBase;
import com.tencent.liteav.txcplayer.ext.host.PluginInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class PluginManager {
    private static final String TAG = "HostEngine-PluginManager";
    private ConcurrentHashMap<Integer, IPluginBase> mPluginMap = new ConcurrentHashMap();
    private List<PluginInfo> mPluginConfigList;
    private static PluginManager mInstance;

    private PluginManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PluginManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<PluginManager> clazz = PluginManager.class;
        synchronized (PluginManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new PluginManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void loadPlugin() {
        this.loadPluginConfig();
        this.doLoadPlugin();
    }

    public void unLoadPlugin() {
        Iterator<PluginInfo> iterator = this.mPluginConfigList.iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next().mPluginId;
            LiteavLog.w(TAG, "[unLoadPlugin], unLoadPlugin=".concat(String.valueOf(n2)));
            IPluginBase iPluginBase = this.mPluginMap.get(n2);
            if (iPluginBase == null) continue;
            iPluginBase.onDestroy();
            this.mPluginMap.remove(n2);
        }
    }

    public IPluginBase getPluginInstance(int pluginId) {
        return this.mPluginMap.get(pluginId);
    }

    public boolean checkAndLoadPlugin(int pluginId) {
        if (this.mPluginMap.containsKey(pluginId)) {
            return true;
        }
        PluginInfo pluginInfo = null;
        for (PluginInfo pluginInfo2 : this.mPluginConfigList) {
            if (pluginInfo2.mPluginId != pluginId) continue;
            pluginInfo = pluginInfo2;
            break;
        }
        if (pluginInfo != null) {
            return this._doLoadPlugin(pluginInfo);
        }
        return false;
    }

    private void doLoadPlugin() {
        for (PluginInfo pluginInfo : this.mPluginConfigList) {
            LiteavLog.d(TAG, "[loadPlugin], pluginId=" + pluginInfo.mPluginId + " ,pluginClazzName=" + pluginInfo.mPluginClazzName);
            if (pluginInfo.mIsCorePlugin) {
                this._doLoadPlugin(pluginInfo);
                continue;
            }
            LiteavLog.d(TAG, "[loadPlugin], pluginId=" + pluginInfo.mPluginId + " is not core plugin, do not load by default");
        }
    }

    private boolean _doLoadPlugin(PluginInfo pluginInfo) {
        int n2 = pluginInfo.mPluginId;
        if (this.mPluginMap.containsKey(n2)) {
            LiteavLog.w(TAG, "[loadPlugin], pluginId has been loaded!!, pluginId=".concat(String.valueOf(n2)));
            return true;
        }
        IPluginBase iPluginBase = this.createPluginInstance(n2, pluginInfo.mPluginClazzName);
        if (iPluginBase != null) {
            iPluginBase.onCreate(HostEngine.getInstance().getAppContext());
            this.mPluginMap.put(n2, iPluginBase);
            LiteavLog.d(TAG, "[loadPlugin], succeed loading pluginId=" + n2 + " ,pluginClazzName=" + pluginInfo.mPluginClazzName);
            return true;
        }
        LiteavLog.w(TAG, "[loadPlugin], pluginId=" + n2 + " is not exist, do not load!!");
        return false;
    }

    private IPluginBase createPluginInstance(int pluginId, String clazzName) {
        LiteavLog.i(TAG, "[createPluginInstance],pluginId|" + pluginId + "|clazzName|" + clazzName);
        if (TextUtils.isEmpty((CharSequence)clazzName)) {
            return null;
        }
        IPluginBase iPluginBase = null;
        try {
            Class<?> clazz = Class.forName(clazzName);
            if (clazz != null) {
                iPluginBase = (IPluginBase)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            LiteavLog.w(TAG, "create pluginInstance exception, pluginId|" + pluginId + "|clazzName|" + clazzName + " is not install in dex!!");
            return null;
        }
        return iPluginBase;
    }

    private void loadPluginConfig() {
        if (this.mPluginConfigList == null) {
            this.mPluginConfigList = new ArrayList<PluginInfo>();
        }
        PluginConfigCenter.loadPluginConfig(this.mPluginConfigList);
    }
}

