/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.common;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.text.TextUtils;
import com.tencent.thumbplayer.core.common.TPMediaDecoderInfo;
import com.tencent.thumbplayer.core.common.TPNativeLog;
import com.tencent.thumbplayer.core.common.TPSystemInfo;
import com.tencent.thumbplayer.core.thirdparties.LocalCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public final class TPMediaDecoderList {
    private static final String TAG = "TPMediaDecoderList";
    private static TPMediaDecoderInfo[] sDecoderInfos = null;
    private static String MEDIA_DECODER_VERSION = "2.32.0.159.min";
    private static final String MEDIA_DECODER_VERSION_KEY = "Version_Key";
    private static final String MEDIA_DECODER_INFO_KEY = "DecoderInfos_Key";

    public static final synchronized TPMediaDecoderInfo[] getTPMediaDecoderInfos(LocalCache localCache) {
        if (sDecoderInfos == null) {
            sDecoderInfos = TPMediaDecoderList.initCodecList(localCache);
        }
        if (sDecoderInfos == null) {
            return new TPMediaDecoderInfo[0];
        }
        return Arrays.copyOf(sDecoderInfos, sDecoderInfos.length);
    }

    private static final MediaCodecInfo[] getCodecInfos() {
        if (Build.VERSION.SDK_INT < 16) {
            return new MediaCodecInfo[0];
        }
        if (Build.VERSION.SDK_INT < 21) {
            int n2 = MediaCodecList.getCodecCount();
            ArrayList<MediaCodecInfo> arrayList = new ArrayList<MediaCodecInfo>();
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(MediaCodecList.getCodecInfoAt((int)i2));
            }
            ArrayList<MediaCodecInfo> arrayList2 = arrayList;
            return arrayList2.toArray(new MediaCodecInfo[arrayList2.size()]);
        }
        try {
            return new MediaCodecList(1).getCodecInfos();
        }
        catch (Exception exception) {
            TPNativeLog.printLog(4, "getCodecInfos MediaCodecList " + exception.getMessage());
            return new MediaCodecInfo[0];
        }
    }

    private static final TPMediaDecoderInfo[] getSystemMediaCodecList() {
        TPNativeLog.printLog(2, "getSystemMediaCodecList");
        MediaCodecInfo[] mediaCodecInfoArray = TPMediaDecoderList.getCodecInfos();
        if (mediaCodecInfoArray == null) {
            return null;
        }
        ArrayList<TPMediaDecoderInfo> arrayList = new ArrayList<TPMediaDecoderInfo>();
        MediaCodecInfo[] mediaCodecInfoArray2 = mediaCodecInfoArray;
        int n2 = mediaCodecInfoArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            MediaCodecInfo mediaCodecInfo = mediaCodecInfoArray2[i2];
            if (mediaCodecInfo.isEncoder()) continue;
            for (String string : mediaCodecInfo.getSupportedTypes()) {
                TPMediaDecoderInfo tPMediaDecoderInfo = new TPMediaDecoderInfo(string, mediaCodecInfo.getName(), mediaCodecInfo.getCapabilitiesForType(string));
                if (!tPMediaDecoderInfo.isValidDecoder()) continue;
                TPNativeLog.printLog(2, "MediaCodecList codecName " + mediaCodecInfo.getName() + " supportedType " + string);
                arrayList.add(tPMediaDecoderInfo);
            }
        }
        ArrayList<TPMediaDecoderInfo> arrayList2 = arrayList;
        return arrayList2.toArray(new TPMediaDecoderInfo[arrayList2.size()]);
    }

    private static String buildCacheDecoderVersion() {
        return new StringBuffer().append(MEDIA_DECODER_VERSION).append("_").append(TPSystemInfo.getDeviceName()).append("_").append(TPSystemInfo.getProductBoard()).append("_").append(TPSystemInfo.getProductDevice()).append("_").append(TPSystemInfo.getApiLevel()).toString();
    }

    private static final TPMediaDecoderInfo[] getLocalCacheMediaCodecList(LocalCache localCache) {
        TPMediaDecoderInfo[] tPMediaDecoderInfoArray;
        TPNativeLog.printLog(2, "getLocalCacheMediaCodecList");
        if (TextUtils.equals((CharSequence)TPMediaDecoderList.getCachedVersion(localCache), (CharSequence)TPMediaDecoderList.buildCacheDecoderVersion()) && (tPMediaDecoderInfoArray = TPMediaDecoderList.getCachedDecoderInfos(localCache)) != null) {
            TPNativeLog.printLog(2, "getCachedDecoderInfos length " + tPMediaDecoderInfoArray.length);
            TPMediaDecoderInfo[] tPMediaDecoderInfoArray2 = tPMediaDecoderInfoArray;
            int n2 = tPMediaDecoderInfoArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                TPMediaDecoderInfo tPMediaDecoderInfo = tPMediaDecoderInfoArray2[i2];
                TPNativeLog.printLog(2, "getLocalCacheMediaCodecList MediaCodecList codecName: " + tPMediaDecoderInfo.getDecoderName() + " ,DecoderMimeType: " + tPMediaDecoderInfo.getDecoderMimeType());
            }
            return tPMediaDecoderInfoArray;
        }
        return null;
    }

    private static final void storeLocalCacheMediaCodecList(LocalCache localCache, TPMediaDecoderInfo[] tPMediaDecoderInfoArray) {
        TPNativeLog.printLog(2, "storeLocalCacheMediaCodecList");
        TPMediaDecoderList.cacheDecoderInfos(localCache, tPMediaDecoderInfoArray);
        TPMediaDecoderList.cacheVersion(localCache, TPMediaDecoderList.buildCacheDecoderVersion());
    }

    private static final TPMediaDecoderInfo[] initCodecList(LocalCache localCache) {
        TPMediaDecoderInfo[] tPMediaDecoderInfoArray = TPMediaDecoderList.getLocalCacheMediaCodecList(localCache);
        if (tPMediaDecoderInfoArray == null) {
            tPMediaDecoderInfoArray = TPMediaDecoderList.getSystemMediaCodecList();
            TPMediaDecoderList.storeLocalCacheMediaCodecList(localCache, tPMediaDecoderInfoArray);
        }
        return tPMediaDecoderInfoArray;
    }

    private static void cacheVersion(LocalCache localCache, String string) {
        try {
            localCache.put(MEDIA_DECODER_VERSION_KEY, string);
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, "cache version failed");
            return;
        }
    }

    private static void cacheDecoderInfos(LocalCache localCache, TPMediaDecoderInfo[] tPMediaDecoderInfoArray) {
        try {
            localCache.put(MEDIA_DECODER_INFO_KEY, (Serializable)tPMediaDecoderInfoArray);
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, "cache decode infos failed");
            return;
        }
    }

    private static String getCachedVersion(LocalCache localCache) {
        try {
            String string = localCache.getAsString(MEDIA_DECODER_VERSION_KEY);
            TPNativeLog.printLog(2, TAG, "version:".concat(String.valueOf(string)));
            return string;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, "get version failed");
            return null;
        }
    }

    private static TPMediaDecoderInfo[] getCachedDecoderInfos(LocalCache localCache) {
        try {
            return (TPMediaDecoderInfo[])localCache.getAsObject(MEDIA_DECODER_INFO_KEY);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, "get decoder info failed");
            return null;
        }
    }
}

