/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.ugc.AudioFrame;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::ugc")
public class MP4Writer {
    private static final String TAG = "MP4Writer";
    private volatile long mNativePtr = 0L;
    private MP4WriterListener mListener = null;
    private boolean mHasVideo = false;
    private boolean mHasAudio = false;
    private String mPath = "";

    public void setListener(MP4WriterListener listener) {
        this.mListener = listener;
    }

    @CalledByNative
    public void onComplete(long durationMs) {
        LiteavLog.i(TAG, "onComplete,durationMs=".concat(String.valueOf(durationMs)));
        MP4WriterListener mP4WriterListener = this.mListener;
        if (mP4WriterListener == null) {
            return;
        }
        mP4WriterListener.onComplete(durationMs);
    }

    @CalledByNative
    public void onError(String info) {
        LiteavLog.i(TAG, "onError,info=".concat(String.valueOf(info)));
        MP4WriterListener mP4WriterListener = this.mListener;
        if (mP4WriterListener == null) {
            return;
        }
        mP4WriterListener.onError(info);
    }

    public void setPath(String path) {
        LiteavLog.i(TAG, "path=".concat(String.valueOf(path)));
        this.mPath = path;
    }

    public void setHasVideo(boolean hasVideo) {
        LiteavLog.i(TAG, "setHasVideo,hasVideo=".concat(String.valueOf(hasVideo)));
        this.mHasVideo = hasVideo;
    }

    public void setHasAudio(boolean hasAudio) {
        LiteavLog.i(TAG, "setHasAudio,hasAudio=".concat(String.valueOf(hasAudio)));
        this.mHasAudio = hasAudio;
    }

    public void start() {
        LiteavLog.i(TAG, "start");
        if (this.mNativePtr != 0L) {
            LiteavLog.w(TAG, "it is already started.");
            return;
        }
        this.mNativePtr = MP4Writer.nativeCreate(this);
        if (this.mNativePtr == 0L) {
            LiteavLog.i(TAG, "create native mp4 writer fail.");
            return;
        }
        MP4Writer.nativeSetHasVideo(this.mNativePtr, this.mHasVideo);
        MP4Writer.nativeSetHasAudio(this.mNativePtr, this.mHasAudio);
        MP4Writer.nativeStart(this.mNativePtr, this.mPath);
    }

    public void stop() {
        LiteavLog.i(TAG, "stop");
        if (this.mNativePtr == 0L) {
            return;
        }
        MP4Writer.nativeStop(this.mNativePtr);
        MP4Writer.nativeDestroy(this.mNativePtr);
        this.mNativePtr = 0L;
    }

    public void writeAudioFrame(AudioFrame frame) {
        if (this.mNativePtr == 0L || frame == null) {
            LiteavLog.w(TAG, "writeAudioFrame, mNativePtr or frame is null.");
            return;
        }
        MP4Writer.nativeWriteAudioFrame(this.mNativePtr, frame.getSampleRate(), frame.getChannelCount(), frame.getTimestamp(), frame.getCodecFormat().getValue(), frame.getData());
    }

    public void writeVideoFrame(EncodedVideoFrame frame) {
        if (this.mNativePtr == 0L || frame == null) {
            LiteavLog.w(TAG, "writeVideoFrame, mNativePtr or frame is null.");
            return;
        }
        EncodedVideoFrame encodedVideoFrame = frame;
        MP4Writer.nativeWriteVideoFrame(this.mNativePtr, encodedVideoFrame, encodedVideoFrame.data, frame.width, frame.height, frame.nalType.mValue, frame.codecType.mValue, frame.pts, frame.dts);
    }

    protected void finalize() {
        LiteavLog.i(TAG, "finalize");
        this.stop();
    }

    private static native long nativeCreate(MP4Writer var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeSetHasVideo(long var0, boolean var2);

    private static native void nativeSetHasAudio(long var0, boolean var2);

    private static native void nativeStart(long var0, String var2);

    private static native void nativeStop(long var0);

    private static native void nativeWriteAudioFrame(long var0, int var2, int var3, long var4, int var6, ByteBuffer var7);

    private static native void nativeWriteVideoFrame(long var0, EncodedVideoFrame var2, ByteBuffer var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static interface MP4WriterListener {
        public void onComplete(long var1);

        public void onError(String var1);
    }
}

