/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc;

import android.content.Context;
import android.util.Pair;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCStatusReportListener;
import cn.rongcloud.rtc.api.probe.IRCRTCProbeTestListener;
import cn.rongcloud.rtc.api.probe.RTCProbeConfig;
import cn.rongcloud.rtc.api.report.RTCStatusReportManager;
import cn.rongcloud.rtc.api.stream.RCRTCLiveInfo;
import cn.rongcloud.rtc.base.RCRTCAVStreamType;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.core.MediaConstraints;
import cn.rongcloud.rtc.module.AudioDeviceManager;
import cn.rongcloud.rtc.proxy.message.messagebeans.ExchangeSDPDataResult;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.stat.RongRtcStatMagr;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import cn.rongcloud.rtc.webrtc.IWebRTCCore;
import cn.rongcloud.rtc.webrtc.MediaCommonParams;
import cn.rongcloud.rtc.webrtc.PeerConnectionFactoryHolder;
import cn.rongcloud.rtc.webrtc.RTCConnectionEventsImpl;
import cn.rongcloud.rtc.webrtc.RTCConnectionHolder;
import cn.rongcloud.rtc.webrtc.RTCPubSubManager;
import cn.rongcloud.rtc.webrtc.probe.RTCProbeManager;
import java.util.List;

public class WebRTCCoreImpl
implements IWebRTCCore {
    private static final String TAG = "WebRTCCoreImpl";
    private Context mContext;
    protected PeerConnectionFactoryHolder mRTCFactory;
    private RTCPubSubManager mPubSubManager;
    private RCRTCConfigImpl mRTCConfig;
    private RTCStatusReportManager mStatusReport;
    private IRCRTCStatusReportListener mStatusReportListener;
    private IRCRTCProbeTestListener mProbeListener;
    private RTCProbeManager probeManager;
    private AudioDeviceManager adm;

    public WebRTCCoreImpl(Context context, RCRTCConfigImpl config, AudioDeviceManager adm) {
        this.mContext = context;
        this.mRTCConfig = config;
        this.adm = adm;
        this.mRTCFactory = new PeerConnectionFactoryHolder(context, config, adm.getAudioDeviceModule(), adm.getAudioConstraints());
        SignalManager.getInstance().setObfuscationKeyListener(this.mRTCFactory);
    }

    @Override
    public void initPeerConnection(String userId, int maxStreamCount, RTCConnectionEventsImpl events) throws NullPointerException {
        RTCConnectionHolder mRTCConnection = new RTCConnectionHolder(this.mRTCFactory, this.mRTCConfig, events);
        this.mStatusReport = new RTCStatusReportManager(mRTCConnection, this.mRTCConfig.getStatusReportInterval().intValue());
        this.mStatusReport.setRTCStatusReportListener(this.mStatusReportListener);
        events.setStatusReportManager(this.mStatusReport);
        RongRtcStatMagr.instance.setRTCConnectionHolder(mRTCConnection);
        this.mPubSubManager = new RTCPubSubManager(mRTCConnection, userId, this.mRTCFactory, maxStreamCount, this.mStatusReport);
        this.setEarphoneOn(true, null);
    }

    @Override
    public void bindingTrack(IStreamResource resource) throws NullPointerException {
        this.mRTCFactory.bindingTrack(resource);
    }

    @Override
    public void publishStream(List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> pubStreams, List<? extends IStreamResource> allSubStreams, MediaCommonParams<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>> params) {
        this.mPubSubManager.publishStreams(allPubStreams, pubStreams, allSubStreams, params);
    }

    @Override
    public void unpublishedStreams(List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, List<? extends IStreamResource> unpublishedStreams, MediaCommonParams<List<MediaResourceInfo>> params) {
        this.mPubSubManager.unpublishedStreams(allPubStreams, allSubStreams, unpublishedStreams, params);
    }

    @Override
    public void subscribeStreams(List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, MediaCommonParams params) {
        this.mPubSubManager.subscribeStreams(allPubStreams, allSubStreams, params);
    }

    @Override
    public void unsubscribeStreams(List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, List<? extends IStreamResource> unSubStreams, boolean needExchangeSDP, MediaCommonParams params) {
        this.mPubSubManager.unsubscribeStreams(allPubStreams, allSubStreams, unSubStreams, needExchangeSDP, params);
    }

    @Override
    public void setEarphoneOn(boolean status, MediaCommonParams params) {
        this.mRTCFactory.setEarphoneOn(status);
    }

    @Override
    public void subscribeLiveStream(String liveUrl, RCRTCAVStreamType avStreamType, IRCRTCResultCallback callback) {
        this.mPubSubManager.subscribeLiveStream(liveUrl, avStreamType, callback);
    }

    @Override
    public void subscribeLiveUrl(String liveUrl, RCRTCAVStreamType avStreamType, String roomId, List<? extends IStreamResource> allSubStreams, String serverSessionId, String clientSessionId, IRCRTCResultDataCallback<List<MediaResourceInfo>> callback) {
        this.mPubSubManager.subscribeLiveUrl(liveUrl, avStreamType, roomId, allSubStreams, serverSessionId, clientSessionId, callback);
    }

    private long getSsrc(List<? extends IStreamResource> allSubStreams) {
        long ret = -1L;
        for (IStreamResource iStreamResource : allSubStreams) {
            try {
                if (iStreamResource.getMediaType() != RCRTCMediaType.AUDIO) continue;
                long ssrc = iStreamResource.getSsrc();
                boolean isLive = iStreamResource.isLive();
                if (!isLive) continue;
                ret = ssrc;
                break;
            }
            catch (Exception e) {
                ret = -1L;
            }
        }
        return ret;
    }

    @Override
    public void subscribeLiveStream(List<? extends IStreamResource> allSubStreams, String serverSessionId, String clientSessionId, RCRTCAVStreamType avStreamType, IRCRTCResultCallback callback) {
        long ssrc = this.getSsrc(allSubStreams);
        this.mStatusReport.setSsrc(ssrc);
        this.mPubSubManager.subscribeLiveStream(allSubStreams, serverSessionId, clientSessionId, avStreamType, callback);
    }

    @Override
    public void updateAudioConstraints(MediaConstraints mediaConstraints) {
        this.mRTCFactory.updateAudioConstraints(mediaConstraints);
    }

    @Override
    public void exchangeVideoSize(List<? extends IStreamResource> allPubStreams, List<IStreamResource> allSubStreams, MediaCommonParams params) {
        this.mPubSubManager.exchangeVideoSize(allPubStreams, allSubStreams, params);
    }

    @Override
    public void reconnectConnection(boolean forceSendSignal, List<? extends IStreamResource> allPubStreams, List<IStreamResource> allSubStreams, MediaCommonParams<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>> params) {
        this.mPubSubManager.reConnected(forceSendSignal, allPubStreams, allSubStreams, params);
    }

    @Override
    public void exchangeRemoteSDP(boolean restartICE, List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, MediaCommonParams<ExchangeSDPDataResult> params) {
        this.mPubSubManager.exchangeRemoteSDP(restartICE, allPubStreams, allSubStreams, params);
    }

    @Override
    public void setRTCStatusReportListener(IRCRTCStatusReportListener eventsListener) {
        this.mStatusReportListener = eventsListener;
        if (this.mStatusReport != null) {
            this.mStatusReport.setRTCStatusReportListener(eventsListener);
        }
    }

    @Override
    public void setRTCProbeTestListener(IRCRTCProbeTestListener listener) {
        this.mProbeListener = listener;
        if (this.probeManager != null) {
            this.probeManager.setRTCProbeTestListener(listener);
        }
    }

    @Override
    public void closePeerConnection() {
        FinLog.d(TAG, "closePeerConnection");
        if (this.mPubSubManager != null) {
            this.mPubSubManager.release();
        }
        this.mPubSubManager = null;
        if (this.mStatusReport != null) {
            this.mStatusReport.stop();
        }
        this.mStatusReport = null;
        this.mStatusReportListener = null;
        this.mProbeListener = null;
    }

    @Override
    public void freedPeerConnection() {
        FinLog.d(TAG, "freedPeerConnection");
        if (this.mPubSubManager != null) {
            this.mPubSubManager.freedPeerConnection();
        }
        if (this.mStatusReport != null) {
            this.mStatusReport.stop();
        }
        this.mStatusReport = null;
    }

    @Override
    public void release() {
        FinLog.d(TAG, "release");
        this.stopRTCProbe(true, null);
        this.closePeerConnection();
        if (this.mRTCFactory != null) {
            this.mRTCFactory.release();
        }
        SignalManager.getInstance().setObfuscationKeyListener(null);
    }

    @Override
    public void startRTCProbe(RTCProbeConfig config, IRCRTCResultCallback callback) {
        FinLog.d(TAG, "[startRTCProbe] ==> config:" + config);
        if (this.probeManager == null) {
            this.probeManager = new RTCProbeManager(this.mRTCFactory, this.adm, this.mRTCConfig);
        }
        this.probeManager.setRTCProbeTestListener(this.mProbeListener);
        this.probeManager.start(config, callback);
    }

    @Override
    public void stopRTCProbe(boolean interiorForceStop, IRCRTCResultCallback callback) {
        FinLog.d(TAG, "[stopRTCProbe] ==> ");
        if (this.probeManager != null) {
            this.probeManager.stop(interiorForceStop, callback);
        } else if (callback != null) {
            callback.onFailed(RTCErrorCode.RTC_PROBE_TEST_NOT_START);
        }
    }

    static {
        try {
            System.loadLibrary("RongRTCLib");
            FinLog.d(TAG, "'libRongRTCLib.so' loaded!");
        }
        catch (Exception e) {
            FinLog.e(TAG, e.getMessage());
            throw new RuntimeException("load 'libRongRTCLib.so' failed!!");
        }
        try {
            System.loadLibrary("RongRTCSupport");
            FinLog.d(TAG, "- libRongRTCSupport.so loaded !");
        }
        catch (Exception e) {
            FinLog.e(TAG, e.getMessage());
            throw new RuntimeException("- load 'libRongRTCSupport.so' failed!!");
        }
    }
}

