/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.action;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.dom.transition.WXTransition;
import com.taobao.weex.performance.WXAnalyzerDataTransfer;
import com.taobao.weex.performance.WXStateRecord;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.action.GraphicActionAbstractAddElement;
import com.taobao.weex.ui.action.GraphicPosition;
import com.taobao.weex.ui.action.GraphicSize;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class GraphicActionAddElement
extends GraphicActionAbstractAddElement {
    private WXVContainer parent;
    private WXComponent child;
    private GraphicPosition layoutPosition;
    private GraphicSize layoutSize;
    private boolean isLayoutRTL;

    public GraphicActionAddElement(@NonNull WXSDKInstance instance, String ref, String componentType, String parentRef, int index, Map<String, String> style, Map<String, String> attributes, Set<String> events, float[] margins, float[] paddings, float[] borders) {
        super(instance, ref);
        this.mComponentType = componentType;
        this.mParentRef = parentRef;
        this.mIndex = index;
        this.mStyle = style;
        this.mAttributes = attributes;
        this.mEvents = events;
        this.mPaddings = paddings;
        this.mMargins = margins;
        this.mBorders = borders;
        if (instance.getContext() == null) {
            return;
        }
        if (WXAnalyzerDataTransfer.isInteractionLogOpen()) {
            Log.d((String)"wxInteractionAnalyzer", (String)("[client][addelementStart]" + instance.getInstanceId() + "," + componentType + "," + ref));
        }
        try {
            this.parent = (WXVContainer)WXSDKManager.getInstance().getWXRenderManager().getWXComponent(this.getPageId(), this.mParentRef);
            long start = WXUtils.getFixUnixTime();
            BasicComponentData basicComponentData = new BasicComponentData(ref, this.mComponentType, this.mParentRef);
            this.child = this.createComponent(instance, this.parent, basicComponentData);
            this.child.setTransition(WXTransition.fromMap(this.child.getStyles(), this.child));
            long diff = WXUtils.getFixUnixTime() - start;
            instance.getApmForInstance().componentCreateTime += diff;
            if (null != this.parent && this.parent.isIgnoreInteraction) {
                this.child.isIgnoreInteraction = true;
            }
            if (!this.child.isIgnoreInteraction) {
                Object flag = null;
                if (null != this.child.getAttrs()) {
                    flag = this.child.getAttrs().get("ignoreInteraction");
                }
                if ("false".equals(flag) || "0".equals(flag)) {
                    this.child.isIgnoreInteraction = false;
                } else if ("1".equals(flag) || "true".equals(flag) || this.child.isFixed()) {
                    this.child.isIgnoreInteraction = true;
                }
            }
            WXStateRecord.getInstance().recordAction(instance.getInstanceId(), "addElement");
        }
        catch (ClassCastException e) {
            ArrayMap ext = new ArrayMap();
            WXComponent parent = WXSDKManager.getInstance().getWXRenderManager().getWXComponent(this.getPageId(), this.mParentRef);
            if (this.mStyle != null && !this.mStyle.isEmpty()) {
                ext.put("child.style", this.mStyle.toString());
            }
            if (parent != null && parent.getStyles() != null && !parent.getStyles().isEmpty()) {
                ext.put("parent.style", parent.getStyles().toString());
            }
            if (this.mAttributes != null && !this.mAttributes.isEmpty()) {
                ext.put("child.attr", this.mAttributes.toString());
            }
            if (parent != null && parent.getAttrs() != null && !parent.getAttrs().isEmpty()) {
                ext.put("parent.attr", parent.getAttrs().toString());
            }
            if (this.mEvents != null && !this.mEvents.isEmpty()) {
                ext.put("child.event", this.mEvents.toString());
            }
            if (parent != null && parent.getEvents() != null && !parent.getEvents().isEmpty()) {
                ext.put("parent.event", parent.getEvents().toString());
            }
            if (this.mMargins != null && this.mMargins.length > 0) {
                ext.put("child.margin", Arrays.toString(this.mMargins));
            }
            if (parent != null && parent.getMargin() != null) {
                ext.put("parent.margin", parent.getMargin().toString());
            }
            if (this.mPaddings != null && this.mPaddings.length > 0) {
                ext.put("child.padding", Arrays.toString(this.mPaddings));
            }
            if (parent != null && parent.getPadding() != null) {
                ext.put("parent.padding", parent.getPadding().toString());
            }
            if (this.mBorders != null && this.mBorders.length > 0) {
                ext.put("child.border", Arrays.toString(this.mBorders));
            }
            if (parent != null && parent.getBorder() != null) {
                ext.put("parent.border", parent.getBorder().toString());
            }
            WXExceptionUtils.commitCriticalExceptionRT(instance.getInstanceId(), WXErrorCode.WX_RENDER_ERR_CONTAINER_TYPE, "GraphicActionAddElement", String.format(Locale.ENGLISH, "You are trying to add a %s to a %2$s, which is illegal as %2$s is not a container", componentType, WXSDKManager.getInstance().getWXRenderManager().getWXComponent(this.getPageId(), this.mParentRef).getComponentType()), (Map<String, String>)ext);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @WorkerThread
    public void setRTL(boolean isRTL) {
        this.isLayoutRTL = isRTL;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @WorkerThread
    public void setSize(GraphicSize graphicSize) {
        this.layoutSize = graphicSize;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @WorkerThread
    public void setPosition(GraphicPosition position) {
        this.layoutPosition = position;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @WorkerThread
    public void setIndex(int index) {
        this.mIndex = index;
    }

    @Override
    public void executeAction() {
        super.executeAction();
        try {
            if (!TextUtils.equals((CharSequence)this.mComponentType, (CharSequence)"video") && !TextUtils.equals((CharSequence)this.mComponentType, (CharSequence)"videoplus")) {
                this.child.mIsAddElementToTree = true;
            }
            long start = WXUtils.getFixUnixTime();
            this.parent.addChild(this.child, this.mIndex);
            this.parent.createChildViewAt(this.mIndex);
            this.child.setIsLayoutRTL(this.isLayoutRTL);
            if (this.layoutPosition != null && this.layoutSize != null) {
                this.child.setDemission(this.layoutSize, this.layoutPosition);
            }
            this.child.applyLayoutAndEvent(this.child);
            this.child.bindData(this.child);
            long diff = WXUtils.getFixUnixTime() - start;
            if (null != this.getWXSDKIntance()) {
                this.getWXSDKIntance().getApmForInstance().viewCreateTime += diff;
            }
        }
        catch (Exception e) {
            WXLogUtils.e("add component failed.", e);
        }
    }
}

