/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio.earmonitor;

import android.text.TextUtils;
import com.tencent.liteav.audio.earmonitor.a;
import com.tencent.liteav.audio.earmonitor.h;
import com.tencent.liteav.audio.earmonitor.i;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;

@JNINamespace(value="liteav::audio")
public abstract class SystemAudioKit {
    private final long mNativeSystemAudioKit;

    @CalledByNative
    public static SystemAudioKit create(long nativeSystemAudioKit) {
        String string = LiteavSystemInfo.getManufacturer();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = string.toLowerCase();
        int n2 = -1;
        switch (string2.hashCode()) {
            case -1206476313: {
                if (!string2.equals("huawei")) break;
                n2 = 0;
                break;
            }
            case 3620012: {
                if (!string2.equals("vivo")) break;
                n2 = 1;
                break;
            }
            case 1864941562: {
                if (!string2.equals("samsung")) break;
                n2 = 2;
            }
        }
        switch (n2) {
            case 0: {
                return new a(nativeSystemAudioKit, ContextUtils.getApplicationContext());
            }
            case 1: {
                return new i(nativeSystemAudioKit, ContextUtils.getApplicationContext());
            }
            case 2: {
                ContextUtils.getApplicationContext();
                return new h(nativeSystemAudioKit);
            }
        }
        return null;
    }

    SystemAudioKit(long nativeSystemAudioKit) {
        this.mNativeSystemAudioKit = nativeSystemAudioKit;
    }

    @CalledByNative
    public abstract void initialize();

    @CalledByNative
    public abstract void terminate();

    @CalledByNative
    public abstract void startEarMonitoring();

    @CalledByNative
    public abstract void stopEarMonitoring();

    @CalledByNative
    public abstract void setEarMonitoringVolume(int var1);

    protected void notifyEarMonitoringInitialized(SystemAudioKit audioKit, boolean success) {
        SystemAudioKit.nativeNotifyEarMonitoringInitialized(this.mNativeSystemAudioKit, audioKit, success);
    }

    protected void notifySystemError(SystemAudioKit audioKit) {
        SystemAudioKit.nativeNotifySystemError(this.mNativeSystemAudioKit, audioKit);
    }

    private static native void nativeNotifyEarMonitoringInitialized(long var0, SystemAudioKit var2, boolean var3);

    private static native void nativeNotifySystemError(long var0, SystemAudioKit var2);
}

