/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services.handler;

import com.ksyun.ks3.exception.Ks3Error;
import com.ksyun.ks3.model.Owner;
import com.ksyun.ks3.model.acl.AccessControlList;
import com.ksyun.ks3.model.acl.AccessControlPolicy;
import com.ksyun.ks3.model.acl.Grant;
import com.ksyun.ks3.model.acl.Grantee;
import com.ksyun.ks3.model.acl.GranteeEmail;
import com.ksyun.ks3.model.acl.GranteeId;
import com.ksyun.ks3.model.acl.GranteeUri;
import com.ksyun.ks3.model.acl.Permission;
import com.ksyun.ks3.services.handler.Ks3HttpResponceHandler;
import cz.msebera.android.httpclient.Header;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public abstract class GetBucketACLResponceHandler
extends Ks3HttpResponceHandler {
    public abstract void onFailure(int var1, Ks3Error var2, Header[] var3, String var4, Throwable var5);

    public abstract void onSuccess(int var1, Header[] var2, AccessControlPolicy var3);

    @Override
    public final void onSuccess(int statesCode, Header[] responceHeaders, byte[] response) {
        this.onSuccess(statesCode, responceHeaders, this.parseXml(responceHeaders, response));
    }

    @Override
    public final void onFailure(int statesCode, Header[] responceHeaders, byte[] response, Throwable throwable) {
        Ks3Error error = new Ks3Error(statesCode, response, throwable);
        this.onFailure(statesCode, error, responceHeaders, response == null ? "" : new String(response), throwable);
    }

    @Override
    public final void onProgress(long bytesWritten, long totalSize) {
    }

    @Override
    public final void onStart() {
    }

    @Override
    public final void onFinish() {
    }

    @Override
    public final void onCancel() {
    }

    private AccessControlPolicy parseXml(Header[] responceHeaders, byte[] response) {
        Grantee grantee = null;
        Grant grant = null;
        AccessControlList accessControlList = null;
        Owner owner = null;
        Permission permission = null;
        AccessControlPolicy accessControlPolicy = null;
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            XmlPullParser parse = factory.newPullParser();
            parse.setInput((InputStream)new ByteArrayInputStream(response), "UTF-8");
            int eventType = parse.getEventType();
            while (1 != eventType) {
                String nodeName = parse.getName();
                switch (eventType) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        if ("AccessControlPolicy".equalsIgnoreCase(nodeName)) {
                            accessControlPolicy = new AccessControlPolicy();
                        }
                        if ("Owner".equalsIgnoreCase(nodeName)) {
                            owner = new Owner();
                            parse.next();
                            nodeName = parse.getName();
                            if ("ID".equalsIgnoreCase(nodeName)) {
                                owner.setId(parse.nextText());
                            }
                            parse.next();
                            nodeName = parse.getName();
                            if ("DisplayName".equalsIgnoreCase(nodeName)) {
                                owner.setDisplayName(parse.nextText());
                            }
                        }
                        if (nodeName.equalsIgnoreCase("AccessControlList")) {
                            accessControlList = new AccessControlList();
                        }
                        if ("Grant".equalsIgnoreCase(nodeName)) {
                            grant = new Grant();
                        }
                        if ("Grantee".equalsIgnoreCase(nodeName)) {
                            parse.next();
                            nodeName = parse.getName();
                            if ("EmailAddress".equalsIgnoreCase(nodeName)) {
                                grantee = new GranteeEmail();
                                grantee.setIdentifier(parse.nextText());
                            } else if ("URI".equalsIgnoreCase(nodeName)) {
                                grantee = GranteeUri.parse(parse.nextText());
                            } else if ("ID".equalsIgnoreCase(nodeName)) {
                                grantee = new GranteeId();
                                grantee.setIdentifier(parse.nextText());
                            }
                        }
                        if (!"Permission".equalsIgnoreCase(nodeName)) break;
                        permission = Permission.getInstance(parse.nextText());
                        break;
                    }
                    case 3: {
                        if (nodeName.equalsIgnoreCase("AccessControlList")) {
                            // empty if block
                        }
                        if ("Grant".equalsIgnoreCase(nodeName)) {
                            grant.setGrantee(grantee);
                            grant.setPermission(permission);
                            accessControlList.addGrant(grant);
                        }
                        if (!"AccessControlPolicy".equalsIgnoreCase(nodeName)) break;
                        accessControlPolicy.setAccessControlList(accessControlList);
                        accessControlPolicy.setOwner(owner);
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                eventType = parse.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return accessControlPolicy;
    }
}

