/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.richtext.node;

import android.content.Context;
import android.text.SpannableStringBuilder;
import com.taobao.weex.dom.TextDecorationSpan;
import com.taobao.weex.dom.WXStyle;
import com.taobao.weex.ui.component.richtext.node.RichTextNode;
import com.taobao.weex.ui.component.richtext.node.RichTextNodeCreator;
import java.util.Map;

class SpanNode
extends RichTextNode {
    public static final String NODE_TYPE = "span";

    private SpanNode(Context context, String instanceId, String componentRef) {
        super(context, instanceId, componentRef);
    }

    private SpanNode(Context context, String instanceId, String componentRef, String ref, Map<String, Object> styles, Map<String, Object> attrs) {
        super(context, instanceId, componentRef, ref, styles, attrs);
    }

    @Override
    public String toString() {
        if (this.attr == null || !this.attr.containsKey("value")) {
            return "";
        }
        return this.attr.get("value").toString();
    }

    @Override
    protected boolean isInternalNode() {
        return true;
    }

    @Override
    protected void updateSpans(SpannableStringBuilder spannableStringBuilder, int level) {
        super.updateSpans(spannableStringBuilder, level);
        spannableStringBuilder.setSpan((Object)new TextDecorationSpan(WXStyle.getTextDecoration(this.style)), 0, spannableStringBuilder.length(), SpanNode.createSpanFlag(level));
    }

    static class SpanNodeCreator
    implements RichTextNodeCreator<SpanNode> {
        SpanNodeCreator() {
        }

        @Override
        public SpanNode createRichTextNode(Context context, String instanceId, String componentRef) {
            return new SpanNode(context, instanceId, componentRef);
        }

        @Override
        public SpanNode createRichTextNode(Context context, String instanceId, String componentRef, String ref, Map<String, Object> styles, Map<String, Object> attrs) {
            return new SpanNode(context, instanceId, componentRef, ref, styles, attrs);
        }
    }
}

