/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.utils;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLException;
import android.opengl.GLUtils;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class EglUtil {
    public static final int NO_TEXTURE = -1;
    private static final int FLOAT_SIZE_BYTES = 4;

    private EglUtil() {
    }

    public static int loadShader(String strSource, int iType) {
        int[] compiled = new int[1];
        int iShader = GLES20.glCreateShader((int)iType);
        GLES20.glShaderSource((int)iShader, (String)strSource);
        GLES20.glCompileShader((int)iShader);
        GLES20.glGetShaderiv((int)iShader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            Log.d((String)"Load Shader Failed", (String)("Compilation\n" + GLES20.glGetShaderInfoLog((int)iShader)));
            return 0;
        }
        return iShader;
    }

    public static int createProgram(int vertexShader, int pixelShader) throws GLException {
        int program = GLES20.glCreateProgram();
        if (program == 0) {
            throw new RuntimeException("Could not create program");
        }
        GLES20.glAttachShader((int)program, (int)vertexShader);
        GLES20.glAttachShader((int)program, (int)pixelShader);
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            GLES20.glDeleteProgram((int)program);
            throw new RuntimeException("Could not link program");
        }
        return program;
    }

    public static void setupSampler(int target, int mag, int min) {
        GLES20.glTexParameterf((int)target, (int)10240, (float)mag);
        GLES20.glTexParameterf((int)target, (int)10241, (float)min);
        GLES20.glTexParameteri((int)target, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)target, (int)10243, (int)33071);
    }

    public static int createBuffer(float[] data) {
        return EglUtil.createBuffer(EglUtil.toFloatBuffer(data));
    }

    public static int createBuffer(FloatBuffer data) {
        int[] buffers = new int[1];
        GLES20.glGenBuffers((int)buffers.length, (int[])buffers, (int)0);
        EglUtil.updateBufferData(buffers[0], data);
        return buffers[0];
    }

    public static FloatBuffer toFloatBuffer(float[] data) {
        FloatBuffer buffer = ByteBuffer.allocateDirect(data.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        buffer.put(data).position(0);
        return buffer;
    }

    public static void updateBufferData(int bufferName, FloatBuffer data) {
        GLES20.glBindBuffer((int)34962, (int)bufferName);
        GLES20.glBufferData((int)34962, (int)(data.capacity() * 4), (Buffer)data, (int)35044);
        GLES20.glBindBuffer((int)34962, (int)0);
    }

    public static int loadTexture(Bitmap img, int usedTexId, boolean recycle) {
        int[] textures = new int[1];
        if (usedTexId == -1) {
            GLES20.glGenTextures((int)1, (int[])textures, (int)0);
            GLES20.glBindTexture((int)3553, (int)textures[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)img, (int)0);
        } else {
            GLES20.glBindTexture((int)3553, (int)usedTexId);
            GLUtils.texSubImage2D((int)3553, (int)0, (int)0, (int)0, (Bitmap)img);
            textures[0] = usedTexId;
        }
        if (recycle) {
            img.recycle();
        }
        return textures[0];
    }
}

