/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.util;

import android.util.Base64;
import android.util.Log;
import com.ksyun.ks3.util.Hex;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Md5Utils {
    private static final int SIXTEEN_K = 16384;

    public static byte[] computeMD5Hash(InputStream is) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            int bytesRead;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[16384];
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            byte[] byArray = messageDigest.digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception e) {
                Log.e((String)"ks3", (String)("Unable to close input stream of hash candidate: " + e));
            }
        }
    }

    public static String md5AsBase64(InputStream is) throws IOException {
        return Base64.encodeToString((byte[])Md5Utils.computeMD5Hash(is), (int)0).trim();
    }

    public static byte[] computeMD5Hash(byte[] input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String md5AsBase64(byte[] input) {
        return Base64.encodeToString((byte[])Md5Utils.computeMD5Hash(input), (int)0).trim();
    }

    public static byte[] computeMD5Hash(File file) throws FileNotFoundException, IOException {
        return Md5Utils.computeMD5Hash(new FileInputStream(file));
    }

    public static String md5AsBase64(File file) throws FileNotFoundException, IOException {
        return Base64.encodeToString((byte[])Md5Utils.computeMD5Hash(file), (int)0).trim();
    }

    public static String MD52ETag(String md5) {
        String etag = String.format("\"%s\"", Hex.encodeHexString(Base64.decode((String)md5, (int)0)));
        Log.i((String)"ks3", (String)("md5 we calculated is :" + md5 + ",convert to etag is :" + etag));
        return etag;
    }

    public static String ETag2MD5(String eTag) {
        String md5 = null;
        if (eTag.length() >= 2) {
            if (eTag.charAt(0) == '\"') {
                eTag = eTag.substring(1, eTag.length() - 1);
            }
            try {
                md5 = new String(Base64.encode((byte[])Hex.decodeHex(eTag.toCharArray()), (int)0), "UTF-8");
            }
            catch (Exception e) {
                Log.e((String)"ks3", (String)("Something Wrong when converter eTag to md5 :" + eTag));
            }
        }
        Log.i((String)"ks3", (String)("etag we calculated is :" + eTag + ",convert to md5 is :" + md5));
        return md5;
    }
}

