/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.module;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecordingConfiguration;
import android.os.Build;
import android.util.Log;
import cn.rongcloud.rtc.api.callback.IRCRTCAudioDataListener;
import cn.rongcloud.rtc.api.stream.RCRTCAudioStreamConfig;
import cn.rongcloud.rtc.audioroute.RCAudioRouteChangeListener;
import cn.rongcloud.rtc.audioroute.RCAudioRouteType;
import cn.rongcloud.rtc.base.RCRTCAudioFrame;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCSyncCallBack;
import cn.rongcloud.rtc.center.config.RCRTCConfigImpl;
import cn.rongcloud.rtc.center.stream.RCAudioStreamConfigImpl;
import cn.rongcloud.rtc.core.AudioSource;
import cn.rongcloud.rtc.core.AudioTrack;
import cn.rongcloud.rtc.core.MediaConstraints;
import cn.rongcloud.rtc.core.RongAudioRecord;
import cn.rongcloud.rtc.core.RongAudioTrack;
import cn.rongcloud.rtc.core.audio.AudioDeviceModule;
import cn.rongcloud.rtc.core.audio.AudioMixerSourceEvents;
import cn.rongcloud.rtc.core.audio.CustomAudioDeviceModule;
import cn.rongcloud.rtc.core.audio.EAudioInput;
import cn.rongcloud.rtc.core.audio.OnAudioBufferAvailableListener;
import cn.rongcloud.rtc.core.audio.OnAudioDeviceErrorListener;
import cn.rongcloud.rtc.core.rongRTC.DevicesUtils;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.plugin.VoiceBeautifierPlugin;
import cn.rongcloud.rtc.recordcallback.RecordCallBackManger;
import cn.rongcloud.rtc.utils.AudioUtil;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.PCMFileWriter;
import cn.rongcloud.rtc.utils.ReportUtil;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class AudioDeviceManager
implements RCAudioRouteChangeListener {
    private static final String TAG = "AudioDeviceManager";
    private static final String AUDIO_GOOGECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    private static final String AUDIO_GOOGECHO_CANCELLATION2_CONSTRAINT = "googEchoCancellation2";
    private static final String AUDIO_GOOGDAE_ECHOCANCELLATION_CONSTRAINT = "googDAEchoCancellation";
    private static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    private static final String AUDIO_EXPERIMENTAL_AGC = "googAutoGainControl2";
    private static final String AUDIO_AGC_TX_AGC_TARGET_DBOV = "txAgcTargetDbov";
    private static final String AUDIO_AGC_TX_AGC_DIGITAL_COMPRESSION_GAIN = "txAgcDigitaCompressionGain";
    private static final String AUDIO_AGC_TX_AGC_LIMITER = "txAgcLimiter";
    private static final String AUDIO_PRE_AMPLIFIER = "preAmplifier";
    private static final String AUDIO_PRE_AMPLIFIER_LEVEL = "fixedGainFactor";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT_LEVEL = "googNoiseSuppressionLevel";
    private static final String AUDIO_EXPERIMENTAL_NS = "googNoiseSuppression2";
    private static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    private static final String AUDIO_TYPING_DETECTION = "googTypingNoiseDetection";
    private static final String AUDIO_RESIDUAL_ECHO_DETECTOR = "residualEchoDetector";
    private static final String AUDIO_DISABLE_COMFORT_NOISE = "disableComfortNoise";
    private static final String AUDIO_STEREO_SWAPPING = "googAudioMirroring";
    private static final String AUDIO_JITTER_BUFFER_MAX_PACKETS = "jitterBufferMaxPackets";
    private static final String AUDIO_JITTER_BUFFER_FAST_ACCELERATE = "jitterBufferFastAccelerate";
    private static final String AUDIO_JITTER_BUFFER_MIN_DELAY_MS = "jitterBufferMinDelayMs";
    private static final String AUDIO_JITTER_BUFFER_ENABLE_RTX_HANDLING = "jitterBufferEnableRtxHandling";
    private static final int DEFAULT_RECORDING_VOLUME = 100;
    private final double DEFAULT_AUDIO_PERCENT = 1.0;
    private final double MUSIC_AUDIO_PERCENT = 1.0;
    private double audioPercent = 1.0;
    private AudioDeviceModule audioDeviceModule;
    private boolean isAudioMute;
    private boolean isEcho;
    private RongAudioRecord rongAudioRecord;
    private MediaConstraints audioConstraints;
    private static final Map<String, Integer> AGC_CONFIG_MAP = new HashMap<String, Integer>();
    private RCAudioStreamConfigImpl audioConfig;
    private int recordingVolume = 100;
    private byte[] localFrame;
    private byte[] localMixedFrame;
    private RCRTCAudioFrame RCRTCAudioFrame = null;
    private RCRTCAudioFrame mixedAudioFrame = null;
    private IRCRTCAudioDataListener mAudioDataListener;
    private IRCRTCAudioDataListener mMixedAudioDataListener;
    private List<OnAudioBufferAvailableListener> audioBufferListeners = new CopyOnWriteArrayList<OnAudioBufferAvailableListener>();
    private AudioManager audioManager;
    private RecordCallBackManger recordCallBackManger;
    private RongAudioTrack mRongAudioTrack;
    private VoiceBeautifierPlugin voiceBeautifierPlugin;
    private RCRTCParamsType.AudioScenario audioScenario;
    private boolean earphoneEnable = false;
    private PCMFileWriter preMicFile;
    private boolean storePreData = false;
    private boolean rtcProbeEnable;
    private Object releaseLock = new Object();
    private boolean isReleased = false;
    private EAudioInput preAudioInputType;
    private AudioMixerSourceEvents mixerSourceEvents;
    private RCRTCConfigImpl rtcConfig;
    private AudioManager.AudioRecordingCallback mAudioRecordingCallback;
    OnAudioBufferAvailableListener mPreListener;
    OnAudioBufferAvailableListener mPostListener;
    OnAudioDeviceErrorListener mErrorListener;

    public AudioDeviceManager(Context context, RCRTCConfigImpl rtcConfig, RCAudioStreamConfigImpl audioConfig, AudioMixerSourceEvents mixerSourceEvents) {
        this.audioConfig = audioConfig;
        this.audioManager = this.getAudioManager(context);
        this.recordCallBackManger = new RecordCallBackManger();
        this.recordCallBackManger.init();
        this.mixerSourceEvents = mixerSourceEvents;
        this.audioScenario = RCRTCParamsType.AudioScenario.DEFAULT;
        this.registerAudioRecordingCallback();
        this.initLocalSource();
        this.initAudioDeviceModule(context, rtcConfig, mixerSourceEvents);
    }

    private int getRecordAudioSourceByModule() {
        return RTCEngineImpl.getInstance().getRecordAudioSource();
    }

    public void setVoiceBeautifier(VoiceBeautifierPlugin plugin) {
        if (this.audioDeviceModule != null) {
            this.audioDeviceModule.setVoiceBeautifier(plugin);
        }
        this.voiceBeautifierPlugin = plugin;
    }

    private void registerAudioRecordingCallback() {
        if (Build.VERSION.SDK_INT >= 24 && this.audioManager != null) {
            if (this.mAudioRecordingCallback == null) {
                this.mAudioRecordingCallback = new AudioManager.AudioRecordingCallback(){

                    public void onRecordingConfigChanged(List<AudioRecordingConfiguration> configs) {
                        super.onRecordingConfigChanged(configs);
                        AudioDeviceManager.this.recordCallBackManger.monitor(configs);
                    }
                };
            }
            this.audioManager.registerAudioRecordingCallback(this.mAudioRecordingCallback, RTCEngineImpl.getInstance().getHandler());
        }
    }

    private void unregisterAudioRecordingCallback() {
        if (Build.VERSION.SDK_INT >= 24 && this.audioManager != null && this.mAudioRecordingCallback != null) {
            this.audioManager.unregisterAudioRecordingCallback(this.mAudioRecordingCallback);
        }
    }

    private AudioManager getAudioManager(Context context) {
        if (context == null) {
            return null;
        }
        AudioManager audioMgr = (AudioManager)context.getSystemService("audio");
        return audioMgr;
    }

    @Override
    public void onAudioRouteChanged(RCAudioRouteType currentType) {
        switch (currentType) {
            case HEADSET: {
                this.setEarphoneOn(true);
                this.earphoneEnable = true;
                break;
            }
            default: {
                this.setEarphoneOn(false);
                this.earphoneEnable = false;
            }
        }
        ReportUtil.libStatus(ReportUtil.TAG.EARPHONE_ENABLE, "earphoneType|audioScenario", currentType.name(), this.audioScenario.name());
        this.switchAudioRecorder(this.audioScenario, this.earphoneEnable);
    }

    private void initLocalSource() {
        this.switchAudioTrack(this.audioConfig.getAudioEFCTMode());
        Log.d((String)TAG, (String)"initLocalSource: ");
        this.createMediaConstraints(false);
    }

    private void initAudioDeviceModule(Context context, final RCRTCConfigImpl rtcConfig, AudioMixerSourceEvents mixerSourceEvents) {
        OnAudioDeviceErrorListener onAudioDeviceErrorListener;
        OnAudioBufferAvailableListener preListener;
        this.rtcConfig = rtcConfig;
        this.mPreListener = preListener = new OnAudioBufferAvailableListener(){
            byte[] emptyData;

            @Override
            public void onAudioBuffer(ByteBuffer byteBuffer, int sizeInBytes, int sampleRate, int channelCount, int audioFormat) {
                if (AudioDeviceManager.this.rtcProbeEnable) {
                    return;
                }
                if (AudioDeviceManager.this.isAudioMute) {
                    if (this.emptyData == null || this.emptyData.length != sizeInBytes) {
                        this.emptyData = new byte[sizeInBytes];
                    }
                    byteBuffer.clear();
                    byteBuffer.put(this.emptyData);
                }
                AudioUtil.adjustVolumeAsShort(byteBuffer, AudioUtil.linearToLog((int)((double)AudioDeviceManager.this.recordingVolume * AudioDeviceManager.this.audioPercent)));
                AudioDeviceManager.this.storePreData(byteBuffer, sampleRate, channelCount, audioFormat);
                if (!AudioDeviceManager.this.isAudioMute && rtcConfig.isMicrophoneEnable() && AudioDeviceManager.this.mAudioDataListener != null) {
                    if (AudioDeviceManager.this.localFrame == null || AudioDeviceManager.this.localFrame.length != sizeInBytes) {
                        AudioDeviceManager.access$702(AudioDeviceManager.this, new byte[sizeInBytes]);
                    }
                    byteBuffer.rewind();
                    byteBuffer.get(AudioDeviceManager.this.localFrame, 0, AudioDeviceManager.this.localFrame.length);
                    if (AudioDeviceManager.this.RCRTCAudioFrame == null) {
                        AudioDeviceManager.this.RCRTCAudioFrame = new RCRTCAudioFrame();
                    }
                    AudioDeviceManager.this.RCRTCAudioFrame.setBytes(AudioDeviceManager.this.localFrame);
                    AudioDeviceManager.this.RCRTCAudioFrame.setChannels(channelCount);
                    AudioDeviceManager.this.RCRTCAudioFrame.setSampleRate(sampleRate);
                    AudioDeviceManager.this.RCRTCAudioFrame.setBytesPerSample(audioFormat == 2 ? 2 : 1);
                    byte[] tmp = null;
                    if (AudioDeviceManager.this.mAudioDataListener != null) {
                        tmp = AudioDeviceManager.this.mAudioDataListener.onAudioFrame(AudioDeviceManager.this.RCRTCAudioFrame);
                    }
                    if (tmp != null) {
                        if (tmp.length == byteBuffer.capacity()) {
                            byteBuffer.clear();
                            byteBuffer.put(tmp);
                        } else {
                            FinLog.e(AudioDeviceManager.TAG, "Error:The processed data is not the same length as the original data.");
                        }
                        tmp = null;
                    }
                }
            }
        };
        OnAudioBufferAvailableListener postListener = new OnAudioBufferAvailableListener(){

            @Override
            public void onAudioBuffer(ByteBuffer byteBuffer, int sizeInBytes, int sampleRate, int channelCount, int audioFormat) {
                if (AudioDeviceManager.this.rtcProbeEnable) {
                    return;
                }
                if (AudioDeviceManager.this.voiceBeautifierPlugin != null) {
                    AudioDeviceManager.this.voiceBeautifierPlugin.process(byteBuffer, sizeInBytes);
                }
                for (OnAudioBufferAvailableListener listener : AudioDeviceManager.this.audioBufferListeners) {
                    listener.onAudioBuffer(byteBuffer, sizeInBytes, sampleRate, channelCount, audioFormat);
                }
                if (AudioDeviceManager.this.mMixedAudioDataListener != null) {
                    if (AudioDeviceManager.this.localMixedFrame == null || AudioDeviceManager.this.localMixedFrame.length != sizeInBytes) {
                        AudioDeviceManager.access$1202(AudioDeviceManager.this, new byte[sizeInBytes]);
                    }
                    byteBuffer.clear();
                    byteBuffer.get(AudioDeviceManager.this.localMixedFrame, 0, AudioDeviceManager.this.localMixedFrame.length);
                    if (AudioDeviceManager.this.mixedAudioFrame == null) {
                        AudioDeviceManager.this.mixedAudioFrame = new RCRTCAudioFrame();
                    }
                    AudioDeviceManager.this.mixedAudioFrame.setBytes(AudioDeviceManager.this.localMixedFrame);
                    AudioDeviceManager.this.mixedAudioFrame.setChannels(channelCount);
                    AudioDeviceManager.this.mixedAudioFrame.setSampleRate(sampleRate);
                    AudioDeviceManager.this.mixedAudioFrame.setBytesPerSample(audioFormat == 2 ? 2 : 1);
                    if (AudioDeviceManager.this.mMixedAudioDataListener != null) {
                        AudioDeviceManager.this.mMixedAudioDataListener.onAudioFrame(AudioDeviceManager.this.mixedAudioFrame);
                    }
                }
            }
        };
        RongAudioRecord audioRecord = new RongAudioRecord(this.audioManager, this.recordCallBackManger);
        this.mPostListener = postListener;
        this.rongAudioRecord = audioRecord;
        this.mRongAudioTrack = new RongAudioTrack();
        this.mErrorListener = onAudioDeviceErrorListener = new OnAudioDeviceErrorListener(){

            @Override
            public void onAudioDeviceError(int errorCode) {
                if (AudioDeviceManager.this.rtcProbeEnable) {
                    return;
                }
                String device = "Device";
                if (errorCode == -1) {
                    device = "Engine";
                } else if (errorCode == -2) {
                    device = "Recorder";
                } else if (errorCode == -3) {
                    device = "Player";
                }
                ReportUtil.libError(ReportUtil.TAG.OPENSLES_DEVICE_ERR, "code|desc", errorCode, "OpenSLES " + device + " Error");
                ReportUtil.libTask(ReportUtil.TAG.CHANGEAUDIOINPUT, "reason|target", "OpenSLES error", "audiorecord");
                AudioDeviceManager.this.audioDeviceModule.changeAudioInput(CustomAudioDeviceModule.builder(RTCEngineImpl.getInstance().getContext()).setAudioManager(AudioDeviceManager.this.audioManager).setAudioSource(AudioDeviceManager.this.getRecordAudioSourceByModule()).setSampleRate(RTCEngineImpl.getInstance().getRTCConfig().getAudioSampleRate()).setUseStereoInput(RTCEngineImpl.getInstance().getRTCConfig().isStereo()).setUseStereoOutput(RTCEngineImpl.getInstance().getRTCConfig().isStereo()).setAudioRecordProxy(AudioDeviceManager.this.rongAudioRecord).setAudioTrackProxy(AudioDeviceManager.this.mRongAudioTrack).setPreListener(AudioDeviceManager.this.mPreListener).setPostListener(AudioDeviceManager.this.mPostListener).setErrorListener(AudioDeviceManager.this.mErrorListener).setMute(AudioDeviceManager.this.isAudioMute).setAudioInputType(EAudioInput.AUDIORECORD));
            }
        };
        CustomAudioDeviceModule.Builder builder = CustomAudioDeviceModule.builder(context).setAudioManager(this.audioManager).setAudioSource(this.getRecordAudioSourceByModule()).setSampleRate(rtcConfig.getAudioSampleRate()).setUseStereoInput(rtcConfig.isStereo()).setUseStereoOutput(rtcConfig.isStereo()).setAudioRecordProxy(audioRecord).setMixerSourceEvents(mixerSourceEvents).setAudioTrackProxy(this.mRongAudioTrack).setPreListener(preListener).setPostListener(postListener).setErrorListener(onAudioDeviceErrorListener);
        if (rtcConfig.isLowLatencyRecordingEnabled()) {
            builder.setAudioInputType(EAudioInput.OPENSLES);
        } else {
            builder.setAudioInputType(EAudioInput.AUDIORECORD);
        }
        this.audioDeviceModule = builder.createAudioDeviceModule();
    }

    public void setEcho(boolean enable) {
        if (RTCEngineImpl.getInstance().getRTCConfig().isLowLatencyRecordingEnabled()) {
            this.audioDeviceModule.setEcho(enable);
        } else {
            CustomAudioDeviceModule.Builder builder = CustomAudioDeviceModule.builder(RTCEngineImpl.getInstance().getContext()).setAudioManager(this.audioManager).setAudioSource(this.getRecordAudioSourceByModule()).setSampleRate(RTCEngineImpl.getInstance().getRTCConfig().getAudioSampleRate()).setUseStereoInput(RTCEngineImpl.getInstance().getRTCConfig().isStereo()).setUseStereoOutput(RTCEngineImpl.getInstance().getRTCConfig().isStereo()).setAudioRecordProxy(this.rongAudioRecord).setAudioTrackProxy(this.mRongAudioTrack).setPreListener(this.mPreListener).setPostListener(this.mPostListener).setErrorListener(this.mErrorListener).setMixerSourceEvents(this.mixerSourceEvents).setEcho(enable).setMute(this.isAudioMute);
            if (enable) {
                ReportUtil.libTask(ReportUtil.TAG.CHANGEAUDIOINPUT, "reason|target", "setEcho", "opensles");
                this.audioDeviceModule.changeAudioInput(builder.setAudioInputType(EAudioInput.OPENSLES));
            } else {
                ReportUtil.libTask(ReportUtil.TAG.CHANGEAUDIOINPUT, "reason|target", "setEcho", "audiorecord");
                this.audioDeviceModule.changeAudioInput(builder.setAudioInputType(EAudioInput.AUDIORECORD));
            }
        }
    }

    public AudioDeviceModule getAudioDeviceModule() {
        return this.audioDeviceModule;
    }

    public boolean isRecording() {
        if (this.rongAudioRecord != null) {
            return this.rongAudioRecord.isRecording();
        }
        return false;
    }

    public void muteAudio(boolean isMute) {
        if (this.audioDeviceModule != null) {
            this.audioDeviceModule.setMicrophoneMute(isMute);
        }
        this.isAudioMute = isMute;
    }

    public boolean isAudioMute() {
        return this.isAudioMute;
    }

    private MediaConstraints refreshAudioConstraints(RCRTCParamsType.AudioScenario audioScenario, RCRTCSyncCallBack otherActions) {
        boolean disableComfortNoise = true;
        if (audioScenario == RCRTCParamsType.AudioScenario.MUSIC_CLASSROOM) {
            this.audioPercent = 1.0;
            this.audioConfig = (RCAudioStreamConfigImpl)RCRTCAudioStreamConfig.Builder.create().buildMusicClassRoomMode();
            disableComfortNoise = true;
        } else if (audioScenario == RCRTCParamsType.AudioScenario.MUSIC_CHATROOM) {
            this.audioPercent = 1.0;
            this.audioConfig = (RCAudioStreamConfigImpl)RCRTCAudioStreamConfig.Builder.create().buildMusicChatRoomMode();
            disableComfortNoise = true;
        } else {
            this.audioPercent = 1.0;
            this.audioConfig = (RCAudioStreamConfigImpl)RCRTCAudioStreamConfig.Builder.create().buildDefaultMode();
            disableComfortNoise = false;
        }
        if (otherActions != null) {
            otherActions.syncActions();
        }
        Log.d((String)TAG, (String)"refreshAudioConstraints: ");
        this.createMediaConstraints(disableComfortNoise);
        return this.audioConstraints;
    }

    public void switchSpeechMusicMode(AudioTrack audioTrack, RCRTCParamsType.AudioScenario audioScenario, RCRTCSyncCallBack otherActions) {
        Log.d((String)TAG, (String)("- switchSpeechMusicMode() audioScenario:" + (Object)((Object)audioScenario)));
        this.switchAudioConstraints(audioScenario, otherActions, audioTrack);
        this.switchAudioTrack(audioScenario);
        this.audioScenario = audioScenario;
        ReportUtil.libStatus(ReportUtil.TAG.EARPHONE_MUSIC_MODE, "earphoneEnable|musicMode", this.earphoneEnable, this.audioScenario.name());
        this.switchAudioRecorder(audioScenario, this.earphoneEnable);
    }

    private synchronized void switchAudioRecorder(RCRTCParamsType.AudioScenario audioScenario, boolean earphoneEnable) {
        if (this.audioManager == null) {
            FinLog.e(TAG, "switchAudioRecorder failed ! audioManager is null");
            return;
        }
        boolean earphoneState = false;
        if (audioScenario != RCRTCParamsType.AudioScenario.DEFAULT || earphoneEnable) {
            String response = this.audioManager.getProperty("android.media.property.SUPPORT_AUDIO_SOURCE_UNPROCESSED");
            if (response != null) {
                FinLog.w(TAG, "can not response for unprocessed audio source");
            }
            int audioSource = 0;
            ReportUtil.libStatus(ReportUtil.TAG.EARPHONE_AUDIO_SOURCE, "earphoneEnable|audioSource", earphoneEnable, audioSource);
            this.audioManager.setMode(0);
            RTCEngineImpl.getInstance().addAudioSource(RTCEngineImpl.EAudioSource.MUSICMODE, audioSource);
            Log.d((String)TAG, (String)"- switchAudioRecorder()- setMode:AudioManager.MODE_NORMAL");
        } else {
            this.audioManager.setMode(3);
            RTCEngineImpl.getInstance().removeAudioSource(RTCEngineImpl.EAudioSource.MUSICMODE);
            Log.d((String)TAG, (String)"- switchAudioRecorder()- setMode:AudioManager.MODE_IN_COMMUNICATION");
        }
        if (this.rongAudioRecord != null) {
            this.rongAudioRecord.setEarphoneState(earphoneEnable);
            this.rongAudioRecord.switchAudioSource();
        }
    }

    private int getDefaultAudioSource() {
        if (this.rtcConfig != null) {
            return this.rtcConfig.getAudioSource();
        }
        return 7;
    }

    private void switchAudioTrack(RCRTCParamsType.AudioScenario mode) {
        if (mode == RCRTCParamsType.AudioScenario.MUSIC_CLASSROOM || mode == RCRTCParamsType.AudioScenario.MUSIC_CHATROOM) {
            DevicesUtils.setPlayMode(DevicesUtils.AudioPlayMode.MUSIC);
        } else {
            DevicesUtils.setPlayMode(DevicesUtils.AudioPlayMode.SPEECH);
        }
        if (this.mRongAudioTrack != null) {
            this.mRongAudioTrack.reCreateAudioTrack();
        }
    }

    public IRCRTCAudioDataListener getAudioDataListener() {
        return this.mAudioDataListener;
    }

    public void setAudioDataListener(IRCRTCAudioDataListener audioDataListener) {
        this.mAudioDataListener = audioDataListener;
    }

    public void setMixedAudioDataListener(IRCRTCAudioDataListener audioDataListener) {
        this.mMixedAudioDataListener = audioDataListener;
    }

    public void registerAudioBufferListener(OnAudioBufferAvailableListener listener) {
        this.audioBufferListeners.add(listener);
    }

    public void unregisterAudioBufferListener(OnAudioBufferAvailableListener listener) {
        this.audioBufferListeners.remove(listener);
    }

    private void clearAudioBufferListeners() {
        this.audioBufferListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.releaseLock;
        synchronized (object) {
            this.isReleased = true;
            this.clearAudioBufferListeners();
            this.isAudioMute = false;
            this.mAudioDataListener = null;
            this.mMixedAudioDataListener = null;
            this.mRongAudioTrack = null;
            this.unregisterAudioRecordingCallback();
            if (this.audioDeviceModule != null) {
                this.audioDeviceModule.release();
            }
            if (this.preMicFile != null) {
                this.preMicFile.close();
                this.preMicFile = null;
            }
            this.storePreData = false;
        }
    }

    public void adjustRecordingVolume(int volume) {
        this.recordingVolume = volume;
    }

    public int getRecodVolume() {
        return this.recordingVolume;
    }

    @Deprecated
    public void updateAudioConfig(RCRTCAudioStreamConfig config, AudioTrack audioTrack) {
        this.audioConfig = (RCAudioStreamConfigImpl)config;
        this.createMediaConstraints(false);
        this.updateAudioConstraints(audioTrack);
    }

    private void switchAudioConstraints(RCRTCParamsType.AudioScenario audioScenario, RCRTCSyncCallBack otherActions, AudioTrack audioTrack) {
        this.refreshAudioConstraints(audioScenario, otherActions);
        this.updateAudioConstraints(audioTrack);
    }

    private void updateAudioConstraints(AudioTrack audioTrack) {
        AudioSource audioSource;
        if (audioTrack != null && (audioSource = audioTrack.getAudioSource()) != null) {
            audioTrack.setEnabled(false);
            Log.d((String)TAG, (String)("updateAudioConfig: \uff1a" + this.audioConstraints.toString()));
            audioSource.updateOptions(this.audioConstraints);
            audioTrack.setEnabled(true);
        } else {
            RTCEngineImpl.getInstance().sendMessage(2062, (Object)this.audioConstraints);
        }
    }

    private void storePreData(ByteBuffer data, int sampleRate, int channels, int byteFormat) {
        if (!this.storePreData) {
            if (this.preMicFile != null) {
                this.preMicFile.close();
                this.preMicFile = null;
            }
            return;
        }
        if (this.preMicFile == null) {
            this.preMicFile = new PCMFileWriter("preMic", sampleRate, channels, byteFormat);
        }
        this.preMicFile.write(data);
    }

    private void setEarphoneOn(boolean status) {
        FinLog.d(TAG, "setEarphoneOn: " + status);
        RTCEngineImpl.getInstance().sendMessage(2088, (Object)status);
    }

    public void setRemoteAudioPCMBufferListener(IRCRTCAudioDataListener listener) {
        if (this.mRongAudioTrack != null) {
            this.mRongAudioTrack.setAudioDataListener(listener);
        }
    }

    public void muteAllRemoteAudio(boolean mute) {
        if (this.audioDeviceModule != null) {
            this.audioDeviceModule.setSpeakerMute(mute);
        }
    }

    public void resetAudioInput() {
        if (this.audioDeviceModule != null) {
            CustomAudioDeviceModule.Builder builder = CustomAudioDeviceModule.builder(RTCEngineImpl.getInstance().getContext()).setAudioManager(this.audioManager).setAudioSource(this.getRecordAudioSourceByModule()).setSampleRate(RTCEngineImpl.getInstance().getRTCConfig().getAudioSampleRate()).setUseStereoInput(RTCEngineImpl.getInstance().getRTCConfig().isStereo()).setUseStereoOutput(RTCEngineImpl.getInstance().getRTCConfig().isStereo()).setAudioRecordProxy(this.rongAudioRecord).setAudioTrackProxy(this.mRongAudioTrack).setPreListener(this.mPreListener).setMixerSourceEvents(this.mixerSourceEvents).setPostListener(this.mPostListener).setErrorListener(this.mErrorListener).setMute(this.isAudioMute);
            if (RTCEngineImpl.getInstance().getRTCConfig().isLowLatencyRecordingEnabled()) {
                builder.setAudioInputType(EAudioInput.OPENSLES);
            } else {
                builder.setAudioInputType(EAudioInput.AUDIORECORD);
            }
            this.audioDeviceModule.changeAudioInput(builder);
            ReportUtil.libRes(ReportUtil.TAG.RESETAUDIOINPUT);
        }
    }

    public MediaConstraints getAudioConstraints() {
        Log.d((String)TAG, (String)("getAudioConstraints: " + this.audioConstraints.toString()));
        return this.audioConstraints;
    }

    protected void createMediaConstraints(boolean disableComfortNoise) {
        this.audioConstraints = new MediaConstraints();
        FinLog.v(TAG, "audioConfig: highPassFilter: isOn = " + this.audioConfig.isHighPassFilters());
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_HIGH_PASS_FILTER_CONSTRAINT, String.valueOf(this.audioConfig.isHighPassFilters())));
        FinLog.v(TAG, "audioConfig: echo cancel: mode " + this.audioConfig.getEchoCancel().name() + " filter " + this.audioConfig.isEchoFilter());
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_GOOGECHO_CANCELLATION_CONSTRAINT, String.valueOf(this.audioConfig.getEchoCancel() == RCRTCParamsType.AECMode.AEC_MODE1)));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_GOOGDAE_ECHOCANCELLATION_CONSTRAINT, String.valueOf(this.audioConfig.getEchoCancel() == RCRTCParamsType.AECMode.AEC_MODE2)));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_GOOGECHO_CANCELLATION2_CONSTRAINT, String.valueOf(this.audioConfig.isEchoFilter())));
        FinLog.v(TAG, "audioConfig: noise suppression: mode " + this.audioConfig.getNoiseSuppression().getValue() + " level " + this.audioConfig.getNoiseSuppressionLevel().getValue());
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_TYPING_DETECTION, "false"));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_RESIDUAL_ECHO_DETECTOR, "false"));
        switch (this.audioConfig.getNoiseSuppression()) {
            case NS_MODE0: {
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_EXPERIMENTAL_NS, "false"));
                break;
            }
            case NS_MODE1: {
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_EXPERIMENTAL_NS, "true"));
                break;
            }
            case NS_MODE2: {
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "true"));
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_EXPERIMENTAL_NS, "false"));
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT_LEVEL, String.valueOf(this.audioConfig.getNoiseSuppressionLevel().getValue())));
                break;
            }
            case NS_MODE3: {
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "true"));
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_EXPERIMENTAL_NS, "true"));
                this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT_LEVEL, String.valueOf(this.audioConfig.getNoiseSuppressionLevel().getValue())));
            }
        }
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_DISABLE_COMFORT_NOISE, String.valueOf(disableComfortNoise)));
        FinLog.v(TAG, "audioConfig: agc: isOn " + this.audioConfig.isAGCControl());
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT, String.valueOf(this.audioConfig.isAGCControl())));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_EXPERIMENTAL_AGC, "false"));
        FinLog.v(TAG, "audioConfig: agc config: targetDBOV " + this.audioConfig.getAGCTargetdbov() + " compressionLevel " + this.audioConfig.getAgcCompression());
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AGC_TX_AGC_LIMITER, "true"));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AGC_TX_AGC_TARGET_DBOV, String.valueOf(this.audioConfig.getAGCTargetdbov())));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AGC_TX_AGC_DIGITAL_COMPRESSION_GAIN, String.valueOf(this.audioConfig.getAgcCompression())));
        FinLog.v(TAG, "audioConfig: agc config: MIC PreAmplifier isOn " + this.audioConfig.isPreAmplifier() + " MIC level " + this.audioConfig.getPreAmplifierLevel());
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_PRE_AMPLIFIER, String.valueOf(this.audioConfig.isPreAmplifier())));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_PRE_AMPLIFIER_LEVEL, String.valueOf(this.audioConfig.getPreAmplifierLevel())));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_JITTER_BUFFER_MIN_DELAY_MS, "true"));
        this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_JITTER_BUFFER_ENABLE_RTX_HANDLING, "true"));
        Log.d((String)TAG, (String)("createMediaConstraints: " + this.audioConstraints.toString()));
    }

    public void resetData() {
        this.isAudioMute = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enableRTCProbe(boolean enable) {
        FinLog.d(TAG, "[enableRTCProbe] ==> enable:" + enable);
        Object object = this.releaseLock;
        synchronized (object) {
            if (this.isReleased) {
                return false;
            }
            this.rtcProbeEnable = enable;
            if (this.rongAudioRecord != null) {
                this.rongAudioRecord.enableRTCProbe(enable);
            }
            if (this.mRongAudioTrack != null) {
                this.mRongAudioTrack.enableRTCProbe(enable);
            }
            if (!(this.audioDeviceModule instanceof CustomAudioDeviceModule)) {
                FinLog.e(TAG, "[enableRTCProbe] ==>  audioDeviceModule is not instanceof CustomAudioDeviceModule");
                return false;
            }
            CustomAudioDeviceModule deviceModule = (CustomAudioDeviceModule)this.audioDeviceModule;
            CustomAudioDeviceModule.Builder builder = deviceModule.getBuilder();
            if (enable) {
                if (builder.getAudioInputType() != EAudioInput.AUDIORECORD) {
                    this.preAudioInputType = builder.getAudioInputType();
                    builder.setAudioInputType(EAudioInput.AUDIORECORD);
                    deviceModule.changeAudioInput(builder);
                }
            } else if (this.preAudioInputType != null && this.preAudioInputType != builder.getAudioInputType()) {
                builder.setAudioInputType(this.preAudioInputType);
                deviceModule.changeAudioInput(builder);
                this.preAudioInputType = null;
            }
            return true;
        }
    }

    static /* synthetic */ byte[] access$702(AudioDeviceManager x0, byte[] x1) {
        x0.localFrame = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$1202(AudioDeviceManager x0, byte[] x1) {
        x0.localMixedFrame = x1;
        return x1;
    }

    static {
        AGC_CONFIG_MAP.put("Nexus 5", 6);
    }
}

