/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.heytap.mcssdk.PushService;
import com.heytap.mcssdk.utils.LogUtil;

public class Utils {
    public static int parseInt(String str) {
        int i = -1;
        if (!TextUtils.isEmpty((CharSequence)str)) {
            try {
                i = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                LogUtil.e("parseInt--NumberFormatException" + e.getMessage());
            }
        }
        return i;
    }

    public static boolean isExistPackage(Context context, String pkgName) {
        try {
            PackageManager pm = context.getPackageManager();
            pm.getPackageInfo(pkgName, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            LogUtil.e("isExistPackage NameNotFoundException:" + e.getMessage());
            return false;
        }
    }

    public static boolean isSupportPush(Context context, String packageName, String metaName) {
        ApplicationInfo appInfo = null;
        try {
            appInfo = context.getPackageManager().getApplicationInfo(packageName, 128);
        }
        catch (PackageManager.NameNotFoundException e) {
            LogUtil.e("isSupportPush NameNotFoundException:" + e.getMessage());
        }
        return null != appInfo && appInfo.metaData.getBoolean(metaName, false);
    }

    public static int getVersionCode(Context context, String pkgName) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(pkgName, 0);
            return info.versionCode;
        }
        catch (Exception e) {
            LogUtil.d("getVersionCode--Exception:" + e.getMessage());
            return 0;
        }
    }

    public static String getVersionName(Context context, String pkgName) {
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(pkgName, 0);
            return info.versionName;
        }
        catch (Exception e) {
            LogUtil.d("getVersionName--Exception:" + e.getMessage());
            return null;
        }
    }

    public static String getVersionName(Context context) {
        String versionName = "0";
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            versionName = info.versionName;
        }
        catch (Exception ignored) {
            LogUtil.d("getVersionName--Exception:" + ignored.getMessage());
        }
        return versionName;
    }

    public static int getVersionCode(Context context) {
        int versionCode = 0;
        try {
            PackageManager manager = context.getPackageManager();
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            versionCode = info.versionCode;
        }
        catch (Exception ignored) {
            LogUtil.d("getVersionCode--Exception:" + ignored.getMessage());
        }
        return versionCode;
    }

    public static String getString(int[] array) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i : array) {
            stringBuilder.append((char)i);
        }
        return stringBuilder.toString();
    }

    public static boolean isSupportPushByClient(Context context) {
        return PushService.getInstance().isSupportPushByClient(context);
    }
}

