/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.filter;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Size;
import com.daasuu.mp4compose.filter.GlFilter;

public abstract class GlOverlayFilter
extends GlFilter {
    private int[] textures = new int[1];
    private Bitmap bitmap = null;
    protected Size inputResolution = new Size(1280, 720);
    private static final String FRAGMENT_SHADER = "precision mediump float;\nvarying vec2 vTextureCoord;\nuniform lowp sampler2D sTexture;\nuniform lowp sampler2D oTexture;\nvoid main() {\n   lowp vec4 textureColor = texture2D(sTexture, vTextureCoord);\n   lowp vec4 textureColor2 = texture2D(oTexture, vTextureCoord);\n   \n   gl_FragColor = mix(textureColor, textureColor2, textureColor2.a);\n}\n";

    public GlOverlayFilter() {
        super("attribute highp vec4 aPosition;\nattribute highp vec4 aTextureCoord;\nvarying highp vec2 vTextureCoord;\nvoid main() {\ngl_Position = aPosition;\nvTextureCoord = aTextureCoord.xy;\n}\n", FRAGMENT_SHADER);
    }

    public void setResolution(Size resolution) {
        this.inputResolution = resolution;
    }

    @Override
    public void setFrameSize(int width, int height) {
        super.setFrameSize(width, height);
        this.setResolution(new Size(width, height));
    }

    private void createBitmap() {
        GlOverlayFilter.releaseBitmap(this.bitmap);
        this.bitmap = Bitmap.createBitmap((int)this.inputResolution.getWidth(), (int)this.inputResolution.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    @Override
    public void setup() {
        super.setup();
        GLES20.glGenTextures((int)1, (int[])this.textures, (int)0);
        GLES20.glBindTexture((int)3553, (int)this.textures[0]);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        this.createBitmap();
    }

    @Override
    public void onDraw() {
        if (this.bitmap == null) {
            this.createBitmap();
        }
        if (this.bitmap.getWidth() != this.inputResolution.getWidth() || this.bitmap.getHeight() != this.inputResolution.getHeight()) {
            this.createBitmap();
        }
        this.bitmap.eraseColor(Color.argb((int)0, (int)0, (int)0, (int)0));
        Canvas bitmapCanvas = new Canvas(this.bitmap);
        bitmapCanvas.scale(1.0f, -1.0f, (float)(bitmapCanvas.getWidth() / 2), (float)(bitmapCanvas.getHeight() / 2));
        this.drawCanvas(bitmapCanvas);
        int offsetDepthMapTextureUniform = this.getHandle("oTexture");
        GLES20.glActiveTexture((int)33987);
        GLES20.glBindTexture((int)3553, (int)this.textures[0]);
        if (this.bitmap != null && !this.bitmap.isRecycled()) {
            GLUtils.texImage2D((int)3553, (int)0, (int)6408, (Bitmap)this.bitmap, (int)0);
        }
        GLES20.glUniform1i((int)offsetDepthMapTextureUniform, (int)3);
    }

    protected abstract void drawCanvas(Canvas var1);

    public static void releaseBitmap(Bitmap bitmap) {
        if (bitmap != null && !bitmap.isRecycled()) {
            bitmap.recycle();
            bitmap = null;
        }
    }
}

