/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import cn.rongcloud.rtc.core.H264Utils;
import cn.rongcloud.rtc.core.LibvpxH264Encoder;
import cn.rongcloud.rtc.core.LibvpxVp8Encoder;
import cn.rongcloud.rtc.core.LibvpxVp9Encoder;
import cn.rongcloud.rtc.core.Logging;
import cn.rongcloud.rtc.core.VideoCodecInfo;
import cn.rongcloud.rtc.core.VideoEncoder;
import cn.rongcloud.rtc.core.VideoEncoderFactory;
import java.util.ArrayList;

public class SoftwareVideoEncoderFactory
implements VideoEncoderFactory {
    private static final String TAG = "SoftwareVideoEncoderFac";

    @Override
    public VideoEncoder createEncoder(VideoCodecInfo info) {
        if (info.name.equalsIgnoreCase("VP8")) {
            Logging.d(TAG, "LibvpxVp8Encoder");
            return new LibvpxVp8Encoder();
        }
        if (info.name.equalsIgnoreCase("VP9") && LibvpxVp9Encoder.nativeIsSupported()) {
            Logging.d(TAG, "LibvpxVp9Encoder");
            return new LibvpxVp9Encoder();
        }
        if (info.name.equalsIgnoreCase("H264") && LibvpxH264Encoder.nativeIsSupported()) {
            Logging.d(TAG, "LibvpxH264Encoder");
            return new LibvpxH264Encoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoEncoderFactory.supportedCodecs();
    }

    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> codecs = new ArrayList<VideoCodecInfo>();
        if (LibvpxH264Encoder.nativeIsSupported()) {
            codecs.add(H264Utils.DEFAULT_H264_BASELINE_PROFILE_CODEC);
        }
        return codecs.toArray(new VideoCodecInfo[codecs.size()]);
    }
}

