/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.webrtc;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.report.RTCStatusReportManager;
import cn.rongcloud.rtc.api.stream.RCRTCLiveInfo;
import cn.rongcloud.rtc.base.AsyncResult;
import cn.rongcloud.rtc.base.RCAttributeType;
import cn.rongcloud.rtc.base.RCRTCAVStreamType;
import cn.rongcloud.rtc.base.RCRTCRoomType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.center.stream.RCRTCLiveInfoImpl;
import cn.rongcloud.rtc.center.stream.RCTinyVideoOutStream;
import cn.rongcloud.rtc.core.MediaStream;
import cn.rongcloud.rtc.core.MediaStreamTrack;
import cn.rongcloud.rtc.core.SessionDescription;
import cn.rongcloud.rtc.core.VideoTrack;
import cn.rongcloud.rtc.proxy.ReConnectTool;
import cn.rongcloud.rtc.proxy.message.messagebeans.ExchangeSDPDataResult;
import cn.rongcloud.rtc.proxy.message.messagebeans.MediaResourceInfo;
import cn.rongcloud.rtc.proxy.message.messagebeans.SubscribeLiveDataResult;
import cn.rongcloud.rtc.signal.SignalManager;
import cn.rongcloud.rtc.stat.RongRtcStatMagr;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.RTCSDPTools;
import cn.rongcloud.rtc.utils.ResourceTools;
import cn.rongcloud.rtc.utils.RongRTCUtils;
import cn.rongcloud.rtc.webrtc.ILocalVideoStreamResource;
import cn.rongcloud.rtc.webrtc.IStreamResource;
import cn.rongcloud.rtc.webrtc.MediaCommonParams;
import cn.rongcloud.rtc.webrtc.PeerConnectionFactoryHolder;
import cn.rongcloud.rtc.webrtc.RTCConnectionHolder;
import cn.rongcloud.rtc.webrtc.task.PubSubTask;
import cn.rongcloud.rtc.webrtc.task.PubSubTaskQueue;
import io.rong.imlib.model.RTCStatusDate;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class RTCPubSubManager {
    private static final String TAG = "RTCPubSubManager";
    private RTCConnectionHolder mRTCConnection;
    private PeerConnectionFactoryHolder mFactoryManager;
    private PubSubTaskQueue mTaskQueue;
    private String mUserId;
    private int mMaxStreamCount;
    private RTCStatusReportManager mReportManager;

    protected RTCPubSubManager(RTCConnectionHolder rtcConnection, String userId, PeerConnectionFactoryHolder connectionFactoryManager, int maxStreamCount, RTCStatusReportManager reportManager) throws NullPointerException {
        this.mRTCConnection = rtcConnection;
        this.mUserId = userId;
        this.mFactoryManager = connectionFactoryManager;
        this.mMaxStreamCount = maxStreamCount;
        this.mTaskQueue = new PubSubTaskQueue();
        this.mReportManager = reportManager;
    }

    public void publishStreams(final List<? extends IStreamResource> allPubStreams, final List<? extends IStreamResource> pubStreams, final List<? extends IStreamResource> allSubStreams, final MediaCommonParams params) {
        this.offerTask(new PubSubTask(params.callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncPublishStreams(false, params, allPubStreams, pubStreams, allSubStreams);
            }
        });
    }

    public AsyncResult<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>> syncPublishStreams(boolean restartICE, MediaCommonParams params, List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> pubStreams, List<? extends IStreamResource> allSubStreams) {
        if (!this.isAllowPubSub()) {
            return AsyncResult.create(RTCErrorCode.RongRTCCodeRTCConnectionIsNull).getResult();
        }
        if (this.isEmpty(pubStreams)) {
            return AsyncResult.create(RTCErrorCode.RongRTCCodeParameterError).getResult();
        }
        for (IStreamResource iStreamResource : pubStreams) {
            if (this.mRTCConnection.getPublishedStreamSize() > this.mMaxStreamCount) {
                return AsyncResult.create(RTCErrorCode.RongRTCCodePublishStreamsHasReachedMaxCount).getResult();
            }
            MediaStream stream = this.getAndCreateLocalMediaStream(iStreamResource.getStreamId());
            this.mFactoryManager.bindingTrack(iStreamResource);
            if (!this.mRTCConnection.addStream(stream)) {
                return AsyncResult.create(RTCErrorCode.ConnectionAddStreamFailed).getResult();
            }
            if (iStreamResource instanceof ILocalVideoStreamResource && ((ILocalVideoStreamResource)iStreamResource).isPreserved()) {
                VideoTrack track = (VideoTrack)iStreamResource.getTrack();
                stream.addPreservedTrack(track);
            } else {
                stream.addTrack(iStreamResource.getTrack());
            }
            String streamId = stream.getId().contains(RCTinyVideoOutStream.TINY) ? stream.getId().substring(0, stream.getId().indexOf(RCTinyVideoOutStream.TINY.toString())) : stream.getId();
            this.mRTCConnection.bindStreamEncryption(iStreamResource.getTrack(), streamId);
        }
        AsyncResult<ExchangeSDPDataResult> exchangeResult = this.syncExchangeRemoteSDP(restartICE, allPubStreams, allSubStreams, params);
        if (exchangeResult.isFailed()) {
            return this.onPublishFailed(params.roomId, exchangeResult.getErrorCode(), pubStreams);
        }
        if (params.roomType != RCRTCRoomType.MEETING && RongRTCUtils.isEmpty(exchangeResult.getData().getMcuPublishList())) {
            return this.onPublishFailed(params.roomId, RTCErrorCode.MCU_PUBLISH_LIST_IS_NULL, pubStreams);
        }
        List<MediaResourceInfo> list = exchangeResult.getData().getPublishList();
        FinLog.i(TAG, "publish-exchangeRemoteSDP success");
        AsyncResult putResult = this.syncSendIMSignal(params.roomId, allPubStreams, pubStreams, list, exchangeResult.getData().getMcuPublishList(), exchangeResult.getData().getPullUrl(), exchangeResult.getData().getPushMode(), exchangeResult.getData().getBroadcast());
        if (putResult.isFailed()) {
            return this.onPublishFailed(params.roomId, putResult.getErrorCode(), pubStreams);
        }
        RongRtcStatMagr.instance.reportPublish(true, pubStreams);
        AsyncResult<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>> res = this.getExchangeSDPDataResult(params.roomId, params.roomType, exchangeResult, list);
        return res;
    }

    private AsyncResult<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>> getExchangeSDPDataResult(String roomId, RCRTCRoomType roomType, AsyncResult<ExchangeSDPDataResult> exchangeResult, List<MediaResourceInfo> publishMediaInfoList) {
        AsyncResult.TemporaryResult res = AsyncResult.create();
        if (roomType != RCRTCRoomType.MEETING) {
            JSONObject extra = exchangeResult.getData().getLiveInfo();
            if (extra != null) {
                JSONObject jsonObject = extra;
                try {
                    String liveUrl = jsonObject.has("liveUrl") ? jsonObject.getString("liveUrl") : null;
                    RCRTCLiveInfoImpl liveRoom = new RCRTCLiveInfoImpl(roomId, liveUrl, this.mUserId, jsonObject.optString("configUrl"));
                    res.setAndNotify(Pair.create(publishMediaInfoList, (Object)liveRoom));
                }
                catch (Exception e) {
                    FinLog.e(TAG, e.getMessage());
                    res.setAndNotify(RTCErrorCode.JsonParseError);
                }
            } else {
                res.setAndNotify(RTCErrorCode.LiveInfoIsNull);
            }
        } else {
            res.setAndNotify(Pair.create(publishMediaInfoList, null));
        }
        return res.getResult();
    }

    /*
     * WARNING - void declaration
     */
    private AsyncResult syncSendIMSignal(String roomId, List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> pubStreams, List<MediaResourceInfo> publishMediaInfoList, List<MediaResourceInfo> mcuPublishMediaInfoList, String pullUrl, int pushMode, int broadcast) {
        void var13_18;
        ResourceTools.RepublishInfo republishInfo = ResourceTools.getUnpubJSON(publishMediaInfoList, allPubStreams);
        String publish = ReConnectTool.mediaResourceInfoListToJson(publishMediaInfoList);
        ArrayList<MediaResourceInfo> mediaResourceInfos = new ArrayList<MediaResourceInfo>();
        if (!this.isEmpty(pubStreams)) {
            block0: for (IStreamResource iStreamResource : pubStreams) {
                for (MediaResourceInfo mediaResourceInfo : publishMediaInfoList) {
                    if (iStreamResource.getMediaType() != mediaResourceInfo.getType() || !TextUtils.equals((CharSequence)iStreamResource.getTag(), (CharSequence)mediaResourceInfo.getTag())) continue;
                    mediaResourceInfos.add(mediaResourceInfo);
                    continue block0;
                }
            }
        }
        FinLog.d(TAG, "syncSendIMSignal. pushMode : " + pushMode + " , broadcast : " + broadcast + " , pullUrl : " + pullUrl);
        RTCStatusDate[] kv = null;
        if (pushMode == 0 && broadcast == 0) {
            kv = new RTCStatusDate[3];
            kv[0] = ResourceTools.getStatusDate("uris", publish);
            kv[1] = ResourceTools.getStatusDate("mcu_uris", ReConnectTool.mediaResourceInfoListToJson(mcuPublishMediaInfoList));
            String string = "cdn_uris";
            String cdnValue = ResourceTools.getCdnUris(pullUrl, false);
            kv[2] = ResourceTools.getStatusDate(string, cdnValue);
            SignalManager.getInstance().rtcPutInnerData(roomId, RCAttributeType.ROOM, string, cdnValue, null, null);
        } else {
            kv = new RTCStatusDate[]{ResourceTools.getStatusDate("uris", publish), ResourceTools.getStatusDate("mcu_uris", ReConnectTool.mediaResourceInfoListToJson(mcuPublishMediaInfoList))};
        }
        FinLog.d(TAG, "syncSendIMSignal: uris=" + kv[0].getValue() + " , mcu_uris=" + kv[1].getValue());
        if (republishInfo != null) {
            FinLog.e(TAG, "publishResource()->needUnpub:" + republishInfo.getUnpub_JSON());
            RTCStatusDate[] rTCStatusDateArray = new RTCStatusDate[2];
            rTCStatusDateArray[0] = ResourceTools.getStatusDate("RCRTC:UnpublishResource", republishInfo.getUnpub_JSON());
            if (republishInfo.getRepubList().size() > 0) {
                mediaResourceInfos.addAll(republishInfo.getRepubList());
            }
            rTCStatusDateArray[1] = ResourceTools.getStatusDate("RCRTC:PublishResource", ResourceTools.getURIS(mediaResourceInfos, true, ""));
        } else {
            RTCStatusDate[] rTCStatusDateArray = new RTCStatusDate[]{ResourceTools.getStatusDate("RCRTC:PublishResource", ResourceTools.getURIS(mediaResourceInfos, true, ""))};
        }
        return SignalManager.getInstance().syncRTCSetUserResource(roomId, kv, "RCRTC:TotalContentResources", (RTCStatusDate[])var13_18);
    }

    public void reConnected(final boolean forceSendSignal, final List<? extends IStreamResource> allPubStreams, final List<? extends IStreamResource> allSubStreams, final MediaCommonParams<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>> params) {
        this.offerTask(new PubSubTask(params.callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncReConnected(forceSendSignal, allPubStreams, allSubStreams, params);
            }
        });
    }

    private AsyncResult<Pair<List<MediaResourceInfo>, RCRTCLiveInfo>> syncReConnected(boolean forceSendSignal, List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, MediaCommonParams params) {
        AsyncResult<ExchangeSDPDataResult> exchangeResult = this.syncExchangeRemoteSDP(true, allPubStreams, allSubStreams, params);
        if (exchangeResult.isFailed()) {
            return AsyncResult.convert(exchangeResult);
        }
        List<MediaResourceInfo> publishMediaInfoList = exchangeResult.getData().getPublishList();
        AsyncResult result = ReConnectTool.sendSourceMessage(params.roomId, forceSendSignal, publishMediaInfoList, allPubStreams, exchangeResult.getData().getMcuPublishList());
        if (result.isFailed()) {
            return AsyncResult.convert(result);
        }
        return this.getExchangeSDPDataResult(params.roomId, params.roomType, exchangeResult, publishMediaInfoList);
    }

    public void exchangeRemoteSDP(final boolean restartICE, final List<? extends IStreamResource> allPubStreams, final List<? extends IStreamResource> allSubStreams, final MediaCommonParams<ExchangeSDPDataResult> params) {
        this.offerTask(new PubSubTask(params.callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncExchangeRemoteSDP(restartICE, allPubStreams, allSubStreams, params);
            }
        });
    }

    private AsyncResult<ExchangeSDPDataResult> syncExchangeRemoteSDP(boolean restartICE, List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, MediaCommonParams params) {
        int tinyMaxBitrate;
        int tinyMinBitrate;
        int totalMinBitRate;
        RTCConnectionHolder rtcConnection = this.mRTCConnection;
        if (!this.isAllowPubSub()) {
            return AsyncResult.create(RTCErrorCode.RongRTCCodeRTCConnectionIsNull).getResult();
        }
        int totalMaxBitRate = RTCSDPTools.getTotalMaxBitRate(allPubStreams);
        AsyncResult<SessionDescription> sdpResult = rtcConnection.syncCreateAndSetOffer(params.roomId, restartICE, totalMaxBitRate);
        if (sdpResult.isFailed()) {
            return AsyncResult.convert(sdpResult);
        }
        AsyncResult<ExchangeSDPDataResult> sendSDPResult = SignalManager.getInstance().syncSendSDPOffer(params.roomId, sdpResult.getData(), params.clientSessionId, allPubStreams, allSubStreams, params.roomType, params.autoMixJSONInfo, params.role);
        if (sendSDPResult.isFailed()) {
            return AsyncResult.convert(sendSDPResult);
        }
        if (!this.isAllowPubSub()) {
            return AsyncResult.create(RTCErrorCode.RongRTCCodeRTCConnectionIsNull).getResult();
        }
        SessionDescription remoteSDP = sendSDPResult.getData().getSdp();
        AsyncResult setResult = rtcConnection.syncSetRemoteDescription(remoteSDP, totalMaxBitRate, totalMinBitRate = RTCSDPTools.getTotalMinBitRate(allPubStreams), tinyMinBitrate = RTCSDPTools.getTinyMinBitrate(allPubStreams), tinyMaxBitrate = RTCSDPTools.getTinyMaxBitrate(allPubStreams));
        if (setResult.isFailed()) {
            return AsyncResult.convert(setResult);
        }
        List<MediaResourceInfo> publishMediaInfoList = sendSDPResult.getData().getPublishList();
        block0: for (IStreamResource iStreamResource : allPubStreams) {
            for (MediaResourceInfo info : publishMediaInfoList) {
                if (!TextUtils.equals((CharSequence)info.getTag(), (CharSequence)iStreamResource.getTag()) || info.getType() != iStreamResource.getMediaType()) continue;
                info.setRCRTCResourceState(iStreamResource.getResourceState());
                continue block0;
            }
        }
        return AsyncResult.convert(sendSDPResult);
    }

    private AsyncResult onPublishFailed(String roomId, RTCErrorCode errorCode, List<? extends IStreamResource> pubStreamResources) {
        if (this.isAllowPubSub()) {
            RTCConnectionHolder connectionClient = this.mRTCConnection;
            this.removeStreams(pubStreamResources, connectionClient);
        }
        return AsyncResult.create(errorCode).getResult();
    }

    private void removeStreams(List<? extends IStreamResource> streamResources, RTCConnectionHolder connectionClient) {
        for (IStreamResource iStreamResource : streamResources) {
            MediaStream mediaStream = connectionClient.getMediaStream(iStreamResource.getStreamId());
            MediaStreamTrack track = iStreamResource.getTrack();
            if (mediaStream == null) continue;
            if (track != null) {
                mediaStream.removeTrack(track);
            }
            if (mediaStream.getAllTrackSize() != 0) continue;
            connectionClient.removeStream(mediaStream);
            mediaStream.dispose();
        }
    }

    public void unpublishedStreams(final List<? extends IStreamResource> allPubStreams, final List<? extends IStreamResource> allSubStreams, final List<? extends IStreamResource> unpublishedStreams, final MediaCommonParams<List<MediaResourceInfo>> params) {
        this.offerTask(new PubSubTask(params.callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncUnpublishedStreams(allPubStreams, allSubStreams, unpublishedStreams, params);
            }
        });
    }

    private AsyncResult<List<MediaResourceInfo>> syncUnpublishedStreams(List<? extends IStreamResource> allPubStreams, List<? extends IStreamResource> allSubStreams, List<? extends IStreamResource> unpublishedStreams, MediaCommonParams<List<MediaResourceInfo>> params) {
        Log.i((String)TAG, (String)"syncUnpublishedStreams");
        if (!this.isAllowPubSub()) {
            return AsyncResult.create(RTCErrorCode.RongRTCCodeRTCConnectionIsNull).getResult();
        }
        this.removeStreams(unpublishedStreams, this.mRTCConnection);
        AsyncResult<ExchangeSDPDataResult> exchangeResult = this.syncExchangeRemoteSDP(false, allPubStreams, allSubStreams, params);
        if (exchangeResult.isFailed()) {
            return AsyncResult.convert(exchangeResult);
        }
        List<MediaResourceInfo> publishMediaInfoList = exchangeResult.getData().getPublishList();
        String publish = ReConnectTool.mediaResourceInfoListToJson(publishMediaInfoList);
        FinLog.d(TAG, "publish = " + publish);
        ResourceTools.RepublishInfo republishInfo = ResourceTools.getUnpubJSON(publishMediaInfoList, allPubStreams);
        RTCStatusDate[] kv = null;
        int pushMode = exchangeResult.getData().getPushMode();
        int broadcast = exchangeResult.getData().getBroadcast();
        String pullUrl = exchangeResult.getData().getPullUrl();
        FinLog.d(TAG, "syncUnpublishedStreams->pushMode : " + pushMode + " , broadcast : " + broadcast + " , pullUrl : " + pullUrl);
        kv = pushMode == 0 && broadcast == 0 ? new RTCStatusDate[]{ResourceTools.getStatusDate("uris", publish), ResourceTools.getStatusDate("cdn_uris", ResourceTools.getCdnUris(pullUrl, false))} : new RTCStatusDate[]{ResourceTools.getStatusDate("uris", publish)};
        RTCStatusDate[] content = null;
        ArrayList<MediaResourceInfo> unPublishResourceList = new ArrayList<MediaResourceInfo>();
        for (IStreamResource iStreamResource : unpublishedStreams) {
            unPublishResourceList.add(new MediaResourceInfo(iStreamResource));
        }
        if (republishInfo != null) {
            content = new RTCStatusDate[2];
            unPublishResourceList.addAll(republishInfo.getNeedUnpublist());
            content[0] = ResourceTools.getStatusDate("RCRTC:UnpublishResource", ResourceTools.getURIS(unPublishResourceList, true, ""));
            content[1] = ResourceTools.getStatusDate("RCRTC:PublishResource", ResourceTools.getURIS(unPublishResourceList, true, ""));
        } else {
            content = new RTCStatusDate[]{ResourceTools.getStatusDate("RCRTC:UnpublishResource", ResourceTools.getURIS(unPublishResourceList, true, ""))};
        }
        AsyncResult result = SignalManager.getInstance().syncRTCSetUserResource(params.roomId, kv, "RCRTC:TotalContentResources", content);
        if (result.isFailed()) {
            return result;
        }
        RongRtcStatMagr.instance.reportPublish(false, unpublishedStreams);
        return AsyncResult.create(publishMediaInfoList).getResult();
    }

    private MediaStream getAndCreateLocalMediaStream(String streamId) {
        MediaStream mediaStream = this.mRTCConnection.getMediaStream(streamId);
        if (mediaStream != null) {
            return mediaStream;
        }
        mediaStream = this.mFactoryManager.createLocalMediaStream(streamId);
        return mediaStream;
    }

    public void subscribeStreams(final List<? extends IStreamResource> publishedStreams, final List<? extends IStreamResource> subscribedStreams, final MediaCommonParams params) {
        this.offerTask(new PubSubTask(params.callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncExchangeRemoteSDP(false, publishedStreams, subscribedStreams, params);
            }
        });
    }

    public void unsubscribeStreams(final List<? extends IStreamResource> allPubStreams, final List<? extends IStreamResource> allSubStreams, List<? extends IStreamResource> unSubStreams, boolean needExchangeSDP, final MediaCommonParams params) {
        this.offerTask(new PubSubTask(params.callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncExchangeRemoteSDP(false, allPubStreams, allSubStreams, params);
            }
        });
    }

    public void subscribeLiveStream(final List<? extends IStreamResource> allSubStreams, final String serverSessionId, final String clientSessionId, final RCRTCAVStreamType avStreamType, IRCRTCResultCallback callback) {
        this.offerTask(new PubSubTask(callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncSubscribeLiveStream(null, avStreamType, allSubStreams, serverSessionId, clientSessionId, null);
            }
        });
    }

    public void subscribeLiveStream(final String liveUrl, final RCRTCAVStreamType avStreamType, IRCRTCResultCallback callback) {
        this.offerTask(new PubSubTask(callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncSubscribeLiveStream(liveUrl, avStreamType, null, null, null, null);
            }
        });
    }

    public void subscribeLiveUrl(final String liveUrl, final RCRTCAVStreamType avStreamType, final String roomId, final List<? extends IStreamResource> allSubStreams, final String serverSessionId, final String clientSessionId, IRCRTCResultDataCallback callback) {
        this.offerTask(new PubSubTask(callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncSubscribeLiveStream(liveUrl, avStreamType, allSubStreams, serverSessionId, clientSessionId, roomId);
            }
        });
    }

    public AsyncResult syncSubscribeLiveStream(String liveUrl, RCRTCAVStreamType avStreamType, List<? extends IStreamResource> allSubStreams, String serverSessionId, String clientSessionId, String roomId) {
        AsyncResult setResult;
        long currentTime = System.currentTimeMillis();
        FinLog.i(TAG, "subscribeLiveResources() run -- " + liveUrl);
        if (!this.isAllowPubSub()) {
            FinLog.i(TAG, "subscribeLiveResources() run -- onFailed RongRTCCodeRTCConnectionIsNull");
            return AsyncResult.create(RTCErrorCode.RongRTCCodeRTCConnectionIsNull).getResult();
        }
        AsyncResult<SessionDescription> sdpResult = this.mRTCConnection.syncCreateAndSetOffer("", true, 0);
        if (sdpResult.isFailed()) {
            return sdpResult;
        }
        FinLog.d(TAG, "subscribeLiveSDP onLocalSdpSetSuccess ");
        AsyncResult<SubscribeLiveDataResult> subResult = SignalManager.getInstance().syncSubscribeLive(sdpResult.getData(), liveUrl, avStreamType, allSubStreams, serverSessionId, clientSessionId);
        if (subResult.isFailed()) {
            return subResult;
        }
        SubscribeLiveDataResult dataResult = subResult.getData();
        if (!TextUtils.isEmpty((CharSequence)liveUrl) && !TextUtils.isEmpty((CharSequence)roomId)) {
            if (!TextUtils.equals((CharSequence)roomId, (CharSequence)dataResult.getRoomId())) {
                return AsyncResult.create(RTCErrorCode.LIVEURLNOTINCURRENTROOM).getResult();
            }
            if (RongRTCUtils.isEmpty(dataResult.getMccPublishList())) {
                return AsyncResult.create(RTCErrorCode.MCU_PUBLISH_LIST_IS_NULL).getResult();
            }
        }
        if ((setResult = this.mRTCConnection.syncSetRemoteDescription(dataResult.getSdp(), 0, 0, 0, 0)).isFailed()) {
            return setResult;
        }
        long endTime = System.currentTimeMillis();
        FinLog.i(TAG, "subscribeLiveSDP onSuccess() costTime = " + (endTime - currentTime));
        return AsyncResult.create(dataResult.getMccPublishList()).getResult();
    }

    public void exchangeVideoSize(final List<? extends IStreamResource> allPubStreams, final List<IStreamResource> allSubStreams, final MediaCommonParams params) {
        this.offerTask(new PubSubTask(params.callback){

            protected AsyncResult handleTask() {
                return RTCPubSubManager.this.syncExchangeVideoSize(allPubStreams, allSubStreams, params);
            }
        });
    }

    private AsyncResult syncExchangeVideoSize(List<? extends IStreamResource> allPubStreams, List<IStreamResource> allSubStreams, MediaCommonParams params) {
        AsyncResult<ExchangeSDPDataResult> res = this.syncExchangeRemoteSDP(false, allPubStreams, allSubStreams, params);
        if (res.isFailed()) {
            return res;
        }
        return SignalManager.getInstance().syncResolutionChanged(params.roomId, params.roomType, params.clientSessionId, allPubStreams);
    }

    private boolean isAllowPubSub() {
        return this.mRTCConnection != null && this.mRTCConnection.isAvailable() && this.mFactoryManager != null;
    }

    private boolean isEmpty(List list) {
        return list == null || list.isEmpty();
    }

    public void offerTask(PubSubTask task) {
        if (this.mTaskQueue != null) {
            this.mTaskQueue.offerTask(task);
        }
    }

    public void clearTask() {
        if (this.mTaskQueue != null) {
            this.mTaskQueue.clearTask();
        }
    }

    public void release() {
        this.mTaskQueue.stop(new Runnable(){

            @Override
            public void run() {
                SignalManager.getInstance().reset();
            }
        });
        this.mTaskQueue = null;
        this.mRTCConnection.release();
        this.mRTCConnection = null;
    }

    public void freedPeerConnection() {
        if (this.mRTCConnection != null) {
            this.mRTCConnection.release();
        }
    }
}

