/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.center;

import android.os.Handler;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.callback.IRCRTCRoomEventsListener;
import cn.rongcloud.rtc.api.stream.RCRTCCDNInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.base.RCRTCLiveRole;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.imlib.model.Message;
import java.util.Arrays;
import java.util.List;

public class RCRoomEventListenerWrapper
extends IRCRTCRoomEventsListener {
    private IRCRTCRoomEventsListener mEventsListener;
    private Handler mCallBackHandler;
    private String roomId;

    public RCRoomEventListenerWrapper(String roomId, Handler callBackHandler) {
        this.mCallBackHandler = callBackHandler;
        this.roomId = roomId;
    }

    public void setEventsListener(IRCRTCRoomEventsListener eventsListener) {
        this.mEventsListener = eventsListener;
    }

    public void release() {
        this.mCallBackHandler = null;
        this.mEventsListener = null;
    }

    private void postCallback(Runnable runnable) {
        Handler callBackHandler = this.mCallBackHandler;
        if (callBackHandler == null || this.mEventsListener == null) {
            return;
        }
        callBackHandler.post(runnable);
    }

    @Override
    public void onRemoteUserPublishResource(final RCRTCRemoteUser remoteUser, final List<RCRTCInputStream> streams) {
        ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERPUBLISHRESOURCE, "roomId|userId|resource", this.roomId, remoteUser.getUserId(), ReportUtil.streamToString(streams));
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onRemoteUserPublishResource(remoteUser, streams);
                }
            }
        });
    }

    @Override
    public void onRemoteUserMuteAudio(final RCRTCRemoteUser remoteUser, final RCRTCInputStream stream, final boolean mute) {
        ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERMODIFYRESOURCE, "roomId|userid|mediaType|isMute", this.roomId, remoteUser.getUserId(), RCRTCMediaType.AUDIO.getDescription(), mute);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onRemoteUserMuteAudio(remoteUser, stream, mute);
                }
            }
        });
    }

    @Override
    public void onRemoteUserMuteVideo(final RCRTCRemoteUser remoteUser, final RCRTCInputStream stream, final boolean mute) {
        ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERMODIFYRESOURCE, "roomId|userid|mediaType|isMute", this.roomId, remoteUser.getUserId(), RCRTCMediaType.VIDEO.getDescription(), mute);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onRemoteUserMuteVideo(remoteUser, stream, mute);
                }
            }
        });
    }

    @Override
    public void onRemoteUserUnpublishResource(final RCRTCRemoteUser remoteUser, final List<RCRTCInputStream> streams) {
        ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERUNPUBLISHRESOURCE, "roomId|userId|resource", this.roomId, remoteUser.getUserId(), ReportUtil.streamToString(streams));
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onRemoteUserUnpublishResource(remoteUser, streams);
                }
            }
        });
    }

    @Override
    public void onUserJoined(final RCRTCRemoteUser remoteUser) {
        ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERJOINED, "roomId|userId", this.roomId, remoteUser.getUserId());
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onUserJoined(remoteUser);
                }
            }
        });
    }

    @Override
    public void onUserLeft(final RCRTCRemoteUser remoteUser) {
        ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSERLEFT, "roomId|userId", this.roomId, remoteUser.getUserId());
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onUserLeft(remoteUser);
                }
            }
        });
    }

    @Override
    public void onUserOffline(final RCRTCRemoteUser remoteUser) {
        ReportUtil.libStatus(ReportUtil.TAG.ONREMOTEUSEROFFLINE, "roomId|userId", this.roomId, remoteUser.getUserId());
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onUserOffline(remoteUser);
                }
            }
        });
    }

    @Override
    public void onLeaveRoom(final int reasonCode) {
        final IRCRTCRoomEventsListener roomEventsListener = this.mEventsListener;
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (roomEventsListener != null) {
                    roomEventsListener.onLeaveRoom(reasonCode);
                }
            }
        });
    }

    @Override
    public void onVideoTrackAdd(final String userId, final String tag) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onVideoTrackAdd(userId, tag);
                }
            }
        });
    }

    @Override
    public void onFirstRemoteVideoFrame(final String userId, final String tag) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onFirstRemoteVideoFrame(userId, tag);
                }
            }
        });
    }

    @Override
    public void onFirstRemoteAudioFrame(final String userId, final String tag) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onFirstRemoteAudioFrame(userId, tag);
                }
            }
        });
    }

    @Override
    public void onFirstLocalVideoFrame(final String tag, final int width, final int height) {
        super.onFirstLocalVideoFrame(tag, width, height);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onFirstLocalVideoFrame(tag, width, height);
                }
            }
        });
    }

    @Override
    public void onFirstRemoteVideoFrame(final String userId, final String tag, final int w, final int h) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (RCRoomEventListenerWrapper.this.mEventsListener != null) {
                    RCRoomEventListenerWrapper.this.mEventsListener.onFirstRemoteVideoFrame(userId, tag, w, h);
                }
            }
        });
    }

    @Override
    public void onReportFirstFrame(final RCRTCInputStream stream, final RCRTCMediaType mediaType) {
        super.onReportFirstFrame(stream, mediaType);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onReportFirstFrame(stream, mediaType);
                }
            }
        });
    }

    @Override
    public void onReceiveMessage(final Message message) {
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onReceiveMessage(message);
                }
            }
        });
    }

    @Override
    public void onKickedByServer() {
        final IRCRTCRoomEventsListener roomEventsListener = this.mEventsListener;
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (roomEventsListener != null) {
                    roomEventsListener.onKickedByServer();
                }
            }
        });
    }

    @Override
    public void onRequestJoinOtherRoom(final String inviterRoomId, final String inviterUserId, final String extra) {
        super.onRequestJoinOtherRoom(inviterRoomId, inviterUserId, extra);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onRequestJoinOtherRoom(inviterRoomId, inviterUserId, extra);
                }
            }
        });
    }

    @Override
    public void onResponseJoinOtherRoom(final String inviterRoomId, final String inviterUserId, final String inviteeRoomId, final String inviteeUserId, final boolean agree, final String extra) {
        super.onResponseJoinOtherRoom(inviterRoomId, inviterUserId, inviteeRoomId, inviteeUserId, agree, extra);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onResponseJoinOtherRoom(inviterRoomId, inviterUserId, inviteeRoomId, inviteeUserId, agree, extra);
                }
            }
        });
    }

    @Override
    public void onCancelRequestOtherRoom(final String inviterRoomId, final String inviterUserId, final String extra) {
        super.onCancelRequestOtherRoom(inviterRoomId, inviterUserId, extra);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onCancelRequestOtherRoom(inviterRoomId, inviterUserId, extra);
                }
            }
        });
    }

    @Override
    public void onFinishOtherRoom(final String roomId, final String userId) {
        super.onFinishOtherRoom(roomId, userId);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onFinishOtherRoom(roomId, userId);
                }
            }
        });
    }

    @Override
    public void onOtherRoomConnectionError(final String otherRoomId) {
        super.onOtherRoomConnectionError(otherRoomId);
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                IRCRTCRoomEventsListener mEventsListener = RCRoomEventListenerWrapper.this.mEventsListener;
                if (mEventsListener != null) {
                    mEventsListener.onOtherRoomConnectionError(otherRoomId);
                }
            }
        });
    }

    @Override
    public void onPublishLiveStreams(final List<RCRTCInputStream> streams) {
        final IRCRTCRoomEventsListener eventsListener = this.mEventsListener;
        ReportUtil.libStatus(ReportUtil.TAG.ONPUBLISHLIVERESOURCE, "roomId|streams", this.roomId, ReportUtil.streamToString(streams));
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (eventsListener != null) {
                    eventsListener.onPublishLiveStreams(streams);
                }
            }
        });
    }

    @Override
    public void onUnpublishLiveStreams(final List<RCRTCInputStream> streams) {
        final IRCRTCRoomEventsListener eventsListener = this.mEventsListener;
        ReportUtil.libStatus(ReportUtil.TAG.ONUNPUBLISHLIVERESOURCE, "roomId|streams", this.roomId, ReportUtil.streamToString(streams));
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (eventsListener != null) {
                    eventsListener.onUnpublishLiveStreams(streams);
                }
            }
        });
    }

    @Override
    public void onPublishCDNStream(final RCRTCCDNInputStream stream) {
        final IRCRTCRoomEventsListener eventsListener = this.mEventsListener;
        ReportUtil.libStatus(ReportUtil.TAG.ONPUBLISHCDNSTREAM, "roomId|stream", this.roomId, ReportUtil.streamToString(Arrays.asList(stream)));
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (eventsListener != null) {
                    eventsListener.onPublishCDNStream(stream);
                }
            }
        });
    }

    @Override
    public void onUnpublishCDNStream(final RCRTCCDNInputStream stream) {
        final IRCRTCRoomEventsListener eventsListener = this.mEventsListener;
        ReportUtil.libStatus(ReportUtil.TAG.ONUNPUBLISHCDNSTREAM, "roomId|stream", this.roomId, ReportUtil.streamToString(Arrays.asList(stream)));
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (eventsListener != null) {
                    eventsListener.onUnpublishCDNStream(stream);
                }
            }
        });
    }

    @Override
    public void onSwitchRole(final String userId, final RCRTCLiveRole role) {
        super.onSwitchRole(userId, role);
        ReportUtil.libStatus(ReportUtil.TAG.SWITCH_ROLE, "roomId|userId|role", this.roomId, userId, role.name());
        final IRCRTCRoomEventsListener eventsListener = this.mEventsListener;
        this.postCallback(new Runnable(){

            @Override
            public void run() {
                if (eventsListener != null) {
                    eventsListener.onSwitchRole(userId, role);
                }
            }
        });
    }
}

