/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.list;

import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.taobao.weex.common.IWXObject;
import com.taobao.weex.ui.component.list.WXCell;
import com.taobao.weex.ui.component.list.WXListComponent;
import com.taobao.weex.utils.WXViewUtils;

public class GapItemDecoration
extends RecyclerView.ItemDecoration {
    private WXListComponent listComponent;

    public GapItemDecoration(WXListComponent listComponent) {
        this.listComponent = listComponent;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        Float[] spanOffsets = this.listComponent.getSpanOffsets();
        if (spanOffsets == null) {
            return;
        }
        int position = parent.getChildAdapterPosition(view);
        if (position < 0) {
            return;
        }
        if (view.getLayoutParams() instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams params = (StaggeredGridLayoutManager.LayoutParams)view.getLayoutParams();
            if (params.isFullSpan()) {
                return;
            }
            IWXObject component = this.listComponent.getListChild(position);
            if (component instanceof WXCell) {
                WXCell cell = (WXCell)component;
                if (cell.isFixed() || cell.isSticky()) {
                    return;
                }
                if (params.getSpanIndex() >= spanOffsets.length) {
                    return;
                }
                int index = this.listComponent.isLayoutRTL() ? spanOffsets.length - params.getSpanIndex() - 1 : params.getSpanIndex();
                float spanOffset = this.listComponent.getSpanOffsets()[index].floatValue();
                int spanOffsetPx = Math.round(WXViewUtils.getRealPxByWidth(spanOffset, this.listComponent.getViewPortWidthForFloat()));
                if (this.listComponent.isLayoutRTL()) {
                    outRect.left = -spanOffsetPx;
                    outRect.right = spanOffsetPx;
                } else {
                    outRect.left = spanOffsetPx;
                    outRect.right = -spanOffsetPx;
                }
            }
        }
    }
}

