/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.downloadproxy.jni;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPDLProxyNativeLibLoader;
import com.tencent.thumbplayer.core.downloadproxy.apiinner.TPListenerManager;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLProxyLog;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLProxyUtils;

public class TPDownloadProxyNative {
    private static final String FILE_NAME = "TPDownloadProxyNative";
    private static boolean isLoadDownloadProxySucceed = false;
    private static Context appContext = null;
    private ITPDLProxyNativeLibLoader mLibLoader;

    public native int initService(int var1, String var2, String var3, String var4);

    public native int deInitService(int var1);

    public native int updateStoragePath(int var1, String var2);

    public native int setMaxStorageSizeMB(int var1, long var2);

    public native byte[] getVersion();

    public native byte[] getErrorCodeStr(int var1);

    public native byte[] getNativeInfo(int var1);

    public native int checkResourceStatus(String var1, String var2, int var3);

    public native long getResourceSize(String var1, String var2);

    public native byte[] getHLSOfflineExttag(String var1, String var2, int var3, long var4);

    public native void setUserData(String var1, String var2);

    public native void pushEvent(int var1);

    public native int createDownloadTask(int var1, String var2, int var3, int var4);

    public native int setClipInfo(int var1, int var2, String var3, int var4, String var5, String var6, String var7);

    public native byte[] getClipPlayUrl(int var1, int var2, int var3);

    public native int startDownload(int var1);

    public native int stopDownload(int var1);

    public native int stopAllDownload(int var1);

    public native int pauseDownload(int var1);

    public native int resumeDownload(int var1);

    public native int deleteCache(String var1, String var2, long var3);

    public native int clearCache(String var1, String var2, int var3, long var4);

    public native long verifyOfflineCacheSync(String var1, int var2, String var3, String var4);

    public native void setPlayerState(int var1, int var2);

    public native void updateTaskInfo(int var1, String var2, String var3);

    public native void updatePlayerPlayMsg(int var1, int var2, int var3, int var4);

    public native boolean isNativeReadyForWork();

    public native byte[] getOfflineLicenseKeySetId(String var1, String var2, String var3);

    public native int deleteOfflineLicenseKeySetId(String var1, String var2, String var3);

    private TPDownloadProxyNative() {
    }

    public static TPDownloadProxyNative getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static void nativeMessageCallback(int messageId, int taskId, Object param1, Object param2, Object param3, Object param4, Object param5) {
        TPListenerManager.getInstance().handleCallbackMessage(messageId, taskId, param1, param2, param3, param4, param5);
    }

    private static int nativeIntMessageCallback(int messageId, int taskId, Object param1, Object param2, Object param3, Object param4, Object param5) {
        return TPListenerManager.getInstance().handleIntCallbackMessage(messageId, taskId, param1, param2, param3, param4, param5);
    }

    private static String nativeStringMessageCallback(int messageId, int taskId, Object param1, Object param2, Object param3, Object param4, Object param5) {
        return TPListenerManager.getInstance().handleStringCallbackMessage(messageId, taskId, param1, param2, param3, param4, param5);
    }

    private static void nativeLogCallback(int level, byte[] fileName, int line, byte[] tag, byte[] message) {
        if (level == 6) {
            TPDLProxyLog.e(TPDLProxyUtils.byteArrayToString(fileName), line, TPDLProxyUtils.byteArrayToString(tag), TPDLProxyUtils.byteArrayToString(message));
            return;
        }
        if (level == 5) {
            TPDLProxyLog.w(TPDLProxyUtils.byteArrayToString(fileName), line, TPDLProxyUtils.byteArrayToString(tag), TPDLProxyUtils.byteArrayToString(message));
            return;
        }
        if (level != 4 && level == 3) {
            TPDLProxyLog.d(TPDLProxyUtils.byteArrayToString(fileName), line, TPDLProxyUtils.byteArrayToString(tag), TPDLProxyUtils.byteArrayToString(message));
            return;
        }
        TPDLProxyLog.i(TPDLProxyUtils.byteArrayToString(fileName), line, TPDLProxyUtils.byteArrayToString(tag), TPDLProxyUtils.byteArrayToString(message));
    }

    public boolean isNativeLoaded() {
        if (!isLoadDownloadProxySucceed) {
            try {
                if (this.mLibLoader != null) {
                    isLoadDownloadProxySucceed = this.mLibLoader.loadLib("downloadproxy", this.getNativeVersion());
                    TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "third module so load ret:" + (isLoadDownloadProxySucceed ? "0" : "1"));
                }
            }
            catch (Throwable throwable) {
                isLoadDownloadProxySucceed = false;
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "third module so load failed, error:" + throwable.toString());
            }
            try {
                if (!isLoadDownloadProxySucceed) {
                    System.loadLibrary("downloadproxy");
                    isLoadDownloadProxySucceed = true;
                    TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "system so load success!");
                }
            }
            catch (Throwable throwable) {
                isLoadDownloadProxySucceed = false;
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "system so load failed, error:" + throwable.toString());
            }
        }
        if (!isLoadDownloadProxySucceed && this.getAppContext() != null && TextUtils.equals((CharSequence)this.getAppContext().getPackageName(), (CharSequence)"com.tencent.liteav.demo")) {
            System.exit(0);
        }
        return isLoadDownloadProxySucceed;
    }

    public String getNativeVersion() {
        String string = "2.21.0.00789";
        if (isLoadDownloadProxySucceed) {
            string = TPDLProxyUtils.byteArrayToString(this.getVersion());
        }
        TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "get native version:".concat(String.valueOf(string)));
        return string;
    }

    public void setLibLoader(ITPDLProxyNativeLibLoader libLoader) {
        TPDLProxyLog.i(FILE_NAME, 0, "tpdlnative", "set third module so loader!!!");
        this.mLibLoader = libLoader;
    }

    public void setAppContext(Context context) {
        if (context != null) {
            appContext = context.getApplicationContext();
        }
    }

    public Context getAppContext() {
        return appContext;
    }

    public boolean isReadyForWork() {
        if (isLoadDownloadProxySucceed) {
            return this.isNativeReadyForWork();
        }
        return false;
    }

    static class SingletonHolder {
        private static final TPDownloadProxyNative INSTANCE = new TPDownloadProxyNative();

        private SingletonHolder() {
        }
    }
}

