/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.media.player.api;

import android.util.Log;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.media.player.IMediaPlayer;
import cn.rongcloud.rtc.media.player.api.RCPlayer;
import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.imlib.IRongCoreListener;
import io.rong.imlib.RongCoreClient;

public class PlayerEventListener
implements IMediaPlayer.OnPreparedListener,
IMediaPlayer.OnInfoListener,
IMediaPlayer.OnErrorListener,
IMediaPlayer.OnVideoSizeChangedListener {
    private static final String TAG = "PlayerEventListener";
    private int startState = 0;
    private RCPlayer mPlayer = null;
    private IRongCoreListener.ConnectionStatusListener.ConnectionStatus mConnectionStatus = null;
    private int reConnectCount = 0;

    public PlayerEventListener(RCPlayer player) {
        this.mPlayer = player;
    }

    @Override
    public void onPrepared(IMediaPlayer mp) {
        ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"startState|desc|time", (Object[])new Object[]{this.startState, "onPrepared", System.currentTimeMillis()});
        if (this.startState == 1) {
            mp.start();
            this.setStartState(0);
        }
    }

    @Override
    public boolean onInfo(IMediaPlayer mp, int arg1, int arg2) {
        switch (arg1) {
            case 700: {
                Log.d((String)TAG, (String)"MEDIA_INFO_VIDEO_TRACK_LAGGING:");
                break;
            }
            case 10004: {
                ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"video decoded start"});
                break;
            }
            case 10003: {
                ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"audio decoded start"});
                break;
            }
            case 10002: {
                this.reConnectCount = 0;
                ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc|time", (Object[])new Object[]{"audio rendering start", System.currentTimeMillis()});
                RTCEngineImpl.getInstance().sendMessage(5048, (Object)arg1);
                break;
            }
            case 3: {
                this.reConnectCount = 0;
                ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc|time", (Object[])new Object[]{"video rendering start", System.currentTimeMillis()});
                RTCEngineImpl.getInstance().sendMessage(5041, (Object)arg1);
                break;
            }
            case 701: {
                ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"info buffering start"});
                break;
            }
            case 702: {
                ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"info buffering end"});
                break;
            }
            case 703: {
                Log.d((String)TAG, (String)("MEDIA_INFO_NETWORK_BANDWIDTH: " + arg2));
                break;
            }
            case 800: {
                Log.d((String)TAG, (String)"MEDIA_INFO_BAD_INTERLEAVING:");
                break;
            }
            case 801: {
                Log.d((String)TAG, (String)"MEDIA_INFO_NOT_SEEKABLE:");
                break;
            }
            case 802: {
                Log.d((String)TAG, (String)"MEDIA_INFO_METADATA_UPDATE:");
                break;
            }
            case 901: {
                Log.d((String)TAG, (String)"MEDIA_INFO_UNSUPPORTED_SUBTITLE:");
                break;
            }
            case 902: {
                Log.d((String)TAG, (String)"MEDIA_INFO_SUBTITLE_TIMED_OUT:");
                break;
            }
            case 10007: {
                ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"component open"});
                break;
            }
            case 10006: {
                ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc", (Object[])new Object[]{"find stream info"});
                break;
            }
            case 10001: {
                Log.d((String)TAG, (String)("MEDIA_INFO_VIDEO_ROTATION_CHANGED: " + arg2));
                ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"oration|desc", (Object[])new Object[]{arg2, "video rotation changed"});
                break;
            }
        }
        return false;
    }

    @Override
    public boolean onError(IMediaPlayer mp, int framework_err, int impl_err) {
        int errorCode = -1;
        switch (framework_err) {
            case -10000: {
                errorCode = RTCErrorCode.CDN_INFO_VIDEO_INTERRUPT.getValue();
                break;
            }
            case 100: {
                errorCode = RTCErrorCode.CDN_ERROR_SERVER_DIED.getValue();
                break;
            }
        }
        this.mConnectionStatus = RongCoreClient.getInstance().getCurrentConnectionStatus();
        boolean available = this.mPlayer != null;
        boolean needNotice = true;
        if (this.mConnectionStatus == IRongCoreListener.ConnectionStatusListener.ConnectionStatus.NETWORK_UNAVAILABLE) {
            if (available) {
                needNotice = false;
                this.mPlayer.pause();
            }
        } else if (this.mConnectionStatus == IRongCoreListener.ConnectionStatusListener.ConnectionStatus.CONNECTED && this.reConnectCount < 2) {
            ++this.reConnectCount;
            needNotice = false;
            RTCEngineImpl.getInstance().sendMessage(5057, new Object[0]);
        }
        ReportUtil.libError((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"what|extra|IMCurrentConnectionStatus|playerAvailable|reConnectCount", (Object[])new Object[]{framework_err, impl_err, this.mConnectionStatus, available, this.reConnectCount});
        if (!needNotice) {
            return true;
        }
        RTCEngineImpl.getInstance().sendMessage(5039, (Object)errorCode);
        return true;
    }

    public void setStartState(int startState) {
        this.startState = startState;
    }

    @Override
    public void onVideoSizeChanged(IMediaPlayer mp, int width, int height, int sar_num, int sar_den) {
        int mVideoWidth = mp.getVideoWidth();
        int mVideoHeight = mp.getVideoHeight();
        int mVideoSarNum = mp.getVideoSarNum();
        int mVideoSarDen = mp.getVideoSarDen();
        ReportUtil.libStatus((ReportUtil.TAG)ReportUtil.TAG.PLAYER_STATE, (String)"desc|width|height|sar_num|sar_den", (Object[])new Object[]{"onVideoSizeChanged", width, height, sar_num, sar_den});
        RTCEngineImpl.getInstance().sendMessage(5042, new Object[]{mVideoWidth, mVideoHeight, mVideoSarNum, mVideoSarDen});
    }
}

