/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.source;

import androidx.annotation.NonNull;
import com.daasuu.mp4compose.logger.Logger;
import com.daasuu.mp4compose.source.DataSource;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class FilePathDataSource
implements DataSource {
    private static final String TAG = FilePathDataSource.class.getSimpleName();
    private FileDescriptor fileDescriptor;

    public FilePathDataSource(@NonNull String filePath, @NonNull Logger logger, @NonNull DataSource.Listener listener) {
        FileInputStream fileInputStream;
        File srcFile = new File(filePath);
        try {
            fileInputStream = new FileInputStream(srcFile);
        }
        catch (FileNotFoundException e) {
            logger.error(TAG, "Unable to find file", e);
            listener.onError(e);
            return;
        }
        try {
            this.fileDescriptor = fileInputStream.getFD();
        }
        catch (IOException e) {
            logger.error(TAG, "Unable to read input file", e);
            listener.onError(e);
        }
    }

    @Override
    @NonNull
    public FileDescriptor getFileDescriptor() {
        return this.fileDescriptor;
    }
}

