/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.model;

import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Mimetypes {
    public static final String MIMETYPE_XML = "application/xml";
    public static final String MIMETYPE_HTML = "text/html";
    public static final String MIMETYPE_OCTET_STREAM = "application/octet-stream";
    public static final String MIMETYPE_GZIP = "application/x-gzip";
    private static Mimetypes mimetypes = null;
    private HashMap<String, String> extensionToMimetypeMap = new HashMap();

    private Mimetypes() {
    }

    public static synchronized Mimetypes getInstance() {
        if (mimetypes != null) {
            return mimetypes;
        }
        mimetypes = new Mimetypes();
        InputStream is = mimetypes.getClass().getResourceAsStream("/assets/mime.types");
        if (is != null) {
            try {
                mimetypes.loadAndReplaceMimetypes(is);
            }
            catch (IOException ex) {
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Log.d((String)"ks3_sdk_android", (String)"Failed to close inputstream");
                }
            }
        } else {
            Log.w((String)"ks3_sdk_android", (String)"Unable to find 'mime.types' file in classpath");
        }
        return mimetypes;
    }

    public void loadAndReplaceMimetypes(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = br.readLine()) != null) {
            StringTokenizer st;
            if ((line = line.trim()).startsWith("#") || line.length() == 0 || (st = new StringTokenizer(line, " \t")).countTokens() <= 1) continue;
            String mimetype = st.nextToken();
            while (st.hasMoreTokens()) {
                String extension = st.nextToken();
                this.extensionToMimetypeMap.put(extension.toLowerCase(), mimetype);
            }
        }
    }

    public String getMimetype(String fileName) {
        int lastPeriodIndex = fileName.lastIndexOf(".");
        if (lastPeriodIndex > 0 && lastPeriodIndex + 1 < fileName.length()) {
            String ext = fileName.substring(lastPeriodIndex + 1).toLowerCase();
            if (this.extensionToMimetypeMap.keySet().contains(ext)) {
                String mimetype = this.extensionToMimetypeMap.get(ext);
                return mimetype;
            }
        }
        return MIMETYPE_OCTET_STREAM;
    }

    public String getMimetype(File file) {
        return this.getMimetype(file.getName());
    }
}

