/*
 * Decompiled with CFR 0.152.
 */
package com.ksyun.ks3.services.handler;

import com.ksyun.ks3.exception.Ks3Error;
import com.ksyun.ks3.model.Owner;
import com.ksyun.ks3.model.Part;
import com.ksyun.ks3.model.result.ListPartsResult;
import com.ksyun.ks3.services.handler.Ks3HttpResponceHandler;
import com.ksyun.ks3.util.DateUtil;
import com.ksyun.ks3.util.StringUtils;
import cz.msebera.android.httpclient.Header;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public abstract class ListPartsResponseHandler
extends Ks3HttpResponceHandler {
    private static String RESPONSE_TAG_PRIFIX = "ns2:";

    public abstract void onFailure(int var1, Ks3Error var2, Header[] var3, String var4, Throwable var5);

    public abstract void onSuccess(int var1, Header[] var2, ListPartsResult var3);

    @Override
    public final void onSuccess(int statesCode, Header[] responceHeaders, byte[] response) {
        this.onSuccess(statesCode, responceHeaders, this.parseXml(responceHeaders, response));
    }

    @Override
    public final void onFailure(int statesCode, Header[] responceHeaders, byte[] response, Throwable throwable) {
        Ks3Error error = new Ks3Error(statesCode, response, throwable);
        this.onFailure(statesCode, error, responceHeaders, response == null ? "" : new String(response), throwable);
    }

    @Override
    public final void onProgress(long bytesWritten, long totalSize) {
    }

    @Override
    public final void onStart() {
    }

    @Override
    public final void onFinish() {
    }

    @Override
    public final void onCancel() {
    }

    private ListPartsResult parseXml(Header[] responceHeaders, byte[] response) {
        XmlPullParserFactory factory = null;
        ListPartsResult partsResult = null;
        Owner owner = null;
        Owner initiator = null;
        Part part = null;
        boolean isOwner = false;
        try {
            factory = XmlPullParserFactory.newInstance();
            XmlPullParser parse = factory.newPullParser();
            parse.setInput((InputStream)new ByteArrayInputStream(response), "UTF-8");
            int eventType = parse.getEventType();
            while (1 != eventType) {
                String nodeName = parse.getName();
                if (!StringUtils.isBlank(nodeName) && nodeName.startsWith(RESPONSE_TAG_PRIFIX)) {
                    nodeName = nodeName.substring(4);
                }
                switch (eventType) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        String dateStr;
                        if ("ListPartsResult".equalsIgnoreCase(nodeName)) {
                            partsResult = new ListPartsResult();
                        }
                        if ("Bucket".equalsIgnoreCase(nodeName)) {
                            partsResult.setBucketname(parse.nextText());
                        }
                        if ("Key".equalsIgnoreCase(nodeName)) {
                            partsResult.setKey(parse.nextText());
                        }
                        if ("UploadId".equalsIgnoreCase(nodeName)) {
                            String upid = parse.nextText();
                            partsResult.setUploadId(upid);
                        }
                        if ("Initiator".equalsIgnoreCase(nodeName)) {
                            initiator = new Owner();
                        }
                        if ("Owner".equalsIgnoreCase(nodeName)) {
                            isOwner = true;
                            owner = new Owner();
                        }
                        if ("ID".equalsIgnoreCase(nodeName)) {
                            if (isOwner) {
                                owner.setId(parse.nextText());
                            } else {
                                initiator.setId(parse.nextText());
                            }
                        }
                        if ("DisplayName".equalsIgnoreCase(nodeName)) {
                            if (isOwner) {
                                owner.setDisplayName(parse.nextText());
                            } else {
                                initiator.setDisplayName(parse.nextText());
                            }
                        }
                        if ("StorageClass".equalsIgnoreCase(nodeName)) {
                            // empty if block
                        }
                        if ("PartNumberMarker".equalsIgnoreCase(nodeName)) {
                            partsResult.setPartNumberMarker(parse.nextText());
                        }
                        if ("NextPartNumberMarker".equalsIgnoreCase(nodeName)) {
                            partsResult.setNextPartNumberMarker(parse.nextText());
                        }
                        if ("MaxParts".equalsIgnoreCase(nodeName)) {
                            partsResult.setMaxParts(parse.nextText());
                        }
                        if ("IsTruncated".equalsIgnoreCase(nodeName)) {
                            partsResult.setTruncated(Boolean.valueOf(parse.nextText()));
                        }
                        if ("Part".equalsIgnoreCase(nodeName)) {
                            part = new Part();
                        }
                        if ("PartNumber".equalsIgnoreCase(nodeName)) {
                            part.setPartNumber(Integer.valueOf(parse.nextText()));
                        }
                        if ("LastModified".equalsIgnoreCase(nodeName) && !StringUtils.isBlank(dateStr = parse.nextText())) {
                            part.setLastModified(DateUtil.ConverToDate(dateStr));
                        }
                        if ("ETag".equalsIgnoreCase(nodeName)) {
                            part.setETag(parse.nextText());
                        }
                        if ("Size".equalsIgnoreCase(nodeName)) {
                            part.setSize(Long.valueOf(parse.nextText()));
                        }
                        if (!"Encoding-Type".equalsIgnoreCase(nodeName)) break;
                        partsResult.setEncodingType(parse.nextText());
                        break;
                    }
                    case 3: {
                        if ("ListPartsResult".equalsIgnoreCase(nodeName)) {
                            // empty if block
                        }
                        if ("Initiator".equalsIgnoreCase(nodeName)) {
                            partsResult.setInitiator(initiator);
                        }
                        if ("Owner".equalsIgnoreCase(nodeName)) {
                            isOwner = false;
                            partsResult.setOwner(owner);
                        }
                        if (!"Part".equalsIgnoreCase(nodeName)) break;
                        partsResult.getParts().add(part);
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                eventType = parse.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return partsResult;
    }
}

