/*
 * Decompiled with CFR 0.152.
 */
package com.github.promeg.pinyinhelper;

import com.github.promeg.pinyinhelper.Engine;
import com.github.promeg.pinyinhelper.ForwardLongestSelector;
import com.github.promeg.pinyinhelper.PinyinCode1;
import com.github.promeg.pinyinhelper.PinyinCode2;
import com.github.promeg.pinyinhelper.PinyinCode3;
import com.github.promeg.pinyinhelper.PinyinData;
import com.github.promeg.pinyinhelper.PinyinDict;
import com.github.promeg.pinyinhelper.SegmentationSelector;
import com.github.promeg.pinyinhelper.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ahocorasick.trie.Trie;

public final class Pinyin {
    static Trie mTrieDict = null;
    static SegmentationSelector mSelector = null;
    static List<PinyinDict> mPinyinDicts = null;

    private Pinyin() {
    }

    public static void init(Config config) {
        if (config == null) {
            mPinyinDicts = null;
            mTrieDict = null;
            mSelector = null;
            return;
        }
        if (!config.valid()) {
            return;
        }
        mPinyinDicts = Collections.unmodifiableList(config.getPinyinDicts());
        mTrieDict = Utils.dictsToTrie(config.getPinyinDicts());
        mSelector = config.getSelector();
    }

    public static void add(PinyinDict dict) {
        if (dict == null || dict.words() == null || dict.words().size() == 0) {
            return;
        }
        Pinyin.init(new Config(mPinyinDicts).with(dict));
    }

    public static Config newConfig() {
        return new Config(null);
    }

    public static String toPinyin(String str, String separator) {
        return Engine.toPinyin(str, mTrieDict, mPinyinDicts, separator, mSelector);
    }

    public static String toPinyin(char c) {
        if (Pinyin.isChinese(c)) {
            if (c == '\u3007') {
                return "LING";
            }
            return PinyinData.PINYIN_TABLE[Pinyin.getPinyinCode(c)];
        }
        return String.valueOf(c);
    }

    public static boolean isChinese(char c) {
        return '\u4e00' <= c && c <= '\u9fa5' && Pinyin.getPinyinCode(c) > 0 || '\u3007' == c;
    }

    private static int getPinyinCode(char c) {
        int offset = c - 19968;
        if (0 <= offset && offset < 7000) {
            return Pinyin.decodeIndex(PinyinCode1.PINYIN_CODE_PADDING, PinyinCode1.PINYIN_CODE, offset);
        }
        if (7000 <= offset && offset < 14000) {
            return Pinyin.decodeIndex(PinyinCode2.PINYIN_CODE_PADDING, PinyinCode2.PINYIN_CODE, offset - 7000);
        }
        return Pinyin.decodeIndex(PinyinCode3.PINYIN_CODE_PADDING, PinyinCode3.PINYIN_CODE, offset - 14000);
    }

    private static short decodeIndex(byte[] paddings, byte[] indexes, int offset) {
        int index1 = offset / 8;
        int index2 = offset % 8;
        short realIndex = (short)(indexes[offset] & 0xFF);
        if ((paddings[index1] & PinyinData.BIT_MASKS[index2]) != 0) {
            realIndex = (short)(realIndex | 0x100);
        }
        return realIndex;
    }

    public static final class Config {
        SegmentationSelector mSelector;
        List<PinyinDict> mPinyinDicts;

        private Config(List<PinyinDict> dicts) {
            if (dicts != null) {
                this.mPinyinDicts = new ArrayList<PinyinDict>(dicts);
            }
            this.mSelector = new ForwardLongestSelector();
        }

        public Config with(PinyinDict dict) {
            if (dict != null) {
                if (this.mPinyinDicts == null) {
                    this.mPinyinDicts = new ArrayList<PinyinDict>();
                    this.mPinyinDicts.add(dict);
                } else if (!this.mPinyinDicts.contains(dict)) {
                    this.mPinyinDicts.add(dict);
                }
            }
            return this;
        }

        boolean valid() {
            return this.getPinyinDicts() != null && this.getSelector() != null;
        }

        SegmentationSelector getSelector() {
            return this.mSelector;
        }

        List<PinyinDict> getPinyinDicts() {
            return this.mPinyinDicts;
        }
    }
}

