/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.mcssdk;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.text.TextUtils;
import com.heytap.mcssdk.b;
import com.heytap.mcssdk.e.d;
import com.heytap.mcssdk.f.c;
import com.heytap.mcssdk.utils.StatUtil;
import com.heytap.mcssdk.utils.Utils;
import com.heytap.msp.push.callback.ICallBackResultService;
import com.heytap.msp.push.callback.IGetAppNotificationCallBackService;
import com.heytap.msp.push.callback.ISetAppNotificationCallBackService;
import com.heytap.msp.push.mode.MessageStat;
import com.heytap.msp.push.statis.StatisticUtils;
import com.mcs.aidl.IMcsSdkService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class PushService
implements b {
    private static final String TAG = PushService.class.getSimpleName();
    private static final int ANDROID_T_SDK_VERSION_CODE = 32;
    private static final int[] OLD_MCS_PACKAGE = new int[]{99, 111, 109, 46, 99, 111, 108, 111, 114, 111, 115, 46, 109, 99, 115};
    private static final int[] OLD_MCS_RECEIVE_SDK_ACTION = new int[]{99, 111, 109, 46, 99, 111, 108, 111, 114, 111, 115, 46, 109, 99, 115, 115, 100, 107, 46, 97, 99, 116, 105, 111, 110, 46, 82, 69, 67, 69, 73, 86, 69, 95, 83, 68, 75, 95, 77, 69, 83, 83, 65, 71, 69};
    private static final int[] NEW_MCS_PACKAGE = new int[]{99, 111, 109, 46, 104, 101, 121, 116, 97, 112, 46, 109, 99, 115};
    private static String NEW_MCS_RECEIVE_SDK_ACTION = "";
    private static final String NEW_MCS_RECEIVE_SDK_ACTION_Base64 = "Y29tLm1jcy5hY3Rpb24uUkVDRUlWRV9TREtfTUVTU0FHRQ==";
    private static final String TYPE = "type";
    private static final int MCS_SUPPORT_VERSION = 1019;
    private static final String EVENT_ID = "eventID";
    private static final String TASK_ID = "taskID";
    private static final String APP_PACKAGE = "appPackage";
    private static final String EXTRA = "extra";
    private static final String MESSAGE_TYPE = "messageType";
    private static final String MESSAGE_ID = "messageID";
    private static final String GLOBAL_ID = "globalID";
    private static final String SUPPORT_OPEN_PUSH = "supportOpenPush";
    private static final String APP_VERSION_NAME = "versionName";
    private static final String APP_VERSION_CODE = "versionCode";
    private static final String PUSH_SDK_VERSION = "pushSdkVersion";
    public static final String MINI_PROGRAM_PKG = "miniProgramPkg";
    private static final int MAX_HOUR_IN_DAY = 23;
    private static final int MAX_MIN_IN_HOUR = 59;
    private static final int SDK_INT_24 = 24;
    private static final int SYSTEM_UID = 1000;
    private static final int DEFAULT_API_MAX_COUNT = 2;
    private static int sCount = 0;
    private static String sMcsPkgName;
    private static boolean sIsNewMcsPkg;
    private Context mContext;
    private List<c> mProcessors = new ArrayList<c>();
    private List<d> mParsers = new ArrayList<d>();
    private String mAuthCode;
    private String mVerifyCode;
    private String mRegisterID = null;
    private ICallBackResultService mICallBackResultService;
    private ISetAppNotificationCallBackService mISetAppNotificationCallBackService;
    private IGetAppNotificationCallBackService mIGetAppNotificationCallBackService;
    private ConcurrentHashMap<Integer, com.heytap.mcssdk.c.a> mAppLimitMap;
    private boolean needStaticRegister = true;

    public PushService init(Context context, boolean bl) {
        if (context == null) {
            throw new IllegalArgumentException("context can't be null");
        }
        this.innerInit(context);
        com.heytap.mcssdk.b.a a2 = new com.heytap.mcssdk.b.a();
        a2.a(this.mContext);
        com.heytap.mcssdk.utils.d.f(bl);
        return this;
    }

    public void innerInit(Context context) {
        this.mContext = context.getApplicationContext();
        if (sMcsPkgName == null) {
            String string2 = this.getMcsPackageNameInner(context);
            if (string2 == null) {
                sMcsPkgName = Utils.getString(OLD_MCS_PACKAGE);
                sIsNewMcsPkg = false;
            } else {
                sMcsPkgName = string2;
                sIsNewMcsPkg = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PushService() {
        Class<PushService> clazz = PushService.class;
        synchronized (PushService.class) {
            if (sCount > 0) {
                throw new RuntimeException("PushService can't create again!");
            }
            ++sCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.addParser(new com.heytap.mcssdk.e.b());
            this.addParser(new com.heytap.mcssdk.e.a());
            this.addProcessor(new com.heytap.mcssdk.f.b());
            this.addProcessor(new com.heytap.mcssdk.f.a());
            this.mAppLimitMap = new ConcurrentHashMap();
            return;
        }
    }

    public static PushService getInstance() {
        return a.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMcsPackageNameInner(Context context) {
        com.heytap.mcssdk.utils.d.b(TAG, "getMcsPackageNameInner -- ");
        String string2 = null;
        if (Build.VERSION.SDK_INT >= 24) {
            PackageManager packageManager = context.getPackageManager();
            try {
                String string3 = Utils.getString(NEW_MCS_PACKAGE);
                ApplicationInfo applicationInfo = packageManager.getApplicationInfo(string3, 0);
                if (applicationInfo != null) {
                    boolean bl;
                    boolean bl2 = (applicationInfo.flags & 1) == 1;
                    int n = packageManager.getPackageUid(string3, 0);
                    int n2 = packageManager.getPackageUid("android", 0);
                    boolean bl3 = bl = n == n2;
                    if (bl2 || bl) {
                        string2 = string3;
                        return string2;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                com.heytap.mcssdk.utils.d.e(TAG, "NameNotFoundException in get mcs package name:" + nameNotFoundException.getMessage());
            }
            catch (Exception exception) {
                com.heytap.mcssdk.utils.d.e(TAG, "Error in get mcs package name:" + exception.getMessage());
            }
            finally {
                return string2;
            }
        }
        return string2;
    }

    public String getMcsPackageName(Context context) {
        if (sMcsPkgName == null) {
            String string2 = this.getMcsPackageNameInner(context);
            if (string2 == null) {
                sMcsPkgName = Utils.getString(OLD_MCS_PACKAGE);
                sIsNewMcsPkg = false;
            } else {
                sMcsPkgName = string2;
                sIsNewMcsPkg = true;
            }
        }
        return sMcsPkgName;
    }

    public String getReceiveSdkAction(Context context) {
        if (sMcsPkgName == null) {
            this.getMcsPackageNameInner(context);
        }
        if (sIsNewMcsPkg) {
            if (TextUtils.isEmpty((CharSequence)NEW_MCS_RECEIVE_SDK_ACTION)) {
                NEW_MCS_RECEIVE_SDK_ACTION = new String(com.heytap.mcssdk.a.a.b(NEW_MCS_RECEIVE_SDK_ACTION_Base64));
            }
            return NEW_MCS_RECEIVE_SDK_ACTION;
        }
        return Utils.getString(OLD_MCS_RECEIVE_SDK_ACTION);
    }

    public boolean isSupportPushByClient(Context context) {
        return this.isSupportPushInner(context);
    }

    private boolean isSupportPushInner(Context context) {
        String string2;
        if (this.mContext == null) {
            this.mContext = context.getApplicationContext();
        }
        boolean bl = Utils.isExistPackage(this.mContext, string2 = this.getMcsPackageName(this.mContext)) && Utils.getVersionCode(this.mContext, string2) >= 1019 && Utils.isSupportPush(this.mContext, string2, SUPPORT_OPEN_PUSH);
        com.heytap.mcssdk.utils.d.b(TAG, "isSupportPushInner -- " + bl);
        return bl;
    }

    @Deprecated
    private static void onAppStart(Context context) {
        MessageStat messageStat = new MessageStat(context.getPackageName(), "app_start", null);
        StatUtil.statisticMessage(context, messageStat);
    }

    private synchronized void addProcessor(c c2) {
        if (null != c2) {
            this.mProcessors.add(c2);
        }
    }

    private synchronized void addParser(d d2) {
        if (null != d2) {
            this.mParsers.add(d2);
        }
    }

    public List<d> getParsers() {
        return this.mParsers;
    }

    public List<c> getProcessors() {
        return this.mProcessors;
    }

    private boolean checkContext() {
        return null != this.mContext;
    }

    private boolean checkRegisterID() {
        return null != this.mRegisterID;
    }

    private boolean checkAll() {
        return this.checkContext() && this.checkRegisterID();
    }

    public void setAppKeySecret(String string2, String string3) {
        this.mAuthCode = string2;
        this.mVerifyCode = string3;
    }

    @Override
    public String getRegisterID() {
        return this.mRegisterID;
    }

    @Override
    public void setRegisterID(String string2) {
        this.mRegisterID = string2;
    }

    private void startMcsService(int n, JSONObject jSONObject) {
        this.startMcsService(n, "", jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMiniProgramPkgFromJSON(JSONObject jSONObject) {
        String string2 = "";
        if (jSONObject == null) {
            return string2;
        }
        try {
            string2 = jSONObject.optString(MINI_PROGRAM_PKG);
            return string2;
        }
        catch (Exception exception) {
            com.heytap.mcssdk.utils.d.b("Error happened in getMiniProgramPkgFromJSON() :" + exception.getMessage());
        }
        finally {
            return string2;
        }
    }

    private void startMcsService(int n, String string2, JSONObject jSONObject) {
        if (this.checkCommandLimit(n)) {
            if (this.mICallBackResultService != null) {
                String string3 = this.getMiniProgramPkgFromJSON(jSONObject);
                this.mICallBackResultService.onError(this.getErrorCode(n), "api_call_too_frequently", this.mContext.getPackageName(), string3);
            }
            return;
        }
        try {
            Intent intent = this.getIntent(n, string2, jSONObject);
            this.mContext.startService(intent);
        }
        catch (Exception exception) {
            com.heytap.mcssdk.utils.d.e("startMcsService--Exception" + exception.getMessage());
        }
    }

    public void bindMcsService(int n) {
        if (this.checkCommandLimit(n)) {
            if (this.mICallBackResultService != null) {
                this.mICallBackResultService.onError(this.getErrorCode(n), "api_call_too_frequently", this.mContext.getPackageName(), "");
            }
            return;
        }
        final Intent intent = this.getIntent(n, "", null);
        this.mContext.bindService(intent, new ServiceConnection(){

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                Bundle bundle = new Bundle();
                bundle.putAll(intent.getExtras());
                try {
                    IMcsSdkService iMcsSdkService = IMcsSdkService.Stub.asInterface(iBinder);
                    iMcsSdkService.process(bundle);
                }
                catch (Exception exception) {
                    com.heytap.mcssdk.utils.d.b("bindMcsService exception:" + exception);
                }
                PushService.this.mContext.unbindService((ServiceConnection)this);
            }

            public void onServiceDisconnected(ComponentName componentName) {
            }
        }, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Intent getIntent(int n, String string2, JSONObject jSONObject) {
        Intent intent = new Intent();
        intent.setAction(this.getReceiveSdkAction(this.mContext));
        intent.setPackage(this.getMcsPackageName(this.mContext));
        intent.putExtra(TYPE, n);
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.putOpt(APP_VERSION_NAME, (Object)Utils.getVersionName(this.mContext, this.mContext.getPackageName()));
            jSONObject2.putOpt(APP_VERSION_CODE, (Object)Utils.getVersionCode(this.mContext, this.mContext.getPackageName()));
            if (jSONObject != null) {
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    jSONObject2.putOpt(string3, jSONObject.get(string3));
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            intent.putExtra(EXTRA, jSONObject2.toString());
        }
        intent.putExtra("params", string2);
        intent.putExtra(APP_PACKAGE, this.mContext.getPackageName());
        intent.putExtra("appKey", this.mAuthCode);
        intent.putExtra("appSecret", this.mVerifyCode);
        intent.putExtra("registerID", this.mRegisterID);
        intent.putExtra("sdkVersion", PushService.getSDKVersionName());
        return intent;
    }

    public ICallBackResultService getPushCallback() {
        return this.mICallBackResultService;
    }

    public void setPushCallback(ICallBackResultService iCallBackResultService) {
        this.mICallBackResultService = iCallBackResultService;
    }

    public IGetAppNotificationCallBackService getPushGetAppNotificationCallBack() {
        return this.mIGetAppNotificationCallBackService;
    }

    public ISetAppNotificationCallBackService getPushSetAppNotificationCallBack() {
        return this.mISetAppNotificationCallBackService;
    }

    @Override
    public void register(Context context, String string2, String string3, JSONObject jSONObject, ICallBackResultService iCallBackResultService) {
        if (context == null) {
            if (iCallBackResultService != null) {
                iCallBackResultService.onRegister(-2, null, null, null);
            }
            return;
        }
        if (this.mContext == null) {
            this.mContext = context.getApplicationContext();
        }
        if (!Utils.isSupportPushByClient(this.mContext)) {
            if (iCallBackResultService != null) {
                iCallBackResultService.onRegister(-2, null, null, null);
            }
            return;
        }
        if (this.needStaticRegister) {
            com.heytap.mcssdk.utils.d.b("registerAction:", "Will static push_register event :");
            StatisticUtils.statisticEvent(this.mContext, "push_register");
            this.needStaticRegister = false;
        }
        this.mAuthCode = string2;
        this.mVerifyCode = string3;
        this.mICallBackResultService = iCallBackResultService;
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        try {
            jSONObject.putOpt("appVersionCode", (Object)Utils.getVersionCode(context));
            jSONObject.putOpt("appVersionName", (Object)Utils.getVersionName(context));
        }
        catch (JSONException jSONException) {
            com.heytap.mcssdk.utils.d.e("register-Exception:" + jSONException.getMessage());
        }
        this.startMcsService(12289, jSONObject);
    }

    @Override
    public void register(Context context, String string2, String string3, ICallBackResultService iCallBackResultService) {
        this.register(context, string2, string3, null, iCallBackResultService);
    }

    public void unRegister(Context context, String string2, String string3, JSONObject jSONObject, ICallBackResultService iCallBackResultService) {
        this.mAuthCode = string2;
        this.mVerifyCode = string3;
        this.mContext = context.getApplicationContext();
        this.mICallBackResultService = iCallBackResultService;
        this.unRegister(jSONObject);
    }

    @Override
    public void unRegister(JSONObject jSONObject) {
        if (this.checkContext()) {
            this.startMcsService(12290, jSONObject);
        } else if (this.getPushCallback() != null) {
            String string2 = this.getMiniProgramPkgFromJSON(jSONObject);
            this.getPushCallback().onUnRegister(-2, this.mContext.getPackageName(), string2);
        }
    }

    @Override
    public void unRegister() {
        this.unRegister(null);
    }

    @Override
    public void getRegister(JSONObject jSONObject) {
        if (this.checkContext()) {
            this.startMcsService(12289, jSONObject);
        } else if (this.getPushCallback() != null) {
            this.getPushCallback().onRegister(-2, null, null, null);
        }
    }

    @Override
    public void getRegister() {
        this.getRegister(null);
    }

    @Override
    public void pausePush(JSONObject jSONObject) {
        if (this.checkAll()) {
            this.startMcsService(12299, jSONObject);
        } else {
            com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
        }
    }

    @Override
    public void pausePush() {
        this.pausePush(null);
    }

    @Override
    public void resumePush(JSONObject jSONObject) {
        if (this.checkAll()) {
            this.startMcsService(12300, jSONObject);
        } else {
            com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
        }
    }

    @Override
    public void resumePush() {
        this.resumePush(null);
    }

    @Override
    public void getNotificationStatus(JSONObject jSONObject) {
        if (this.checkAll()) {
            this.startMcsService(12309, jSONObject);
        } else if (this.getPushCallback() != null) {
            this.getPushCallback().onGetNotificationStatus(-2, 0);
        }
    }

    @Override
    public void getNotificationStatus() {
        this.getNotificationStatus(null);
    }

    @Override
    public void setNotificationType(int n, JSONObject jSONObject) {
        if (this.checkAll()) {
            this.startMcsService(12307, n + "", jSONObject);
        } else {
            com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
        }
    }

    @Override
    public void setNotificationType(int n) {
        this.setNotificationType(n, null);
    }

    @Override
    public void clearNotificationType(JSONObject jSONObject) {
        if (this.checkAll()) {
            this.startMcsService(12308, jSONObject);
        } else {
            com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
        }
    }

    @Override
    public void clearNotificationType() {
        this.clearNotificationType(null);
    }

    @Override
    public void openNotificationSettings(JSONObject jSONObject) {
        if (this.checkAll()) {
            this.startMcsService(12310, jSONObject);
        } else {
            com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
        }
    }

    @Override
    public void openNotificationSettings() {
        this.openNotificationSettings(null);
    }

    @Override
    public void clearNotifications() {
        this.clearNotifications(null);
    }

    @Override
    public void clearNotifications(JSONObject jSONObject) {
        if (this.checkContext()) {
            this.startMcsService(12311, jSONObject);
        } else {
            com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
        }
    }

    public void getPushStatus() {
        if (this.checkAll()) {
            this.startMcsService(12306, null);
        } else if (this.getPushCallback() != null) {
            this.getPushCallback().onGetPushStatus(-2, 0);
        }
    }

    public static String getSDKVersionName() {
        return "3.4.0";
    }

    public static int getSDKVersionCode() {
        return 3400;
    }

    public String getPushVersionName() {
        if (this.checkContext()) {
            return Utils.getVersionName(this.mContext, this.getMcsPackageName(this.mContext));
        }
        return "";
    }

    public int getPushVersionCode() {
        if (this.checkContext()) {
            return Utils.getVersionCode(this.mContext, this.getMcsPackageName(this.mContext));
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setPushTime(List<Integer> list, int n, int n2, int n3, int n4, JSONObject jSONObject) {
        if (this.checkAll()) {
            if (null == list || list.size() <= 0 || n < 0 || n2 < 0 || n3 < n || n3 > 23 || n4 < n2 || n4 > 59) throw new IllegalArgumentException("params are not all right,please check params");
            try {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("weekDays", (Object)com.heytap.mcssdk.c.b.a(list));
                jSONObject2.put("startHour", n);
                jSONObject2.put("startMin", n2);
                jSONObject2.put("endHour", n3);
                jSONObject2.put("endMin", n4);
                this.startMcsService(12298, jSONObject2.toString(), jSONObject);
                return;
            }
            catch (JSONException jSONException) {
                com.heytap.mcssdk.utils.d.e("mcssdk---", jSONException.getLocalizedMessage());
            }
            return;
        } else {
            if (this.getPushCallback() == null) return;
            this.getPushCallback().onSetPushTime(-2, "please call the register first!");
        }
    }

    @Override
    public void setPushTime(List<Integer> list, int n, int n2, int n3, int n4) {
        this.setPushTime(list, n, n2, n3, n4, null);
    }

    @Override
    public void requestNotificationPermission() {
        if (Build.VERSION.SDK_INT >= 32) {
            com.heytap.mcssdk.utils.d.b(TAG, "requestNotificationPermission() will return due to Android T device , current device Android SDK version code is :" + Build.VERSION.SDK_INT);
            return;
        }
        if (this.checkContext()) {
            this.bindMcsService(12313);
        } else {
            com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
        }
    }

    @Override
    public void enableAppNotificationSwitch(ISetAppNotificationCallBackService iSetAppNotificationCallBackService) {
        if (this.checkContext()) {
            this.mISetAppNotificationCallBackService = iSetAppNotificationCallBackService;
            this.startMcsService(12316, null);
        } else if (this.mISetAppNotificationCallBackService != null) {
            this.mISetAppNotificationCallBackService.onSetAppNotificationSwitch(-2);
        }
    }

    @Override
    public void disableAppNotificationSwitch(ISetAppNotificationCallBackService iSetAppNotificationCallBackService) {
        if (this.checkContext()) {
            this.mISetAppNotificationCallBackService = iSetAppNotificationCallBackService;
            this.startMcsService(12317, null);
        } else if (this.getPushCallback() != null) {
            this.mISetAppNotificationCallBackService.onSetAppNotificationSwitch(-2);
        }
    }

    @Override
    public void getAppNotificationSwitch(IGetAppNotificationCallBackService iGetAppNotificationCallBackService) {
        if (this.checkContext()) {
            this.mIGetAppNotificationCallBackService = iGetAppNotificationCallBackService;
            this.startMcsService(12318, null);
        } else if (this.mIGetAppNotificationCallBackService != null) {
            this.mIGetAppNotificationCallBackService.onGetAppNotificationSwitch(-2, 0);
        }
    }

    @Override
    public void cancelNotification(JSONObject jSONObject) {
        if (this.checkAll()) {
            this.startMcsService(12319, jSONObject);
        } else {
            com.heytap.mcssdk.utils.d.e("mcssdk---", "please call the register first!");
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public Map<Integer, com.heytap.mcssdk.c.a> getAppLimitMap() {
        return this.mAppLimitMap;
    }

    public boolean checkCommandLimit(int n) {
        com.heytap.mcssdk.c.a a2 = this.addCommandToMap(n);
        if (n != 12291 && n != 12312) {
            return a2.b() > 2;
        }
        return false;
    }

    private com.heytap.mcssdk.c.a addCommandToMap(int n) {
        com.heytap.mcssdk.c.a a2;
        if (this.mAppLimitMap.containsKey(n)) {
            a2 = this.mAppLimitMap.get(n);
            if (this.checkTimeNeedUpdate(a2)) {
                a2.a(1);
                a2.a(System.currentTimeMillis());
                com.heytap.mcssdk.utils.d.b("addCommandToMap : appLimitBean.setCount(1)");
            } else {
                a2.a(a2.b() + 1);
                com.heytap.mcssdk.utils.d.b("addCommandToMap :appLimitBean.getCount() + 1");
            }
        } else {
            a2 = new com.heytap.mcssdk.c.a(System.currentTimeMillis(), 1);
            this.mAppLimitMap.put(n, a2);
            com.heytap.mcssdk.utils.d.b("addCommandToMap :appBean is null");
        }
        return a2;
    }

    private boolean checkTimeNeedUpdate(com.heytap.mcssdk.c.a a2) {
        long l = a2.a();
        long l2 = System.currentTimeMillis();
        com.heytap.mcssdk.utils.d.b("checkTimeNeedUpdate : lastedTime " + l + " currentTime:" + l2);
        return l2 - l > 1000L;
    }

    public int getErrorCode(int n) {
        switch (n) {
            case 12289: {
                return -1;
            }
            case 12290: {
                return -2;
            }
            case 12299: {
                return -3;
            }
            case 12300: {
                return -4;
            }
            case 12309: {
                return -5;
            }
            case 12307: {
                return -6;
            }
            case 12308: {
                return -7;
            }
            case 12310: {
                return -8;
            }
            case 12311: {
                return -9;
            }
            case 12306: {
                return -10;
            }
            case 12298: {
                return -11;
            }
            case 12313: {
                return -12;
            }
            case 12312: {
                return -13;
            }
            case 12291: {
                return -14;
            }
            case 12316: {
                return -15;
            }
            case 12317: {
                return -16;
            }
            case 12318: {
                return -17;
            }
        }
        return 0;
    }

    private static class a {
        private static final PushService a = new PushService();

        private a() {
        }
    }
}

