/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.action;

import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.SimpleJSCallback;
import com.taobao.weex.ui.action.BasicGraphicAction;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.list.template.jni.NativeRenderObjectUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.HashMap;

public class ActionGetLayoutDirection
extends BasicGraphicAction {
    private final String mCallback;

    public ActionGetLayoutDirection(WXSDKInstance instance, String ref, String callback) {
        super(instance, ref);
        this.mCallback = callback;
    }

    @Override
    public void executeAction() {
        WXSDKInstance instance = this.getWXSDKIntance();
        if (instance == null || instance.isDestroy()) {
            return;
        }
        SimpleJSCallback jsCallback = new SimpleJSCallback(instance.getInstanceId(), this.mCallback);
        if (TextUtils.isEmpty((CharSequence)this.getRef())) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("result", false);
            options.put("errMsg", "Illegal parameter");
            jsCallback.invoke(options);
        } else if ("viewport".equalsIgnoreCase(this.getRef())) {
            this.callbackViewport(instance, jsCallback);
        } else {
            WXComponent component = WXSDKManager.getInstance().getWXRenderManager().getWXComponent(this.getPageId(), this.getRef());
            if (component == null) {
                return;
            }
            String directionRet = "ltr";
            if (component != null) {
                int direction = NativeRenderObjectUtils.nativeRenderObjectGetLayoutDirectionFromPathNode(component.getRenderObjectPtr());
                switch (direction) {
                    case 0: {
                        directionRet = "inherit";
                        break;
                    }
                    case 1: {
                        directionRet = "ltr";
                        break;
                    }
                    case 2: {
                        directionRet = "rtl";
                        break;
                    }
                    default: {
                        directionRet = "ltr";
                    }
                }
            }
            jsCallback.invoke(directionRet);
        }
    }

    private void callbackViewport(WXSDKInstance instance, JSCallback jsCallback) {
        View container = instance.getContainerView();
        if (container != null) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("direction", "ltr");
            options.put("result", true);
            jsCallback.invoke(options);
        } else {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("result", false);
            options.put("errMsg", "Component does not exist");
            jsCallback.invoke(options);
        }
    }

    @NonNull
    private float getWebPxValue(int value, int viewport) {
        return WXViewUtils.getWebPxByWidth((float)value, viewport);
    }
}

