/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.message;

import com.liulishuo.filedownloader.message.MessageSnapshot;
import com.liulishuo.filedownloader.message.MessageSnapshotFlow;
import com.liulishuo.filedownloader.util.FileDownloadExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class MessageSnapshotThreadPool {
    private final List<FlowSingleExecutor> executorList;
    private final MessageSnapshotFlow.MessageReceiver receiver;

    MessageSnapshotThreadPool(int poolCount, MessageSnapshotFlow.MessageReceiver receiver) {
        this.receiver = receiver;
        this.executorList = new ArrayList<FlowSingleExecutor>();
        for (int i = 0; i < poolCount; ++i) {
            this.executorList.add(new FlowSingleExecutor(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(MessageSnapshot snapshot) {
        FlowSingleExecutor targetPool = null;
        try {
            List<FlowSingleExecutor> list = this.executorList;
            synchronized (list) {
                int id = snapshot.getId();
                for (FlowSingleExecutor executor : this.executorList) {
                    if (!executor.enQueueTaskIdList.contains(id)) continue;
                    targetPool = executor;
                    break;
                }
                if (targetPool == null) {
                    int leastTaskCount = 0;
                    for (FlowSingleExecutor executor : this.executorList) {
                        if (executor.enQueueTaskIdList.size() <= 0) {
                            targetPool = executor;
                            break;
                        }
                        if (leastTaskCount != 0 && executor.enQueueTaskIdList.size() >= leastTaskCount) continue;
                        leastTaskCount = executor.enQueueTaskIdList.size();
                        targetPool = executor;
                    }
                }
                targetPool.enqueue(id);
            }
        }
        finally {
            targetPool.execute(snapshot);
        }
    }

    public class FlowSingleExecutor {
        private final List<Integer> enQueueTaskIdList = new ArrayList<Integer>();
        private final Executor mExecutor;

        public FlowSingleExecutor(int index) {
            this.mExecutor = FileDownloadExecutors.newDefaultThreadPool(1, "Flow-" + index);
        }

        public void enqueue(int id) {
            this.enQueueTaskIdList.add(id);
        }

        public void execute(final MessageSnapshot snapshot) {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    MessageSnapshotThreadPool.this.receiver.receive(snapshot);
                    FlowSingleExecutor.this.enQueueTaskIdList.remove((Object)snapshot.getId());
                }
            });
        }
    }
}

