/*
 * Decompiled with CFR 0.152.
 */
package com.wonderkiln.camerakit.events;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.wonderkiln.camerakit.events.CameraKitError;
import com.wonderkiln.camerakit.events.CameraKitEvent;
import com.wonderkiln.camerakit.events.CameraKitEventListener;
import com.wonderkiln.camerakit.events.CameraKitImage;
import com.wonderkiln.camerakit.events.CameraKitVideo;
import com.wonderkiln.camerakit.events.OnCameraKitEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventDispatcher {
    private Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private List<CameraKitEventListener> listeners = new ArrayList<CameraKitEventListener>();
    private List<BindingHandler> bindings = new ArrayList<BindingHandler>();

    public void addListener(CameraKitEventListener listener) {
        this.listeners.add(listener);
    }

    public void addBinding(Object binding) {
        this.bindings.add(new BindingHandler(binding));
    }

    public void dispatch(final CameraKitEvent event) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                for (CameraKitEventListener listener : EventDispatcher.this.listeners) {
                    listener.onEvent(event);
                    if (event instanceof CameraKitError) {
                        listener.onError((CameraKitError)event);
                    }
                    if (event instanceof CameraKitImage) {
                        listener.onImage((CameraKitImage)event);
                    }
                    if (!(event instanceof CameraKitVideo)) continue;
                    listener.onVideo((CameraKitVideo)event);
                }
                for (BindingHandler handler : EventDispatcher.this.bindings) {
                    try {
                        handler.dispatchEvent(event);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private class BindingHandler {
        private Map<Class, List<MethodHolder>> methods = new HashMap<Class, List<MethodHolder>>();

        public BindingHandler(Object binding) {
            for (Method method : binding.getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(OnCameraKitEvent.class)) continue;
                OnCameraKitEvent annotation = method.getAnnotation(OnCameraKitEvent.class);
                Class<? extends CameraKitEvent> eventType = annotation.value();
                this.addMethod(binding, method, eventType, this.methods);
            }
        }

        private void addMethod(Object binding, Method method, Class<? extends CameraKitEvent> type, Map<Class, List<MethodHolder>> store) {
            if (!store.containsKey(type)) {
                store.put(type, new ArrayList());
            }
            store.get(type).add(new MethodHolder(binding, method));
        }

        public void dispatchEvent(@NonNull CameraKitEvent event) throws IllegalAccessException, InvocationTargetException {
            List<MethodHolder> targetMethods;
            List<MethodHolder> baseMethods = this.methods.get(CameraKitEvent.class);
            if (baseMethods != null) {
                for (MethodHolder methodHolder : baseMethods) {
                    methodHolder.getMethod().invoke(methodHolder.getBinding(), event);
                }
            }
            if ((targetMethods = this.methods.get(event.getClass())) != null) {
                for (MethodHolder methodHolder : targetMethods) {
                    methodHolder.getMethod().invoke(methodHolder.getBinding(), event);
                }
            }
        }

        private class MethodHolder {
            private Object binding;
            private Method method;

            public MethodHolder(Object binding, Method method) {
                this.binding = binding;
                this.method = method;
            }

            public Object getBinding() {
                return this.binding;
            }

            public Method getMethod() {
                return this.method;
            }
        }
    }
}

