/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio.musicdecoder;

import android.media.MediaFormat;
import com.tencent.liteav.audio.musicdecoder.MediaCodecBridge;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::audio")
public class MusicResourceDecoderAndroid {
    private static final String TAG = "MusicResourceDecoderAndroid";
    private final MediaCodecBridge mDecoder = new MediaCodecBridge();

    @CalledByNative
    public MusicResourceDecoderAndroid() {
    }

    @CalledByNative
    public boolean start(String path) {
        return this.mDecoder.initAndStart(path);
    }

    @CalledByNative
    public boolean seekTo(long timeMs) {
        return this.mDecoder.seekTo(timeMs * 1000L);
    }

    @CalledByNative
    public ByteBuffer decode() {
        return this.mDecoder.processFrame();
    }

    @CalledByNative
    public int getSampleRate() {
        MediaFormat mediaFormat = this.mDecoder.getOutputFormat();
        if (mediaFormat == null) {
            return -1;
        }
        int n2 = -1;
        try {
            n2 = mediaFormat.getInteger("sample-rate");
        }
        catch (Exception exception) {
            Log.e(TAG, "getSampleRate failed. ".concat(String.valueOf(exception)), new Object[0]);
        }
        return n2;
    }

    @CalledByNative
    public int getChannelCount() {
        MediaFormat mediaFormat = this.mDecoder.getOutputFormat();
        if (mediaFormat == null) {
            return -1;
        }
        int n2 = -1;
        try {
            n2 = mediaFormat.getInteger("channel-count");
        }
        catch (Exception exception) {
            Log.e(TAG, "getChannelCount failed. ".concat(String.valueOf(exception)), new Object[0]);
        }
        return n2;
    }

    @CalledByNative
    public long getDuration() {
        return (this.mDecoder.getLongestDuration() + 500L) / 1000L;
    }

    @CalledByNative
    public int getBitrate() {
        MediaFormat mediaFormat = this.mDecoder.getOutputFormat();
        if (mediaFormat == null) {
            return -1;
        }
        int n2 = -1;
        try {
            n2 = mediaFormat.getInteger("bitrate");
        }
        catch (Exception exception) {
            Log.e(TAG, "getDuration failed. ".concat(String.valueOf(exception)), new Object[0]);
        }
        return n2;
    }

    @CalledByNative
    public int getTrackCount() {
        return this.mDecoder.getTrackCount();
    }

    @CalledByNative
    public void setMusicTrack(int index) {
        this.mDecoder.setMusicTrack(index);
    }

    @CalledByNative
    public int getTotalRawDataSize() {
        return this.mDecoder.getTotalRawDataSize();
    }

    @CalledByNative
    public boolean isDecodeEnd() {
        return this.mDecoder.isDecodeEnd();
    }

    @CalledByNative
    public void stop() {
        this.mDecoder.stop();
    }
}

