/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio.route;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRecordingConfiguration;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.RequiresApi;
import com.tencent.liteav.audio.route.a;
import com.tencent.liteav.audio.route.b;
import com.tencent.liteav.audio.route.c;
import com.tencent.liteav.audio.route.d;
import com.tencent.liteav.audio.route.e;
import com.tencent.liteav.audio.route.f;
import com.tencent.liteav.audio.route.g;
import com.tencent.liteav.audio.route.h;
import com.tencent.liteav.audio.route.i;
import com.tencent.liteav.audio.route.j;
import com.tencent.liteav.audio.route.k;
import com.tencent.liteav.audio.route.l;
import com.tencent.liteav.audio.route.m;
import com.tencent.liteav.audio.route.n;
import com.tencent.liteav.audio.route.o;
import com.tencent.liteav.audio.route.p;
import com.tencent.liteav.audio.route.q;
import com.tencent.liteav.audio.route.r;
import com.tencent.liteav.audio.route.s;
import com.tencent.liteav.audio.route.t;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.CustomHandler;
import java.util.Iterator;
import java.util.List;

@JNINamespace(value="liteav::audio")
public class AudioRouteManager
extends t.a
implements t.c {
    private static final String TAG = "AudioRouteManager";
    private static final long IN_CALL_DETECTION_TIME = 500L;
    private static final int BLUETOOTH_SCO_RECONNECT_INTERVAL = 1000;
    private static final int RECORDING_CONFIGS_LIMIT = 10;
    private final r mAudioRouteSupervisor;
    private final long mNativeAudioRouteManager;
    private final AudioManager mAudioManager;
    private final t mBroadcastReceiver;
    private CustomHandler mHandler = null;
    private boolean mIsServiceStarted = false;
    private a mCurrentAudioIOScene = a.a;
    private a mExpectedAudioIOScene = a.a;
    private b.a mCurrentRouteType = b.a.a;
    private s.a mSwitcher = null;
    private String mCurrentRouteConfig = "";
    private boolean mHasModeConflict = false;
    private int mCurrentSystemVolume = -1;
    private AudioManager.AudioRecordingCallback mAudioRecordingCallback = null;
    private AudioDeviceCallback mAudioDeviceCallback = null;
    private final Runnable mForceUpdateRouteRunnable = c.a(this);
    private s.a.a mSwitcherListener = new s.a.a(){

        @Override
        public final void a(b.a a2) {
            AudioRouteManager.nativeNotifyAudioRouteChangedFromJava(AudioRouteManager.this.mNativeAudioRouteManager, a2.value);
        }

        @Override
        public final void b(b.a a2) {
            if (a2 == b.a.e) {
                Log.w(AudioRouteManager.TAG, "switch to bluetooth failed  mode conflict:" + AudioRouteManager.this.mHasModeConflict + " ,set it unavailable and update route again", new Object[0]);
                AudioRouteManager.this.mAudioRouteSupervisor.a(b.a.e, false);
                AudioRouteManager.this.autoCheckRouteUpdate(false);
                AudioRouteManager.nativeNotifyBluetoothConnectionFailedFromJava(AudioRouteManager.this.mNativeAudioRouteManager, AudioRouteManager.this.mHasModeConflict);
                return;
            }
            Log.w(AudioRouteManager.TAG, "switch to %s failed, do nothing", new Object[]{a2});
        }
    };

    @CalledByNative
    public AudioRouteManager(long nativeAudioRouteManager) {
        this.mNativeAudioRouteManager = nativeAudioRouteManager;
        Context context = ContextUtils.getApplicationContext();
        this.mAudioRouteSupervisor = new r();
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        AudioRouteManager audioRouteManager = this;
        this.mBroadcastReceiver = new t(context, audioRouteManager, audioRouteManager);
    }

    @CalledByNative
    public void initialize() {
        HandlerThread handlerThread = new HandlerThread("AudioRouteManagerLooper");
        handlerThread.start();
        this.mHandler = new CustomHandler(handlerThread.getLooper());
    }

    @CalledByNative
    public void start(String configString) {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThread(g.a(audioRouteManager, configString));
    }

    @CalledByNative
    public void stop() {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThread(h.a(audioRouteManager));
    }

    @CalledByNative
    public void enableUsbDevice(boolean enable) {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThread(i.a(audioRouteManager, enable));
    }

    @CalledByNative
    public void notifyAudioIOSceneChanged(int newScene, long timeout) {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThreadAndWaitDone(j.a(audioRouteManager, newScene), timeout);
    }

    @CalledByNative
    public void setHandFreeModeEnabled(boolean enable) {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThread(k.a(audioRouteManager, enable));
    }

    @CalledByNative
    public void uninitialize() {
        CustomHandler customHandler = this.mHandler;
        this.mHandler = null;
        if (customHandler != null) {
            customHandler.quitLooperAndWaitDone();
        }
    }

    @Override
    public void onWiredHeadsetConnectionChanged(boolean connected) {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThread(l.a(audioRouteManager, connected));
    }

    @Override
    public void onBluetoothConnectionChanged(boolean connected) {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThread(m.a(audioRouteManager, connected));
    }

    @Override
    public void onBluetoothSCOConnected(boolean connected) {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThread(n.a(audioRouteManager, connected));
    }

    @Override
    public void onUsbConnectionChanged(boolean connected) {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThread(d.a(audioRouteManager, connected));
    }

    private void startInternal(String configString) {
        boolean bl2;
        Object object;
        String string;
        block17: {
            Log.i(TAG, "startInternal", new Object[0]);
            if (this.mIsServiceStarted) {
                if (this.mCurrentRouteConfig.equals(configString)) {
                    return;
                }
                Log.w(TAG, "AudioRouteManager's been started, stop it first", new Object[0]);
                this.stopInternal();
            }
            string = configString;
            object = this.mAudioRouteSupervisor;
            if (object.c) {
                Log.w("AudioRouteSupervisor", "error in initialize(), it's already initialized", new Object[0]);
                bl2 = false;
            } else {
                Log.i("AudioRouteSupervisor", "initialize from string: ".concat(String.valueOf(string)), new Object[0]);
                if (string == null || string.length() <= 0) {
                    bl2 = false;
                } else if ((string = string.replace("[\n\r]", "")).length() <= 0) {
                    bl2 = false;
                } else {
                    String[] stringArray = string.split(";");
                    if (stringArray.length <= 0) {
                        bl2 = false;
                    } else {
                        for (int i2 = 0; i2 < stringArray.length; ++i2) {
                            boolean bl3;
                            int n2 = i2;
                            b.a a2 = b.a.a(stringArray[i2]);
                            Object object2 = object;
                            if (a2 == b.a.a) {
                                Log.e("AudioRouteSupervisor", "error, unknown route name: ".concat(String.valueOf((Object)a2)), new Object[0]);
                                bl3 = false;
                            } else if (object2.b.containsKey((Object)a2)) {
                                Log.e("AudioRouteSupervisor", "error, existed route name: ".concat(String.valueOf((Object)a2)), new Object[0]);
                                bl3 = false;
                            } else {
                                boolean bl4 = a2 == b.a.c || a2 == b.a.b;
                                b b2 = new b(a2, n2, bl4);
                                object2.b.put(a2, b2);
                                Log.i("AudioRouteSupervisor", "add audio route, name: %s", new Object[]{a2});
                                bl3 = true;
                            }
                            if (bl3) continue;
                            bl2 = false;
                            break block17;
                        }
                        object.c = true;
                        bl2 = true;
                    }
                }
            }
        }
        if (!bl2) {
            Log.e(TAG, "AudioRouteManager start failed", new Object[0]);
            return;
        }
        object = this.mBroadcastReceiver;
        if (((t)((Object)object)).b == null) {
            ((t)((Object)object)).b = new t.b(((t)((Object)object)).a);
        }
        string = new IntentFilter();
        string.addAction("android.intent.action.HEADSET_PLUG");
        string.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        string.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        string.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        string.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        string.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        string.addAction("android.media.VOLUME_CHANGED_ACTION");
        ((t)((Object)object)).a.registerReceiver((BroadcastReceiver)object, (IntentFilter)string);
        this.registerAudioDeviceCallback();
        this.updateAudioRouteStatus();
        this.mCurrentRouteConfig = configString;
        this.registerAudioRecordingCallback();
        this.mIsServiceStarted = true;
        this.mHasModeConflict = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopInternal() {
        Log.i(TAG, "stopInternal", new Object[0]);
        if (!this.mIsServiceStarted) {
            Log.e(TAG, "AudioRouteManager is not started", new Object[0]);
            return;
        }
        this.unregisterAudioRecordingCallback();
        this.destroySwitcher();
        try {
            this.mAudioManager.setMode(0);
        }
        catch (Exception exception) {
            Log.w(TAG, "AudioManager setMode failed, ignore it", new Object[0]);
        }
        this.mCurrentRouteType = b.a.a;
        this.mCurrentAudioIOScene = a.a;
        this.mExpectedAudioIOScene = a.a;
        Object object = this.mBroadcastReceiver;
        if (object.a != null) {
            try {
                object.a.unregisterReceiver((BroadcastReceiver)object);
            }
            catch (Exception exception) {}
            if (object.b != null) {
                t.b b2 = object.b;
                Object object2 = b2.c;
                synchronized (object2) {
                    if (b2.a != null && b2.b != null) {
                        b2.b();
                        b2.b = null;
                    }
                }
                object.b = null;
            }
        }
        this.unregisterAudioDeviceCallback();
        object = this.mAudioRouteSupervisor;
        if (!((r)object).c) {
            Log.w("AudioRouteSupervisor", "error in uninitialize(), it's not been initialized yet", new Object[0]);
        } else {
            ((r)object).b.clear();
            ((r)object).c = false;
        }
        this.mCurrentRouteConfig = "";
        this.mIsServiceStarted = false;
        this.mHasModeConflict = false;
    }

    private void enableUsbDeviceInternal(boolean enable) {
        if (this.mBroadcastReceiver == null) {
            Log.e(TAG, "broadcast receiver is null", new Object[0]);
            return;
        }
        Log.i(TAG, "enable usb device: ".concat(String.valueOf(enable)), new Object[0]);
        this.mBroadcastReceiver.c = enable;
        this.updateAudioRouteStatus();
    }

    @SuppressLint(value={"NewApi"})
    private void registerAudioRecordingCallback() {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 24) {
            return;
        }
        if (this.mAudioRecordingCallback == null) {
            this.buildAudioRecordingCallback();
        }
        this.mAudioManager.registerAudioRecordingCallback(this.mAudioRecordingCallback, null);
    }

    @SuppressLint(value={"NewApi"})
    private void unregisterAudioRecordingCallback() {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 24) {
            return;
        }
        if (this.mAudioRecordingCallback == null) {
            return;
        }
        this.mAudioManager.unregisterAudioRecordingCallback(this.mAudioRecordingCallback);
    }

    @RequiresApi(api=24)
    private void buildAudioRecordingCallback() {
        if (this.mAudioRecordingCallback != null) {
            return;
        }
        this.mAudioRecordingCallback = new AudioManager.AudioRecordingCallback(){

            public final void onRecordingConfigChanged(List<AudioRecordingConfiguration> configs) {
                AudioRouteManager.this.runOnWorkThread(o.a(this, configs));
            }

            static /* synthetic */ void a(2 var0, List list) {
                var0.AudioRouteManager.this.handleRecordingConfigChanged(list);
            }
        };
    }

    @Override
    public void onSystemVolumeChanged() {
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.runOnWorkThread(e.a(audioRouteManager));
    }

    @SuppressLint(value={"NewApi"})
    @RequiresApi(api=24)
    private void handleRecordingConfigChanged(List<AudioRecordingConfiguration> configList) {
        if (configList.isEmpty()) {
            return;
        }
        int n2 = Math.min(configList.size(), 10);
        RecordingConfig[] recordingConfigArray = new RecordingConfig[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            recordingConfigArray[i2] = new RecordingConfig();
            AudioRecordingConfiguration audioRecordingConfiguration = configList.get(i2);
            recordingConfigArray[i2].a = audioRecordingConfiguration.getClientAudioSessionId();
            recordingConfigArray[i2].b = LiteavSystemInfo.getSystemOSVersionInt() >= 29 ? audioRecordingConfiguration.isClientSilenced() : false;
        }
        AudioRouteManager.nativeNotifyAudioRecordingConfigChangedFromJava(this.mNativeAudioRouteManager, recordingConfigArray);
    }

    private void notifyAudioIOSceneChangedInternal() {
        if (this.mCurrentAudioIOScene == this.mExpectedAudioIOScene) {
            return;
        }
        Log.i(TAG, "notify audio io scene changed, %s -> %s", new Object[]{this.mCurrentAudioIOScene, this.mExpectedAudioIOScene});
        if (this.mAudioManager.getMode() == 2) {
            AudioRouteManager audioRouteManager = this;
            audioRouteManager.runOnWorkThread(f.a(audioRouteManager), 500L);
            return;
        }
        int n2 = a.a(this.mExpectedAudioIOScene);
        Log.i(TAG, "setMode to ".concat(String.valueOf(n2)), new Object[0]);
        try {
            if (this.mAudioManager.getMode() == n2 && n2 == 3) {
                this.mHasModeConflict = true;
                Log.w(TAG, "set communication mode repeatedly, maybe can't be the mode owner", new Object[0]);
            } else {
                this.mHasModeConflict = false;
            }
            this.mAudioManager.setMode(n2);
        }
        catch (Exception exception) {
            Log.w(TAG, "AudioManager setMode failed, ignore it", new Object[0]);
        }
        this.mCurrentAudioIOScene = this.mExpectedAudioIOScene;
        if (this.mSwitcher != null) {
            this.mSwitcher.a(this.mExpectedAudioIOScene);
            return;
        }
        this.autoCheckRouteUpdate(false);
    }

    private void setHandFreeModeEnabledInternal(boolean enable) {
        boolean bl2;
        if (!this.mIsServiceStarted) {
            Log.w(TAG, "set handfree mode failed, AudioRouteManager is not started", new Object[0]);
            return;
        }
        r r2 = this.mAudioRouteSupervisor;
        if (!r2.c) {
            Log.e("AudioRouteSupervisor", "error in setHandFreeModeEnabled(), it's not been initialized yet", new Object[0]);
            bl2 = false;
        } else {
            b b2 = r2.b.get((Object)b.a.b);
            b b3 = r2.b.get((Object)b.a.c);
            if (b2 == null || b3 == null) {
                Log.e("AudioRouteSupervisor", "setHandFreeModeEnabled failed, speakerphone or earphone not existed", new Object[0]);
                bl2 = false;
            } else {
                int n2 = Math.min(b2.c, b3.c);
                int n3 = Math.max(b2.c, b3.c);
                b2.c = enable ? n3 : n2;
                b3.c = enable ? n2 : n3;
                bl2 = true;
            }
        }
        if (bl2) {
            this.autoCheckRouteUpdate(false);
        }
    }

    private void handleWiredHeadsetChangedInternal(boolean connected) {
        if (!this.mIsServiceStarted) {
            Log.i(TAG, "ignore wired headset changing, AudioRouteManager is not started", new Object[0]);
            return;
        }
        if (this.mAudioRouteSupervisor.a(b.a.d, connected)) {
            this.autoCheckRouteUpdate(false);
        }
    }

    private void handleBluetoothHeadsetChangedInternal(boolean connected) {
        if (!this.mIsServiceStarted) {
            Log.i(TAG, "ignore bluetooth headset changing, AudioRouteManager is not started", new Object[0]);
            return;
        }
        if (this.mAudioRouteSupervisor.a(b.a.e, connected)) {
            this.autoCheckRouteUpdate(false);
        }
    }

    private void handleBluetoothSCOChangedInternal(boolean connected) {
        if (this.mSwitcher != null) {
            this.mSwitcher.a(connected);
        }
        AudioRouteManager audioRouteManager = this;
        audioRouteManager.removeCallbacksOnWorkThread(audioRouteManager.mForceUpdateRouteRunnable);
        if (!connected && this.mIsServiceStarted && this.mCurrentAudioIOScene != a.a) {
            AudioRouteManager audioRouteManager2 = this;
            audioRouteManager2.runOnWorkThread(audioRouteManager2.mForceUpdateRouteRunnable, 1000L);
        }
    }

    private void handleUsbChangedInternal(boolean connected) {
        if (!this.mIsServiceStarted) {
            Log.i(TAG, "ignore usb changing, AudioRouteManager is not started", new Object[0]);
            return;
        }
        if (this.mAudioRouteSupervisor.a(b.a.f, connected)) {
            this.autoCheckRouteUpdate(false);
        }
    }

    private void handleSystemVolumeChangedInternal() {
        int n2 = this.mAudioManager.getMode() == 0 ? 3 : 0;
        int n3 = this.mAudioManager.getStreamVolume(n2);
        if (this.mCurrentSystemVolume != n3) {
            this.mCurrentSystemVolume = n3;
            AudioRouteManager.nativeNotifySystemVolumeChangedFromJava(this.mNativeAudioRouteManager, n3);
        }
    }

    private void updateAudioRouteStatus() {
        boolean bl2;
        UsbManager usbManager;
        t t2;
        if (this.mBroadcastReceiver == null) {
            this.mAudioRouteSupervisor.a(b.a.e, false);
        } else {
            t2 = this.mBroadcastReceiver;
            this.mAudioRouteSupervisor.a(b.a.e, t2.b == null ? false : t2.b.a());
        }
        this.mAudioRouteSupervisor.a(b.a.d, this.mAudioManager.isWiredHeadsetOn());
        this.mAudioRouteSupervisor.a(b.a.b, true);
        this.mAudioRouteSupervisor.a(b.a.c, true);
        t2 = this.mBroadcastReceiver;
        if (t2.c && (usbManager = (UsbManager)t2.a.getSystemService("usb")) != null) {
            Iterator iterator = usbManager.getDeviceList().values().iterator();
            while (iterator.hasNext()) {
                if (!t.a((UsbDevice)iterator.next())) continue;
                bl2 = true;
                break;
            }
        } else {
            bl2 = false;
        }
        this.mAudioRouteSupervisor.a(b.a.f, bl2);
        this.autoCheckRouteUpdate(false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void autoCheckRouteUpdate(boolean force) {
        block12: {
            if (this.mCurrentAudioIOScene == a.a) {
                this.mCurrentRouteType = b.a.a;
                this.destroySwitcher();
                return;
            }
            var3_2 = this.mAudioRouteSupervisor;
            if (var3_2.c) break block12;
            Log.e("AudioRouteSupervisor", "err in getHighestPriorityRoute(), it's not been initialized yet", new Object[0]);
            ** GOTO lbl-1000
        }
        var4_3 = null;
        var5_4 /* !! */  = var3_2.b.entrySet().iterator();
        while (var5_4 /* !! */ .hasNext()) {
            var7_5 = var5_4 /* !! */ .next().getValue();
            if (var7_5 == null || !var7_5.b || var4_3 != null && var7_5.c < var4_3.c) continue;
            var4_3 = var7_5;
        }
        if (var4_3 != null) {
            v0 = var4_3.a;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var2_6 = r.a;
        }
        if (this.mCurrentRouteType != var2_6 || force) {
            this.mCurrentRouteType = var2_6;
            this.destroySwitcher();
            var6_7 = this.mCurrentAudioIOScene;
            var5_4 /* !! */  = this.mHandler;
            var4_3 = this.mAudioManager;
            var3_2 = var2_6;
            switch (s.1.a[var3_2.ordinal()]) {
                case 1: {
                    v1 /* !! */  = new s.c((AudioManager)var4_3, (Handler)var5_4 /* !! */ , var6_7);
                    break;
                }
                case 2: {
                    v1 /* !! */  = new s.e((AudioManager)var4_3, (Handler)var5_4 /* !! */ , var6_7);
                    break;
                }
                case 3: {
                    v1 /* !! */  = new s.f((AudioManager)var4_3, (Handler)var5_4 /* !! */ , var6_7);
                    break;
                }
                case 4: {
                    v1 /* !! */  = new s.b((AudioManager)var4_3, (Handler)var5_4 /* !! */ , var6_7);
                    break;
                }
                case 5: {
                    v1 /* !! */  = new s.d((AudioManager)var4_3, (Handler)var5_4 /* !! */ , var6_7);
                    break;
                }
                default: {
                    v1 /* !! */  = null;
                }
            }
            this.mSwitcher = v1 /* !! */ ;
            this.mSwitcher.a(this.mSwitcherListener);
            this.mSwitcher.a();
        }
    }

    private void destroySwitcher() {
        if (this.mSwitcher == null) {
            return;
        }
        this.mSwitcher.b();
        this.mSwitcher = null;
    }

    private void runOnWorkThread(Runnable runnable) {
        CustomHandler customHandler = this.mHandler;
        if (customHandler != null) {
            customHandler.post(runnable);
        }
    }

    private void runOnWorkThreadAndWaitDone(Runnable runnable, long timeout) {
        CustomHandler customHandler = this.mHandler;
        if (customHandler != null) {
            customHandler.runAndWaitDone(runnable, timeout);
        }
    }

    private void runOnWorkThread(Runnable runnable, long delay) {
        CustomHandler customHandler = this.mHandler;
        if (customHandler != null) {
            customHandler.postDelayed(runnable, delay);
        }
    }

    private void removeCallbacksOnWorkThread(Runnable runnable) {
        CustomHandler customHandler = this.mHandler;
        if (customHandler != null) {
            customHandler.removeCallbacks(runnable);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void registerAudioDeviceCallback() {
        if (LiteavSystemInfo.getSystemOSVersionInt() <= 30) {
            return;
        }
        if (this.mAudioDeviceCallback == null) {
            this.buildAudioDeviceCallback();
        }
        if (this.mAudioDeviceCallback == null) {
            return;
        }
        this.mAudioManager.registerAudioDeviceCallback(this.mAudioDeviceCallback, null);
        Log.i(TAG, "register audio device callback", new Object[0]);
    }

    @SuppressLint(value={"NewApi"})
    private void unregisterAudioDeviceCallback() {
        if (LiteavSystemInfo.getSystemOSVersionInt() <= 30) {
            return;
        }
        if (this.mAudioDeviceCallback == null) {
            return;
        }
        this.mAudioManager.unregisterAudioDeviceCallback(this.mAudioDeviceCallback);
        Log.i(TAG, "unregister audio device callback", new Object[0]);
    }

    @SuppressLint(value={"NewApi"})
    private void buildAudioDeviceCallback() {
        if (this.mAudioDeviceCallback != null) {
            return;
        }
        this.mAudioDeviceCallback = new AudioDeviceCallback(){

            public final void onAudioDevicesAdded(AudioDeviceInfo[] addedDevices) {
                if (addedDevices.length == 0) {
                    return;
                }
                AudioDeviceInfo[] audioDeviceInfoArray = addedDevices;
                int n2 = addedDevices.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    AudioDeviceInfo audioDeviceInfo = audioDeviceInfoArray[i2];
                    Log.i(AudioRouteManager.TAG, "added device type is " + audioDeviceInfo.getType() + " sink: " + audioDeviceInfo.isSink(), new Object[0]);
                    if (audioDeviceInfo.getType() != 8) continue;
                    AudioRouteManager.this.runOnWorkThread(p.a(this));
                }
            }

            public final void onAudioDevicesRemoved(AudioDeviceInfo[] removedDevices) {
                if (removedDevices.length == 0) {
                    return;
                }
                AudioDeviceInfo[] audioDeviceInfoArray = removedDevices;
                int n2 = removedDevices.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    AudioDeviceInfo audioDeviceInfo = audioDeviceInfoArray[i2];
                    Log.i(AudioRouteManager.TAG, "removed device type is " + audioDeviceInfo.getType() + " sink: " + audioDeviceInfo.isSink(), new Object[0]);
                    if (audioDeviceInfo.getType() != 8) continue;
                    AudioRouteManager.this.runOnWorkThread(q.a(this));
                }
            }

            static /* synthetic */ void a(3 var0) {
                var0.AudioRouteManager.this.onBluetoothConnectionChanged(false);
            }

            static /* synthetic */ void b(3 var0) {
                var0.AudioRouteManager.this.onBluetoothConnectionChanged(true);
            }
        };
    }

    private static native void nativeNotifyAudioRouteChangedFromJava(long var0, int var2);

    private static native void nativeNotifyAudioRecordingConfigChangedFromJava(long var0, RecordingConfig[] var2);

    private static native void nativeNotifyBluetoothConnectionFailedFromJava(long var0, boolean var2);

    private static native void nativeNotifySystemVolumeChangedFromJava(long var0, int var2);

    static /* synthetic */ void lambda$onUsbConnectionChanged$8(AudioRouteManager this_, boolean connected) {
        this_.handleUsbChangedInternal(connected);
    }

    static /* synthetic */ void lambda$onBluetoothSCOConnected$7(AudioRouteManager this_, boolean connected) {
        this_.handleBluetoothSCOChangedInternal(connected);
    }

    static /* synthetic */ void lambda$onBluetoothConnectionChanged$6(AudioRouteManager this_, boolean connected) {
        this_.handleBluetoothHeadsetChangedInternal(connected);
    }

    static /* synthetic */ void lambda$onWiredHeadsetConnectionChanged$5(AudioRouteManager this_, boolean connected) {
        this_.handleWiredHeadsetChangedInternal(connected);
    }

    static /* synthetic */ void lambda$setHandFreeModeEnabled$4(AudioRouteManager this_, boolean enable) {
        this_.setHandFreeModeEnabledInternal(enable);
    }

    static /* synthetic */ void lambda$notifyAudioIOSceneChanged$3(AudioRouteManager this_, int newScene) {
        this_.mExpectedAudioIOScene = a.a(newScene);
        this_.notifyAudioIOSceneChangedInternal();
    }

    static /* synthetic */ void lambda$enableUsbDevice$2(AudioRouteManager this_, boolean enable) {
        this_.enableUsbDeviceInternal(enable);
    }

    static /* synthetic */ void lambda$start$1(AudioRouteManager this_, String configString) {
        this_.startInternal(configString);
    }

    static /* synthetic */ void lambda$new$0(AudioRouteManager this_) {
        this_.autoCheckRouteUpdate(true);
    }

    static /* synthetic */ void access$lambda$0(AudioRouteManager audioRouteManager) {
        audioRouteManager.stopInternal();
    }

    static /* synthetic */ void access$lambda$1(AudioRouteManager audioRouteManager) {
        audioRouteManager.handleSystemVolumeChangedInternal();
    }

    static /* synthetic */ void access$lambda$2(AudioRouteManager audioRouteManager) {
        audioRouteManager.notifyAudioIOSceneChangedInternal();
    }

    static class RecordingConfig {
        int a;
        boolean b;

        @CalledByNative(value="RecordingConfig")
        public int getSessionId() {
            return this.a;
        }

        @CalledByNative(value="RecordingConfig")
        public boolean isSilenced() {
            return this.b;
        }
    }
}

