/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.encoder;

import android.os.HandlerThread;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.common.c;
import com.tencent.liteav.videobase.common.d;
import com.tencent.liteav.videobase.frame.FrameMetaData;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.utils.m;
import com.tencent.liteav.videobase.videobase.IVideoReporter;
import com.tencent.liteav.videobase.videobase.h;
import com.tencent.liteav.videobase.videobase.i;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.liteav.videoproducer.encoder.aa;
import com.tencent.liteav.videoproducer.encoder.ab;
import com.tencent.liteav.videoproducer.encoder.ac;
import com.tencent.liteav.videoproducer.encoder.ad;
import com.tencent.liteav.videoproducer.encoder.ae;
import com.tencent.liteav.videoproducer.encoder.af;
import com.tencent.liteav.videoproducer.encoder.ag;
import com.tencent.liteav.videoproducer.encoder.ah;
import com.tencent.liteav.videoproducer.encoder.ai;
import com.tencent.liteav.videoproducer.encoder.aj;
import com.tencent.liteav.videoproducer.encoder.ak;
import com.tencent.liteav.videoproducer.encoder.bq;
import com.tencent.liteav.videoproducer.encoder.z;
import com.tencent.liteav.videoproducer.producer.VideoProducerDef;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::video")
public class SoftwareEncoderWrapper {
    private static final int MAX_CACHE_SIZE = 1;
    private final String mTAG = "SoftwareEncoderWrapper@" + this.hashCode();
    private final IVideoReporter mReporter;
    private final VideoProducerDef.StreamType mStreamType;
    private final m mFrameQueue = new m();
    private CustomHandler mWorkHandler;
    private long mNativeEncodeWrapper = 0L;
    private bq.a mListener;
    private VideoEncodeParams mVideoEncodeParams;

    public SoftwareEncoderWrapper(@NonNull IVideoReporter reporter, VideoProducerDef.StreamType streamType) {
        this.mReporter = reporter;
        this.mStreamType = streamType;
    }

    public synchronized void initialize() {
        if (this.mWorkHandler != null) {
            return;
        }
        HandlerThread handlerThread = new HandlerThread("software-encoder");
        handlerThread.start();
        this.mWorkHandler = new CustomHandler(handlerThread.getLooper());
        this.mWorkHandler.runOrPost(z.a(this));
    }

    public void start(VideoEncodeParams params, bq.a listener) {
        VideoEncodeParams videoEncodeParams = new VideoEncodeParams(params);
        SoftwareEncoderWrapper softwareEncoderWrapper = this;
        softwareEncoderWrapper.runOrPostToWorkThread(ad.a(softwareEncoderWrapper, listener, videoEncodeParams));
    }

    public void encodeFrame(PixelFrame frame) {
        if (frame.getPixelFormatType() != GLConstants.PixelFormatType.a || frame.getPixelBufferType() != GLConstants.PixelBufferType.a) {
            LiteavLog.d(this.mTAG, "pixelFrame pixelFormat not I420 ");
            return;
        }
        this.mFrameQueue.a(frame);
        SoftwareEncoderWrapper softwareEncoderWrapper = this;
        softwareEncoderWrapper.runOrPostToWorkThread(ae.a(softwareEncoderWrapper, frame));
    }

    public boolean isInputQueueFull() {
        return this.mFrameQueue.c() > 0;
    }

    public void setRPSIFrameFPS(int fps) {
        SoftwareEncoderWrapper softwareEncoderWrapper = this;
        softwareEncoderWrapper.runOrPostToWorkThread(af.a(softwareEncoderWrapper, fps));
    }

    public void setRPSNearestREFSize(int referenceSize) {
        SoftwareEncoderWrapper softwareEncoderWrapper = this;
        softwareEncoderWrapper.runOrPostToWorkThread(ag.a(softwareEncoderWrapper, referenceSize));
    }

    public void ackRPSRecvFrameIndex(int ackedFrameId, int bitmap) {
        SoftwareEncoderWrapper softwareEncoderWrapper = this;
        softwareEncoderWrapper.runOrPostToWorkThread(ah.a(softwareEncoderWrapper, ackedFrameId, bitmap));
    }

    public void restartIDRFrame() {
        SoftwareEncoderWrapper softwareEncoderWrapper = this;
        softwareEncoderWrapper.runOrPostToWorkThread(ai.a(softwareEncoderWrapper));
    }

    public void setBitrate(int bitrate) {
        SoftwareEncoderWrapper softwareEncoderWrapper = this;
        softwareEncoderWrapper.runOrPostToWorkThread(aj.a(softwareEncoderWrapper, bitrate));
    }

    public void setFps(int fps) {
        SoftwareEncoderWrapper softwareEncoderWrapper = this;
        softwareEncoderWrapper.runOrPostToWorkThread(ak.a(softwareEncoderWrapper, fps));
    }

    public void signalEndOfStream() {
        LiteavLog.i(this.mTAG, "signalEndOfStream");
        SoftwareEncoderWrapper softwareEncoderWrapper = this;
        softwareEncoderWrapper.runOrPostToWorkThread(aa.a(softwareEncoderWrapper));
    }

    public void stopSync(long maxWaitTimeMs) {
        SoftwareEncoderWrapper softwareEncoderWrapper = this;
        softwareEncoderWrapper.runOrPostToWorkThread(ab.a(softwareEncoderWrapper));
    }

    public synchronized void uninitialize() {
        if (this.mWorkHandler == null) {
            return;
        }
        SoftwareEncoderWrapper softwareEncoderWrapper = this;
        softwareEncoderWrapper.runOrPostToWorkThread(ac.a(softwareEncoderWrapper));
        this.mWorkHandler.quitLooper();
        this.mWorkHandler = null;
    }

    private void runOrPostToWorkThread(Runnable runnable) {
        CustomHandler customHandler = this.mWorkHandler;
        if (customHandler != null) {
            customHandler.runOrPost(runnable);
        }
    }

    @CalledByNative
    private void onEncodedNAL(EncodedVideoFrame nal) {
        if (this.mListener != null) {
            this.mListener.onEncodedNAL(nal, false);
        }
    }

    @CalledByNative
    private void onEncodedFail() {
        if (this.mListener != null) {
            this.mListener.onEncodedFail(h.a.j);
        }
    }

    @CalledByNative
    private void onRpsFrameRateChanged(boolean isRpsIDRMode, int idrFps) {
        if (this.mListener != null) {
            this.mListener.a(isRpsIDRMode, idrFps);
        }
    }

    @CalledByNative
    private static EncodedVideoFrame createEncodedVideoFrameCallFromNative(ByteBuffer buffer, int nalType, int codecType, int profileType, int rotation, long dts, long pts, long nativePtr, int width, int height, long frameIndex, long gopIndex, long refFrameIndex, boolean hasSVCInfo, int svcInfo) {
        EncodedVideoFrame encodedVideoFrame = new EncodedVideoFrame();
        new EncodedVideoFrame().nalType = c.a(nalType);
        encodedVideoFrame.codecType = CodecType.a(codecType);
        encodedVideoFrame.profileType = d.a(profileType);
        encodedVideoFrame.data = buffer;
        encodedVideoFrame.dts = dts;
        encodedVideoFrame.pts = pts;
        encodedVideoFrame.rotation = rotation;
        encodedVideoFrame.frameIndex = frameIndex;
        encodedVideoFrame.gopFrameIndex = 0L;
        encodedVideoFrame.gopIndex = gopIndex;
        encodedVideoFrame.refFrameIndex = refFrameIndex;
        encodedVideoFrame.nativePtr = nativePtr;
        encodedVideoFrame.width = width;
        encodedVideoFrame.height = height;
        encodedVideoFrame.svcInfo = hasSVCInfo ? Integer.valueOf(svcInfo) : null;
        return encodedVideoFrame;
    }

    private EncodedVideoFrame createBlackFrameIDRNalu(PixelFrame frame) {
        EncodedVideoFrame encodedVideoFrame = new EncodedVideoFrame();
        new EncodedVideoFrame().nalType = c.b;
        encodedVideoFrame.codecType = CodecType.b;
        encodedVideoFrame.profileType = d.b;
        encodedVideoFrame.data = SoftwareEncoderWrapper.nativeCreateBlackFrameIDRBuffer();
        encodedVideoFrame.dts = frame.getTimestamp();
        encodedVideoFrame.pts = frame.getTimestamp();
        encodedVideoFrame.gopFrameIndex = 0L;
        encodedVideoFrame.gopIndex = this.mVideoEncodeParams.baseGopIndex++;
        encodedVideoFrame.frameIndex = 0L;
        encodedVideoFrame.refFrameIndex = 0L;
        encodedVideoFrame.width = frame.getWidth();
        encodedVideoFrame.height = frame.getHeight();
        return encodedVideoFrame;
    }

    @CalledByNative
    private static ByteBuffer createByteBuffer(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    public static native boolean nativeIsSoftwareHevcEncoderSupport();

    private static native ByteBuffer nativeCreateBlackFrameIDRBuffer();

    private static native long nativeCreate(SoftwareEncoderWrapper var0);

    private static native void nativeDestroy(long var0);

    private static native int nativeStart(long var0, VideoEncodeParams var2);

    private static native int nativeStop(long var0);

    private static native int nativeEncodeFrame(long var0, ByteBuffer var2, int var3, int var4, long var5);

    private static native void nativeSetBitrate(long var0, int var2);

    private static native void nativeSetFps(long var0, int var2);

    private static native void nativeSetRpsIdrFps(long var0, int var2);

    private static native int nativeSetRPSRefBitmap(long var0, int var2, int var3);

    private static native int nativeSetNearestRPS(long var0, int var2);

    private static native void nativeRestartIDR(long var0);

    static /* synthetic */ void lambda$uninitialize$11(SoftwareEncoderWrapper this_) {
        if (this_.mNativeEncodeWrapper != 0L) {
            SoftwareEncoderWrapper.nativeDestroy(this_.mNativeEncodeWrapper);
            this_.mNativeEncodeWrapper = 0L;
        }
        LiteavLog.i(this_.mTAG, "destroy encode wrapper");
    }

    static /* synthetic */ void lambda$stopSync$10(SoftwareEncoderWrapper this_) {
        if (this_.mNativeEncodeWrapper != 0L) {
            SoftwareEncoderWrapper.nativeStop(this_.mNativeEncodeWrapper);
        }
        this_.mListener = null;
        LiteavLog.i(this_.mTAG, "stop encoder");
    }

    static /* synthetic */ void lambda$signalEndOfStream$9(SoftwareEncoderWrapper this_) {
        if (this_.mListener != null) {
            this_.mListener.onEncodedNAL(new EncodedVideoFrame(), true);
        }
    }

    static /* synthetic */ void lambda$setFps$8(SoftwareEncoderWrapper this_, int fps) {
        if (this_.mNativeEncodeWrapper != 0L) {
            SoftwareEncoderWrapper.nativeSetFps(this_.mNativeEncodeWrapper, fps);
        }
    }

    static /* synthetic */ void lambda$setBitrate$7(SoftwareEncoderWrapper this_, int bitrate) {
        if (this_.mNativeEncodeWrapper != 0L) {
            SoftwareEncoderWrapper.nativeSetBitrate(this_.mNativeEncodeWrapper, bitrate);
        }
    }

    static /* synthetic */ void lambda$restartIDRFrame$6(SoftwareEncoderWrapper this_) {
        if (this_.mNativeEncodeWrapper != 0L) {
            SoftwareEncoderWrapper.nativeRestartIDR(this_.mNativeEncodeWrapper);
        }
    }

    static /* synthetic */ void lambda$ackRPSRecvFrameIndex$5(SoftwareEncoderWrapper this_, int ackedFrameId, int bitmap) {
        if (this_.mNativeEncodeWrapper != 0L) {
            SoftwareEncoderWrapper.nativeSetRPSRefBitmap(this_.mNativeEncodeWrapper, ackedFrameId, bitmap);
        }
    }

    static /* synthetic */ void lambda$setRPSNearestREFSize$4(SoftwareEncoderWrapper this_, int referenceSize) {
        if (this_.mNativeEncodeWrapper != 0L) {
            SoftwareEncoderWrapper.nativeSetNearestRPS(this_.mNativeEncodeWrapper, referenceSize);
        }
    }

    static /* synthetic */ void lambda$setRPSIFrameFPS$3(SoftwareEncoderWrapper this_, int fps) {
        if (this_.mNativeEncodeWrapper != 0L) {
            SoftwareEncoderWrapper.nativeSetRpsIdrFps(this_.mNativeEncodeWrapper, fps);
        }
    }

    static /* synthetic */ void lambda$encodeFrame$2(SoftwareEncoderWrapper this_, PixelFrame frame) {
        long l2 = SystemClock.elapsedRealtime();
        PixelFrame pixelFrame = this_.mFrameQueue.a();
        if (pixelFrame == null) {
            return;
        }
        FrameMetaData frameMetaData = pixelFrame.getMetaData();
        if (frameMetaData != null && frameMetaData.isBlackFrame()) {
            SoftwareEncoderWrapper softwareEncoderWrapper = this_;
            softwareEncoderWrapper.onEncodedNAL(softwareEncoderWrapper.createBlackFrameIDRNalu(frame));
        } else if (this_.mNativeEncodeWrapper != 0L) {
            SoftwareEncoderWrapper.nativeEncodeFrame(this_.mNativeEncodeWrapper, pixelFrame.getBuffer(), pixelFrame.getWidth(), pixelFrame.getHeight(), pixelFrame.getTimestamp());
        }
        pixelFrame.release();
        int n2 = (int)(SystemClock.elapsedRealtime() - l2);
        this_.mReporter.updateStatus(i.A, this_.mStreamType.mValue, n2);
    }

    static /* synthetic */ void lambda$start$1(SoftwareEncoderWrapper this_, bq.a listener, VideoEncodeParams finalParams) {
        this_.mListener = listener;
        this_.mVideoEncodeParams = finalParams;
        if (this_.mNativeEncodeWrapper != 0L) {
            SoftwareEncoderWrapper.nativeStart(this_.mNativeEncodeWrapper, finalParams);
        }
        LiteavLog.i(this_.mTAG, "start encoder");
    }

    static /* synthetic */ void lambda$initialize$0(SoftwareEncoderWrapper this_) {
        this_.mNativeEncodeWrapper = SoftwareEncoderWrapper.nativeCreate(this_);
        LiteavLog.i(this_.mTAG, "initialize " + this_.mNativeEncodeWrapper);
    }
}

