/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.video;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import androidx.annotation.Nullable;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;

public class ScreenCaptureService
extends Service {
    private static final String TAG = "ScreenCaptureService";
    private static final int NOTIFICATION_ID = 13957237;
    private static final String CHANNEL_ID = "notification_id";

    @Nullable
    public IBinder onBind(Intent intent) {
        LiteavLog.i(TAG, "Service on bind");
        try {
            this.startForeground(13957237, this.createNotification());
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "start foreground failed.", throwable);
        }
        return new Binder();
    }

    public boolean onUnbind(Intent intent) {
        LiteavLog.i(TAG, "Service on unbind");
        this.stopForeground(true);
        return super.onUnbind(intent);
    }

    @SuppressLint(value={"NewApi"})
    private Notification createNotification() {
        NotificationManager notificationManager;
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 26) {
            notificationManager = (NotificationManager)this.getSystemService("notification");
            NotificationChannel notificationChannel = new NotificationChannel(CHANNEL_ID, (CharSequence)"notification_name", 2);
            notificationManager.createNotificationChannel(notificationChannel);
        }
        notificationManager = new Notification.Builder((Context)this).setDefaults(1);
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 26) {
            notificationManager.setChannelId(CHANNEL_ID);
        }
        return notificationManager.build();
    }
}

