/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.core.downloadproxy.api;

import android.content.Context;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPDLProxyNativeLibLoader;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPOfflineVinfoAdapter;
import com.tencent.thumbplayer.core.downloadproxy.api.ITPProxyAdapter;
import com.tencent.thumbplayer.core.downloadproxy.api.TPDownloadProxyFactory;
import com.tencent.thumbplayer.core.downloadproxy.jni.TPDownloadProxyNative;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLProxyLog;
import com.tencent.thumbplayer.core.downloadproxy.utils.TPDLProxyUtils;

public class TPDownloadProxyHelper {
    private static final String FILE_NAME = "TPDownloadProxyHelper";
    private static Context applicationContext;
    private static ITPOfflineVinfoAdapter offlineVinfoAdapter;

    public static void setContext(Context context) {
        applicationContext = context;
    }

    public static Context getContext() {
        return applicationContext;
    }

    public static void setUseService(boolean useService) {
        TPDownloadProxyFactory.setUseService(useService);
    }

    public static void setNativeLibLoader(ITPDLProxyNativeLibLoader libLoader) {
        TPDownloadProxyNative.getInstance().setLibLoader(libLoader);
    }

    public static String getNativeLibVersion() {
        return TPDownloadProxyFactory.getNativeVersion();
    }

    public static boolean isReadyForPlay() {
        return TPDownloadProxyFactory.isReadyForPlay();
    }

    public static void setTPOfflineVinfoAdapter(ITPOfflineVinfoAdapter adapter) {
        offlineVinfoAdapter = adapter;
    }

    public static String checkVideoStatus(String vid, String format) {
        if (!TPDownloadProxyFactory.canUseService()) {
            return "";
        }
        if (offlineVinfoAdapter != null) {
            return offlineVinfoAdapter.checkVideoStatus(vid, format);
        }
        return "";
    }

    public static int getRecordDuration(String vid, String format) {
        if (offlineVinfoAdapter != null) {
            return offlineVinfoAdapter.getRecordDuration(vid, format);
        }
        return -1;
    }

    public static void setTPProxyAdapter(ITPProxyAdapter adapter) {
    }

    public static String getHLSOfflineExttag(String vid, String linkVid, int formatid, long encryRandomNum) {
        try {
            if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
                return TPDLProxyUtils.byteArrayToString(TPDownloadProxyNative.getInstance().getHLSOfflineExttag(vid, linkVid, formatid, encryRandomNum));
            }
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "get exttag failed, error:" + throwable.toString());
        }
        return "";
    }

    public static long verifyOfflineCacheSync(String diskPath, int fileFormat, String resourceId, String keyId) {
        try {
            if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
                return TPDownloadProxyNative.getInstance().verifyOfflineCacheSync(diskPath, fileFormat, resourceId, keyId);
            }
        }
        catch (Throwable throwable) {
            TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "verify offline cache failed, error:" + throwable.toString());
        }
        return -1L;
    }

    public static void setUserData(String key, Object value) {
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                TPDownloadProxyNative.getInstance().setUserData(key, value.toString());
                return;
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "setUserData failed, error:" + throwable.toString());
            }
        }
    }

    public static String getNativeInfo(int key) {
        if (TPDownloadProxyNative.getInstance().isNativeLoaded()) {
            try {
                return TPDLProxyUtils.byteArrayToString(TPDownloadProxyNative.getInstance().getNativeInfo(key));
            }
            catch (Throwable throwable) {
                TPDLProxyLog.e(FILE_NAME, 0, "tpdlnative", "getNativeInfo failed, error:" + throwable.toString());
            }
        }
        return null;
    }

    static {
        offlineVinfoAdapter = null;
    }
}

