/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.common;

import android.media.MediaFormat;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Rotation;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import com.tencent.ugc.common.UGCConstants;
import java.util.List;

public class UGCTranscodeVideoEncodeParamsDecider {
    private static final String TAG = "UGCTranscodeVideoEncodeParamsDecider";
    private List<MediaFormat> mVideoMediaFormatList;
    private final Size mExpectSize = new Size(1080, 1920);
    private UGCConstants.SourceType mSourceType = UGCConstants.SourceType.VIDEO;
    private boolean mFullIFrame = false;
    private int mVideoCompress = 4;
    private int mEncodeBitrate = 0;
    private VideoEncoderDef.EncoderProfile mEncodeProfile = VideoEncoderDef.EncoderProfile.c;
    private Rotation mEncodeRotation = Rotation.a;

    public void setInputVideoMediaFormat(List<MediaFormat> videoMediaFormat) {
        this.mVideoMediaFormatList = videoMediaFormat;
    }

    public void setOutputResolution(int resolution) {
        if (resolution == this.mVideoCompress) {
            return;
        }
        this.mVideoCompress = resolution;
        switch (this.mVideoCompress) {
            case 0: {
                this.mExpectSize.width = 360;
                this.mExpectSize.height = 640;
                break;
            }
            case 1: {
                this.mExpectSize.width = 480;
                this.mExpectSize.height = 640;
                break;
            }
            case 2: {
                this.mExpectSize.width = 540;
                this.mExpectSize.height = 960;
                break;
            }
            case 3: {
                this.mExpectSize.width = 720;
                this.mExpectSize.height = 1280;
                break;
            }
            case 4: {
                this.mExpectSize.width = 1080;
                this.mExpectSize.height = 1920;
            }
        }
        LiteavLog.i(TAG, "setVideoCompress " + resolution + ", expectSize = " + this.mExpectSize);
    }

    public void setEncodeBitrate(int bitrate) {
        if (this.mEncodeBitrate == bitrate) {
            return;
        }
        LiteavLog.i(TAG, "setVideoBitrate ".concat(String.valueOf(bitrate)));
        this.mEncodeBitrate = bitrate;
    }

    public void setEncodeProfile(int profile) {
        LiteavLog.i(TAG, "setEncodeProfile ".concat(String.valueOf(profile)));
        if (profile == 2) {
            this.mEncodeProfile = VideoEncoderDef.EncoderProfile.b;
            return;
        }
        if (profile == 1) {
            this.mEncodeProfile = VideoEncoderDef.EncoderProfile.a;
            return;
        }
        this.mEncodeProfile = VideoEncoderDef.EncoderProfile.c;
    }

    public void setFullIFrame(boolean isFullIFrame) {
        if (isFullIFrame == this.mFullIFrame) {
            return;
        }
        LiteavLog.i(TAG, "setFullIFrame ".concat(String.valueOf(isFullIFrame)));
        this.mFullIFrame = isFullIFrame;
    }

    public void setSourceType(UGCConstants.SourceType sourceType) {
        if (this.mSourceType == sourceType) {
            return;
        }
        LiteavLog.i(TAG, "setSourceType ".concat(String.valueOf((Object)sourceType)));
        this.mSourceType = sourceType;
    }

    public void setEncodeRotation(Rotation rotation) {
        if (this.mEncodeRotation == rotation) {
            return;
        }
        LiteavLog.i(TAG, "setRenderRotation ".concat(String.valueOf((Object)rotation)));
        this.mEncodeRotation = rotation;
    }

    public VideoEncodeParams getDecidedEncodeParams() {
        VideoEncodeParams videoEncodeParams = new VideoEncodeParams();
        new VideoEncodeParams().annexb = true;
        videoEncodeParams.bitrateMode = VideoEncoderDef.BitrateMode.b;
        videoEncodeParams.fullIFrame = false;
        videoEncodeParams.isTranscodingMode = true;
        videoEncodeParams.encoderProfile = this.mEncodeProfile;
        Size size = this.getDecidedOutputSize();
        videoEncodeParams.width = size.width;
        videoEncodeParams.height = size.height;
        videoEncodeParams.setFullIFrame(this.mFullIFrame);
        videoEncodeParams.gop = this.getDecidedGOP();
        videoEncodeParams.fps = this.getDecidedVideoFPS();
        videoEncodeParams.bitrate = this.getDecidedVideoBitrate(size);
        LiteavLog.i(TAG, "getVideoEncodeParams: ".concat(String.valueOf(videoEncodeParams)));
        return videoEncodeParams;
    }

    private Size getDecidedOutputSize() {
        Size size = new Size(0, 0);
        if (this.mVideoMediaFormatList != null && this.mVideoMediaFormatList.size() != 0) {
            if (this.mVideoMediaFormatList.size() > 1) {
                UGCTranscodeVideoEncodeParamsDecider uGCTranscodeVideoEncodeParamsDecider = this;
                size = uGCTranscodeVideoEncodeParamsDecider.getOutputSizeForMultipleSource(uGCTranscodeVideoEncodeParamsDecider.mVideoMediaFormatList);
            } else {
                UGCTranscodeVideoEncodeParamsDecider uGCTranscodeVideoEncodeParamsDecider = this;
                size = uGCTranscodeVideoEncodeParamsDecider.getOutputSizeForSingleSource(uGCTranscodeVideoEncodeParamsDecider.mVideoMediaFormatList.get(0));
            }
        } else if (this.mExpectSize != null) {
            size = new Size(this.mExpectSize);
        }
        if (this.mEncodeRotation == Rotation.b || this.mEncodeRotation == Rotation.d) {
            size.swap();
        }
        size.width = (size.width + 1) / 2 * 2;
        size.height = (size.height + 1) / 2 * 2;
        return size;
    }

    private Size getOutputSizeForSingleSource(MediaFormat mediaFormat) {
        if (mediaFormat == null) {
            return new Size(0, 0);
        }
        Size size = this.getSizeFromMediaFormat(mediaFormat);
        if (size.width == 0 || size.height == 0) {
            LiteavLog.i(TAG, "calculateGenerateSize origin: ".concat(String.valueOf(size)));
            return size;
        }
        Size size2 = this.mSourceType == UGCConstants.SourceType.VIDEO ? this.adjustVideoOutSize(size, this.mExpectSize) : this.adjustPictureOutSize(size, this.mExpectSize);
        return size2;
    }

    private Size getOutputSizeForMultipleSource(List<MediaFormat> mediaFormatList) {
        boolean bl2 = true;
        for (MediaFormat mediaFormat : mediaFormatList) {
            Size size = this.getSizeFromMediaFormat(mediaFormat);
            if (size.height <= size.width) continue;
            bl2 = false;
            break;
        }
        Size size = new Size(this.mExpectSize);
        if (bl2) {
            size.swap();
        }
        return size;
    }

    private int getDecidedVideoBitrate(Size outSize) {
        if (this.mFullIFrame) {
            if (outSize.width < 1280 && outSize.height < 1280) {
                return 24000;
            }
            return 15000;
        }
        if (this.mEncodeBitrate != 0) {
            return this.mEncodeBitrate;
        }
        int n2 = 5000;
        switch (this.mVideoCompress) {
            case 0: 
            case 1: {
                n2 = 2400;
                break;
            }
            case 2: {
                n2 = 6500;
                break;
            }
            case 3: {
                n2 = 9600;
                break;
            }
            case 4: {
                n2 = 12000;
            }
        }
        return n2;
    }

    private int getDecidedVideoFPS() {
        int n2 = 30;
        if (this.mVideoMediaFormatList == null) {
            return 30;
        }
        if (this.mVideoMediaFormatList.size() == 1) {
            UGCTranscodeVideoEncodeParamsDecider uGCTranscodeVideoEncodeParamsDecider = this;
            n2 = uGCTranscodeVideoEncodeParamsDecider.getNumberFromMediaFormat(uGCTranscodeVideoEncodeParamsDecider.mVideoMediaFormatList.get(0), "frame-rate", 30);
        }
        return n2;
    }

    private int getDecidedGOP() {
        if (this.mVideoMediaFormatList == null || this.mVideoMediaFormatList.size() == 0) {
            return 3;
        }
        MediaFormat mediaFormat = this.mVideoMediaFormatList.get(0);
        return this.getNumberFromMediaFormat(mediaFormat, "i-frame-interval", 3);
    }

    private Size adjustPictureOutSize(Size origin, Size expectSize) {
        int n2;
        int n3;
        if ((double)((float)origin.aspectRatio()) >= expectSize.aspectRatio()) {
            n3 = expectSize.width;
            n2 = (int)((double)n3 / origin.aspectRatio());
        } else {
            n3 = (int)((double)expectSize.height * origin.aspectRatio());
            n2 = expectSize.height;
        }
        Size size = new Size();
        new Size().width = (n3 + 1) / 2 * 2;
        size.height = (n2 + 1) / 2 * 2;
        LiteavLog.i(TAG, "origin= " + origin + ", expectSize= " + expectSize + ", outSize= " + size);
        return size;
    }

    private Size adjustVideoOutSize(Size originSize, Size expectOutSize) {
        if (originSize.width <= expectOutSize.width && originSize.height <= expectOutSize.height || originSize.width <= expectOutSize.height && originSize.height <= expectOutSize.width) {
            return new Size(originSize);
        }
        double d2 = originSize.aspectRatio();
        int n2 = originSize.width >= originSize.height ? Math.min((int)((double)expectOutSize.width * d2), expectOutSize.height) : Math.min((int)((double)expectOutSize.height * d2), expectOutSize.width);
        int n3 = (int)((double)n2 / d2);
        n2 = (n2 + 1) / 2 * 2;
        n3 = (n3 + 1) / 2 * 2;
        Size size = new Size();
        new Size().width = n2;
        size.height = n3;
        LiteavLog.i(TAG, "adjustOutSize origin: " + originSize + ", expectSize: " + expectOutSize + ", outSize: " + size);
        return size;
    }

    private Size getSizeFromMediaFormat(MediaFormat mediaFormat) {
        Size size = new Size();
        new Size().width = mediaFormat.getInteger("width");
        size.height = mediaFormat.getInteger("height");
        int n2 = 0;
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 23) {
            try {
                n2 = mediaFormat.getInteger("rotation-degrees");
            }
            catch (Exception exception) {
                LiteavLog.i(TAG, "get KEY_ROTATION fail, ".concat(String.valueOf(exception)));
            }
        }
        if (n2 == 90 || n2 == 270) {
            size.swap();
        }
        return size;
    }

    private int getNumberFromMediaFormat(MediaFormat mediaFormat, String key, int defaultValue) {
        int n2 = defaultValue;
        if (!mediaFormat.containsKey(key)) {
            return defaultValue;
        }
        try {
            n2 = mediaFormat.getInteger(key);
        }
        catch (ClassCastException classCastException) {
            LiteavLog.w(TAG, "getNumberFromMediaFormat integer ClassCastException: ".concat(String.valueOf(classCastException)));
            try {
                n2 = (int)mediaFormat.getFloat(key);
            }
            catch (ClassCastException classCastException2) {
                LiteavLog.w(TAG, "getNumberFromMediaFormat float ClassCastException: ".concat(String.valueOf(classCastException2)));
            }
        }
        return n2;
    }
}

