/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.module.ping;

import android.os.RemoteException;
import android.text.TextUtils;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.engine.RTCEngineImpl;
import cn.rongcloud.rtc.module.ping.IHeartBeatProcess;
import cn.rongcloud.rtc.module.ping.RTCPingManager;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.imlib.IMLibRTCClient;
import io.rong.imlib.IRTCHeartbeatListener;
import io.rong.imlib.IRongCoreEnum;
import io.rong.imlib.IRongCoreListener;
import io.rong.imlib.RongCoreClient;

class CounterHeartBeat
implements IHeartBeatProcess {
    RTCPingManager mPingManager;
    private static final String TAG = "CounterHeartBeat";
    volatile boolean isReleased = false;

    @Override
    public void release() {
        this.isReleased = true;
    }

    public CounterHeartBeat(RTCPingManager pingManager) {
        this.mPingManager = pingManager;
        IMLibRTCClient.getInstance().SetRTCHeartbeatListener(new IRTCHeartbeatListener.Stub(){

            public void OnRTCHeartbeat(int code, String roomId) throws RemoteException {
                if (CounterHeartBeat.this.isReleased) {
                    return;
                }
                if (code == 0) {
                    int pingErrorCode = CounterHeartBeat.this.mPingManager.getPINGErrorCode(roomId);
                    int pingFailedCount = CounterHeartBeat.this.mPingManager.getPingFailedCount(roomId);
                    if (pingErrorCode != 0) {
                        FinLog.e(CounterHeartBeat.TAG, "sendRTCPing.Success :  mPingErrorCode : " + pingErrorCode + " , roomId :" + roomId + " , MainRoomId :" + CounterHeartBeat.this.mPingManager.mMainRoomId);
                    } else {
                        FinLog.v(CounterHeartBeat.TAG, "sendRTCPing.Success : " + roomId + " , MainRoomId :" + CounterHeartBeat.this.mPingManager.mMainRoomId);
                    }
                    CounterHeartBeat.this.mPingManager.clearHearbeatInfo(roomId);
                    if (!(pingFailedCount < CounterHeartBeat.this.mPingManager.maxFailureNumber || TextUtils.equals((CharSequence)roomId, (CharSequence)CounterHeartBeat.this.mPingManager.mMainRoomId) || pingErrorCode != IRongCoreEnum.CoreErrorCode.RC_NET_CHANNEL_INVALID.getValue() && pingErrorCode != IRongCoreEnum.CoreErrorCode.RC_MSG_RESP_TIMEOUT.getValue())) {
                        CounterHeartBeat.this.mPingManager.otherRoomConnectedError(roomId, pingErrorCode);
                        return;
                    }
                    if (TextUtils.equals((CharSequence)roomId, (CharSequence)CounterHeartBeat.this.mPingManager.mMainRoomId) && (pingErrorCode == IRongCoreEnum.CoreErrorCode.RC_NET_CHANNEL_INVALID.getValue() || pingErrorCode == IRongCoreEnum.CoreErrorCode.RC_MSG_RESP_TIMEOUT.getValue())) {
                        RTCEngineImpl.getInstance().sendMessage(8000, new Object[0]);
                    }
                } else {
                    RTCErrorCode errorCode = RTCErrorCode.valueOf(code);
                    int pingErrorCode = errorCode.getValue();
                    CounterHeartBeat.this.mPingManager.updateHeartbeatInfo(roomId, pingErrorCode);
                    int pingFailedCount = CounterHeartBeat.this.mPingManager.getPingFailedCount(roomId);
                    FinLog.e(CounterHeartBeat.TAG, "sendRTCPing() error =  " + pingErrorCode + " , pingFailedCount :" + pingFailedCount + " , netWorkAvailable = " + CounterHeartBeat.this.mPingManager.isNetWorkAvailable() + " ,IM connectionStatus = " + RongCoreClient.getInstance().getCurrentConnectionStatus() + " , roomID :" + roomId + " , EnableAutoReconnect :" + CounterHeartBeat.this.mPingManager.mEnableAutoReconnect + " , MainRoomId \uff1a" + CounterHeartBeat.this.mPingManager.mMainRoomId);
                    if (pingFailedCount >= CounterHeartBeat.this.mPingManager.maxFailureNumber && !TextUtils.equals((CharSequence)roomId, (CharSequence)CounterHeartBeat.this.mPingManager.mMainRoomId)) {
                        CounterHeartBeat.this.mPingManager.otherRoomConnectedError(roomId, pingErrorCode);
                        return;
                    }
                    if (TextUtils.equals((CharSequence)roomId, (CharSequence)CounterHeartBeat.this.mPingManager.mMainRoomId)) {
                        if (CounterHeartBeat.this.mPingManager.mEnableAutoReconnect) {
                            if (RongCoreClient.getInstance().getCurrentConnectionStatus() == IRongCoreListener.ConnectionStatusListener.ConnectionStatus.CONNECTED && (errorCode.getValue() == 40001 || errorCode.getValue() == RTCErrorCode.RongRTCCodeNoMatchedRoom.getValue())) {
                                CounterHeartBeat.this.mPingManager.clearHearbeatInfo(roomId);
                                RTCEngineImpl.getInstance().sendMessage(8101, new Object[0]);
                            }
                        } else {
                            if (pingFailedCount >= CounterHeartBeat.this.mPingManager.maxForceConnectNumber && RongCoreClient.getInstance().getCurrentConnectionStatus() != IRongCoreListener.ConnectionStatusListener.ConnectionStatus.CONNECTED) {
                                CounterHeartBeat.this.mPingManager.forceConnect();
                            }
                            if (pingFailedCount >= CounterHeartBeat.this.mPingManager.maxFailureNumber) {
                                CounterHeartBeat.this.mPingManager.clearHearbeatInfo(roomId);
                                FinLog.e(CounterHeartBeat.TAG, "The number of heartbeats has arrived.");
                                CounterHeartBeat.this.mPingManager.stopPing();
                                ReportUtil.libError(ReportUtil.TAG.PINGFAILED4TIMESLEAVEROOM, "roomId", CounterHeartBeat.this.mPingManager.mMainRoomId);
                                RTCEngineImpl.getInstance().sendMessage(9001, new Object[0]);
                            }
                        }
                    }
                }
            }
        });
    }
}

