/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.core;

import cn.rongcloud.rtc.core.CalledByNative;
import cn.rongcloud.rtc.core.PreVideoEncodeSink;
import cn.rongcloud.rtc.core.VideoFrame;
import cn.rongcloud.rtc.core.VideoSource;
import java.nio.ByteBuffer;

class NativeAndroidVideoTrackSource {
    private final long nativeAndroidVideoTrackSource;
    private RotatedBufferListener mRotatedBufferListener;

    public NativeAndroidVideoTrackSource(long nativeAndroidVideoTrackSource) {
        this.nativeAndroidVideoTrackSource = nativeAndroidVideoTrackSource;
    }

    public void setRotatedBufferListener(RotatedBufferListener listener) {
        this.mRotatedBufferListener = listener;
    }

    public void setState(boolean isLive) {
        NativeAndroidVideoTrackSource.nativeSetState(this.nativeAndroidVideoTrackSource, isLive);
    }

    public FrameAdaptationParameters adaptFrame(VideoFrame frame) {
        return NativeAndroidVideoTrackSource.nativeAdaptFrame(this.nativeAndroidVideoTrackSource, frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation(), frame.getTimestampNs());
    }

    public void onFrameCaptured(VideoFrame frame) {
        this.nativeOnFrameCaptured(this.nativeAndroidVideoTrackSource, frame.getRotation(), frame.getMirror(), frame.getTimestampNs(), frame.getBuffer());
    }

    public void adaptOutputFormat(VideoSource.AspectRatio targetLandscapeAspectRatio, Integer maxLandscapePixelCount, VideoSource.AspectRatio targetPortraitAspectRatio, Integer maxPortraitPixelCount, Integer maxFps) {
        NativeAndroidVideoTrackSource.nativeAdaptOutputFormat(this.nativeAndroidVideoTrackSource, targetLandscapeAspectRatio.width, targetLandscapeAspectRatio.height, maxLandscapePixelCount, targetPortraitAspectRatio.width, targetPortraitAspectRatio.height, maxPortraitPixelCount, maxFps);
    }

    public void adaptExactOutputFormat(VideoSource.AspectRatio targetLandscapeAspectRatio, Integer maxLandscapePixelCount, VideoSource.AspectRatio targetPortraitAspectRatio, Integer maxPortraitPixelCount, Integer maxFps) {
        NativeAndroidVideoTrackSource.nativeAdaptExactOutputFormat(this.nativeAndroidVideoTrackSource, targetLandscapeAspectRatio.width, targetLandscapeAspectRatio.height, maxLandscapePixelCount, targetPortraitAspectRatio.width, targetPortraitAspectRatio.height, maxPortraitPixelCount, maxFps);
    }

    public void setPreEncodeSink(long nativeSink) {
        NativeAndroidVideoTrackSource.nativeSetPreEncodeSink(this.nativeAndroidVideoTrackSource, nativeSink);
    }

    public void removePreEncodeSink(long nativeSink) {
        NativeAndroidVideoTrackSource.nativeRemovePreEncodeSink(this.nativeAndroidVideoTrackSource, nativeSink);
    }

    public long wrapPreEncodeSink(PreVideoEncodeSink sink) {
        return NativeAndroidVideoTrackSource.nativeWrapPreEncodeSink(sink);
    }

    public void freePreEncodeSink(long nativeSink) {
        NativeAndroidVideoTrackSource.nativeFreePreEncodeSink(nativeSink);
    }

    @CalledByNative
    public void onBufferRotated(ByteBuffer y, ByteBuffer u, ByteBuffer v, int rotation) {
        RotatedBufferListener listener = this.mRotatedBufferListener;
        if (listener != null) {
            listener.onBufferRotated(y, u, v, rotation);
        }
    }

    private static native void nativeSetState(long var0, boolean var2);

    private static native void nativeAdaptOutputFormat(long var0, int var2, int var3, Integer var4, int var5, int var6, Integer var7, Integer var8);

    private static native void nativeAdaptExactOutputFormat(long var0, int var2, int var3, Integer var4, int var5, int var6, Integer var7, Integer var8);

    private static native FrameAdaptationParameters nativeAdaptFrame(long var0, int var2, int var3, int var4, long var5);

    private native void nativeOnFrameCaptured(long var1, int var3, boolean var4, long var5, VideoFrame.Buffer var7);

    private static native void nativeSetPreEncodeSink(long var0, long var2);

    private static native void nativeRemovePreEncodeSink(long var0, long var2);

    private static native long nativeWrapPreEncodeSink(PreVideoEncodeSink var0);

    private static native void nativeFreePreEncodeSink(long var0);

    public static interface RotatedBufferListener {
        public void onBufferRotated(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3, int var4);
    }

    public static class FrameAdaptationParameters {
        public final int cropX;
        public final int cropY;
        public final int cropWidth;
        public final int cropHeight;
        public final int scaleWidth;
        public final int scaleHeight;
        public final long timestampNs;

        @CalledByNative(value="FrameAdaptationParameters")
        FrameAdaptationParameters(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight, long timestampNs) {
            this.cropX = cropX;
            this.cropY = cropY;
            this.cropWidth = cropWidth;
            this.cropHeight = cropHeight;
            this.scaleWidth = scaleWidth;
            this.scaleHeight = scaleHeight;
            this.timestampNs = timestampNs;
        }
    }
}

