/*
 * Decompiled with CFR 0.152.
 */
package com.daasuu.mp4compose.composer;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.opengl.EGLContext;
import android.util.Size;
import androidx.annotation.NonNull;
import com.daasuu.mp4compose.FillMode;
import com.daasuu.mp4compose.FillModeCustomItem;
import com.daasuu.mp4compose.Rotation;
import com.daasuu.mp4compose.SampleType;
import com.daasuu.mp4compose.composer.DecoderSurface;
import com.daasuu.mp4compose.composer.EncoderSurface;
import com.daasuu.mp4compose.composer.MuxRender;
import com.daasuu.mp4compose.filter.GlFilter;
import com.daasuu.mp4compose.logger.Logger;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

class VideoComposer {
    private static final String TAG = "VideoComposer";
    private static final int DRAIN_STATE_NONE = 0;
    private static final int DRAIN_STATE_SHOULD_RETRY_IMMEDIATELY = 1;
    private static final int DRAIN_STATE_CONSUMED = 2;
    private final MediaExtractor mediaExtractor;
    private final int trackIndex;
    private final MediaFormat outputFormat;
    private final MuxRender muxRender;
    private final MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
    private MediaCodec decoder;
    private MediaCodec encoder;
    private MediaFormat actualOutputFormat;
    private DecoderSurface decoderSurface;
    private EncoderSurface encoderSurface;
    private boolean isExtractorEOS;
    private boolean isDecoderEOS;
    private boolean isEncoderEOS;
    private boolean decoderStarted;
    private boolean encoderStarted;
    private long writtenPresentationTimeUs;
    private final float timeScale;
    private final long trimStartUs;
    private final long trimEndUs;
    private final Logger logger;

    VideoComposer(@NonNull MediaExtractor mediaExtractor, int trackIndex, @NonNull MediaFormat outputFormat, @NonNull MuxRender muxRender, float timeScale, long trimStartMs, long trimEndMs, @NonNull Logger logger) {
        this.mediaExtractor = mediaExtractor;
        this.trackIndex = trackIndex;
        this.outputFormat = outputFormat;
        this.muxRender = muxRender;
        this.timeScale = timeScale;
        this.trimStartUs = TimeUnit.MILLISECONDS.toMicros(trimStartMs);
        this.trimEndUs = trimEndMs == -1L ? trimEndMs : TimeUnit.MILLISECONDS.toMicros(trimEndMs);
        this.logger = logger;
    }

    void setUp(GlFilter filter, Rotation rotation, Size outputResolution, Size inputResolution, FillMode fillMode, FillModeCustomItem fillModeCustomItem, boolean flipVertical, boolean flipHorizontal, EGLContext shareContext) {
        try {
            this.encoder = MediaCodec.createEncoderByType((String)this.outputFormat.getString("mime"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.encoder.configure(this.outputFormat, null, null, 1);
        this.encoderSurface = new EncoderSurface(this.encoder.createInputSurface(), shareContext);
        this.encoderSurface.makeCurrent();
        this.encoder.start();
        this.encoderStarted = true;
        MediaFormat inputFormat = this.mediaExtractor.getTrackFormat(this.trackIndex);
        this.mediaExtractor.seekTo(this.trimStartUs, 0);
        if (inputFormat.containsKey("rotation-degrees")) {
            inputFormat.setInteger("rotation-degrees", 0);
        }
        this.decoderSurface = new DecoderSurface(filter, this.logger);
        this.decoderSurface.setRotation(rotation);
        this.decoderSurface.setOutputResolution(outputResolution);
        this.decoderSurface.setInputResolution(inputResolution);
        this.decoderSurface.setFillMode(fillMode);
        this.decoderSurface.setFillModeCustomItem(fillModeCustomItem);
        this.decoderSurface.setFlipHorizontal(flipHorizontal);
        this.decoderSurface.setFlipVertical(flipVertical);
        this.decoderSurface.completeParams();
        try {
            this.decoder = MediaCodec.createDecoderByType((String)inputFormat.getString("mime"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.decoder.configure(inputFormat, this.decoderSurface.getSurface(), null, 0);
        this.decoder.start();
        this.decoderStarted = true;
    }

    boolean stepPipeline() {
        int status;
        boolean busy = false;
        while (this.drainEncoder() != 0) {
            busy = true;
        }
        do {
            if ((status = this.drainDecoder()) == 0) continue;
            busy = true;
        } while (status == 1);
        while (this.drainExtractor() != 0) {
            busy = true;
        }
        return busy;
    }

    long getWrittenPresentationTimeUs() {
        return (long)((float)this.writtenPresentationTimeUs * this.timeScale);
    }

    boolean isFinished() {
        return this.isEncoderEOS;
    }

    void release() {
        if (this.decoderSurface != null) {
            this.decoderSurface.release();
            this.decoderSurface = null;
        }
        if (this.encoderSurface != null) {
            this.encoderSurface.release();
            this.encoderSurface = null;
        }
        if (this.decoder != null) {
            if (this.decoderStarted) {
                this.decoder.stop();
            }
            this.decoder.release();
            this.decoder = null;
        }
        if (this.encoder != null) {
            if (this.encoderStarted) {
                this.encoder.stop();
            }
            this.encoder.release();
            this.encoder = null;
        }
    }

    private int drainExtractor() {
        if (this.isExtractorEOS) {
            return 0;
        }
        int trackIndex = this.mediaExtractor.getSampleTrackIndex();
        this.logger.debug(TAG, "drainExtractor trackIndex:" + trackIndex);
        if (trackIndex >= 0 && trackIndex != this.trackIndex) {
            return 0;
        }
        int result = this.decoder.dequeueInputBuffer(0L);
        if (result < 0) {
            return 0;
        }
        if (trackIndex < 0 || this.writtenPresentationTimeUs >= this.trimEndUs && this.trimEndUs != -1L) {
            this.isExtractorEOS = true;
            this.decoder.queueInputBuffer(result, 0, 0, 0L, 4);
            this.mediaExtractor.unselectTrack(this.trackIndex);
            return 0;
        }
        int sampleSizeCompat = this.mediaExtractor.readSampleData(this.decoder.getInputBuffer(result), 0);
        boolean isKeyFrame = (this.mediaExtractor.getSampleFlags() & 1) != 0;
        this.decoder.queueInputBuffer(result, 0, sampleSizeCompat, (long)((float)this.mediaExtractor.getSampleTime() / this.timeScale), isKeyFrame ? 1 : 0);
        this.mediaExtractor.advance();
        return 2;
    }

    private int drainDecoder() {
        if (this.isDecoderEOS) {
            return 0;
        }
        int result = this.decoder.dequeueOutputBuffer(this.bufferInfo, 0L);
        switch (result) {
            case -1: {
                return 0;
            }
            case -2: {
                return 1;
            }
            case -3: {
                return 1;
            }
        }
        if ((this.bufferInfo.flags & 4) != 0) {
            this.encoder.signalEndOfInputStream();
            this.isDecoderEOS = true;
            this.bufferInfo.size = 0;
        }
        boolean doRender = this.bufferInfo.size > 0 && this.bufferInfo.presentationTimeUs >= this.trimStartUs && (this.bufferInfo.presentationTimeUs <= this.trimEndUs || this.trimEndUs == -1L);
        this.decoder.releaseOutputBuffer(result, doRender);
        if (doRender) {
            this.decoderSurface.awaitNewImage();
            this.decoderSurface.drawImage();
            this.encoderSurface.setPresentationTime(this.bufferInfo.presentationTimeUs * 1000L);
            this.encoderSurface.swapBuffers();
        } else if (this.bufferInfo.presentationTimeUs != 0L) {
            this.writtenPresentationTimeUs = this.bufferInfo.presentationTimeUs;
        }
        return 2;
    }

    private int drainEncoder() {
        if (this.isEncoderEOS) {
            return 0;
        }
        int result = this.encoder.dequeueOutputBuffer(this.bufferInfo, 0L);
        switch (result) {
            case -1: {
                return 0;
            }
            case -2: {
                if (this.actualOutputFormat != null) {
                    throw new RuntimeException("Video output format changed twice.");
                }
                this.actualOutputFormat = this.encoder.getOutputFormat();
                this.muxRender.setOutputFormat(SampleType.VIDEO, this.actualOutputFormat);
                this.muxRender.onSetOutputFormat();
                return 1;
            }
            case -3: {
                return 1;
            }
        }
        if (this.actualOutputFormat == null) {
            throw new RuntimeException("Could not determine actual output format.");
        }
        if ((this.bufferInfo.flags & 4) != 0) {
            this.isEncoderEOS = true;
            this.bufferInfo.set(0, 0, 0L, this.bufferInfo.flags);
        }
        if ((this.bufferInfo.flags & 2) != 0) {
            this.encoder.releaseOutputBuffer(result, false);
            return 1;
        }
        this.muxRender.writeSampleData(SampleType.VIDEO, this.encoder.getOutputBuffer(result), this.bufferInfo);
        this.writtenPresentationTimeUs = this.bufferInfo.presentationTimeUs;
        this.encoder.releaseOutputBuffer(result, false);
        return 2;
    }
}

