/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.flat.widget;

import android.graphics.Canvas;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.taobao.weex.common.Destroyable;
import com.taobao.weex.ui.flat.FlatGUIContext;
import com.taobao.weex.ui.flat.widget.BaseWidget;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class AndroidViewWidget
extends BaseWidget
implements Destroyable {
    @Nullable
    private View mView;

    public AndroidViewWidget(@NonNull FlatGUIContext context) {
        super(context);
    }

    public void setContentView(@Nullable View view) {
        this.mView = view;
    }

    @Override
    public void setContentBox(int leftOffset, int topOffset, int rightOffset, int bottomOffset) {
        if (this.mView != null) {
            this.mView.setPadding(leftOffset, topOffset, rightOffset, bottomOffset);
            this.invalidate();
        }
    }

    @Override
    public void onDraw(@NonNull Canvas canvas) {
        if (this.mView != null) {
            this.mView.draw(canvas);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.mView != null) {
            this.mView.invalidate();
        }
    }

    @Nullable
    public View getView() {
        return this.mView;
    }

    @Override
    public void destroy() {
        if (this.mView != null) {
            this.mView = null;
        }
    }
}

