/*
 * Decompiled with CFR 0.152.
 */
package com.wonderkiln.camerakit.base;

import android.annotation.TargetApi;
import android.content.Context;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import com.camerakit.R;
import com.wonderkiln.camerakit.base.PreviewImpl;
import com.wonderkiln.camerakit.base.SurfaceViewContainer;
import com.wonderkiln.camerakit.utils.Size;

public class SurfaceViewPreview
extends PreviewImpl {
    private Context mContext;
    private ViewGroup mParent;
    private SurfaceViewContainer mContainer;
    private SurfaceView mSurfaceView;
    private int mDisplayOrientation;

    public SurfaceViewPreview(Context context, ViewGroup parent) {
        this.mContext = context;
        this.mParent = parent;
        View view = View.inflate((Context)context, (int)R.layout.surface_view, (ViewGroup)parent);
        this.mContainer = (SurfaceViewContainer)view.findViewById(R.id.surface_view_container);
        this.mContainer.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int i, int i1, int i2, int i3, int i4, int i5, int i6, int i7) {
                SurfaceViewPreview.this.setSize(SurfaceViewPreview.this.mContainer.getWidth(), SurfaceViewPreview.this.mContainer.getHeight());
            }
        });
        this.mSurfaceView = (SurfaceView)this.mContainer.findViewById(R.id.surface_view);
        SurfaceHolder holder = this.mSurfaceView.getHolder();
        holder.addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                if (SurfaceViewPreview.this.isReady()) {
                    SurfaceViewPreview.this.dispatchSurfaceChanged();
                }
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
            }
        });
    }

    @Override
    public SurfaceHolder getSurfaceHolder() {
        return this.mSurfaceView.getHolder();
    }

    @Override
    public Surface getSurface() {
        return this.getSurfaceHolder().getSurface();
    }

    @Override
    public View getView() {
        return this.mContainer;
    }

    @Override
    public Class getOutputClass() {
        return SurfaceHolder.class;
    }

    @Override
    public void setDisplayOrientation(int displayOrientation) {
        this.mDisplayOrientation = displayOrientation;
        this.mContainer.setDisplayOrientation(displayOrientation);
    }

    @Override
    public boolean isReady() {
        return this.getPreviewWidth() != 0 && this.getPreviewHeight() != 0;
    }

    @Override
    public float getX() {
        return this.mContainer.getChildAt(0).getX();
    }

    @Override
    public float getY() {
        return this.mContainer.getChildAt(0).getY();
    }

    @Override
    @TargetApi(value=15)
    public void setPreviewParameters(int width, int height, int format) {
        super.setPreviewParameters(width, height, format);
        this.mContainer.setPreviewSize(new Size(width, height));
        this.mContainer.post(new Runnable(){

            @Override
            public void run() {
                SurfaceViewPreview.this.getSurfaceHolder().setFixedSize(SurfaceViewPreview.this.getPreviewWidth(), SurfaceViewPreview.this.getPreviewHeight());
            }
        });
    }
}

