/*
 * Decompiled with CFR 0.152.
 */
package com.jinmingyunle.midiplaylib.symbol;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import com.jinmingyunle.midiplaylib.midifile.MidiNote;
import com.jinmingyunle.midiplaylib.musictools.NoteDuration;
import com.jinmingyunle.midiplaylib.musictools.TimeSignature;
import com.jinmingyunle.midiplaylib.sheetmusic.KeySignature;
import com.jinmingyunle.midiplaylib.sheetmusic.SheetMusic;
import com.jinmingyunle.midiplaylib.symbol.AccidSymbol;
import com.jinmingyunle.midiplaylib.symbol.Clef;
import com.jinmingyunle.midiplaylib.symbol.MusicSymbol;
import com.jinmingyunle.midiplaylib.symbol.Stem;
import com.jinmingyunle.midiplaylib.utils.NoteScale;
import com.jinmingyunle.midiplaylib.view.Accid;
import com.jinmingyunle.midiplaylib.view.NoteData;
import com.jinmingyunle.midiplaylib.view.WhiteNote;
import java.util.ArrayList;

public class ChordSymbol
implements MusicSymbol {
    private Clef clef;
    private int starttime;
    private int endtime;
    private NoteData[] notedata;
    private AccidSymbol[] accidsymbols;
    private int width;
    private Stem stem1;
    private Stem stem2;
    private boolean hastwostems;
    private SheetMusic sheetmusic;

    public ChordSymbol(ArrayList<MidiNote> midinotes, KeySignature key, TimeSignature time, Clef c, SheetMusic sheet) {
        NoteDuration dur1;
        int i;
        int len = midinotes.size();
        this.hastwostems = false;
        this.clef = c;
        this.sheetmusic = sheet;
        this.starttime = midinotes.get(0).getStartTime();
        this.endtime = midinotes.get(0).getEndTime();
        for (i = 0; i < len; ++i) {
            if (i > 1 && midinotes.get(i).getNumber() < midinotes.get(i - 1).getNumber()) {
                throw new IllegalArgumentException();
            }
            this.endtime = Math.max(this.endtime, midinotes.get(i).getEndTime());
        }
        this.notedata = ChordSymbol.CreateNoteData(midinotes, key, time);
        this.accidsymbols = ChordSymbol.CreateAccidSymbols(this.notedata, this.clef);
        NoteDuration dur2 = dur1 = this.notedata[0].duration;
        int change = -1;
        for (i = 0; i < this.notedata.length; ++i) {
            dur2 = this.notedata[i].duration;
            if (dur1 == dur2) continue;
            change = i;
            break;
        }
        if (dur1 != dur2) {
            this.hastwostems = true;
            this.stem1 = new Stem(this.notedata[0].whitenote, this.notedata[change - 1].whitenote, dur1, 2, ChordSymbol.NotesOverlap(this.notedata, 0, change));
            this.stem2 = new Stem(this.notedata[change].whitenote, this.notedata[this.notedata.length - 1].whitenote, dur2, 1, ChordSymbol.NotesOverlap(this.notedata, change, this.notedata.length));
        } else {
            int direction = ChordSymbol.StemDirection(this.notedata[0].whitenote, this.notedata[this.notedata.length - 1].whitenote, this.clef);
            this.stem1 = new Stem(this.notedata[0].whitenote, this.notedata[this.notedata.length - 1].whitenote, dur1, direction, ChordSymbol.NotesOverlap(this.notedata, 0, this.notedata.length));
            this.stem2 = null;
        }
        if (dur1 == NoteDuration.Whole) {
            this.stem1 = null;
        }
        if (dur2 == NoteDuration.Whole) {
            this.stem2 = null;
        }
        this.width = this.getMinWidth();
    }

    private static NoteData[] CreateNoteData(ArrayList<MidiNote> midinotes, KeySignature key, TimeSignature time) {
        int len = midinotes.size();
        NoteData[] notedata = new NoteData[len];
        for (int i = 0; i < len; ++i) {
            MidiNote midi = midinotes.get(i);
            notedata[i] = new NoteData();
            notedata[i].number = midi.getNumber();
            notedata[i].leftside = true;
            notedata[i].whitenote = key.GetWhiteNote(midi.getNumber());
            notedata[i].duration = time.GetNoteDuration(midi.getEndTime() - midi.getStartTime());
            notedata[i].accid = key.GetAccidental(midi.getNumber(), midi.getStartTime() / time.getMeasure());
            if (i > 0 && notedata[i].whitenote.Dist(notedata[i - 1].whitenote) == 1) {
                if (notedata[i - 1].leftside) {
                    notedata[i].leftside = false;
                    continue;
                }
                notedata[i].leftside = true;
                continue;
            }
            notedata[i].leftside = true;
        }
        return notedata;
    }

    private static AccidSymbol[] CreateAccidSymbols(NoteData[] notedata, Clef clef) {
        int count = 0;
        for (NoteData n : notedata) {
            if (n.accid == Accid.None) continue;
            ++count;
        }
        AccidSymbol[] accidsymbols = new AccidSymbol[count];
        int i = 0;
        for (NoteData n : notedata) {
            if (n.accid == Accid.None) continue;
            accidsymbols[i] = new AccidSymbol(n.accid, n.whitenote, clef);
            ++i;
        }
        return accidsymbols;
    }

    private static int StemDirection(WhiteNote bottom, WhiteNote top, Clef clef) {
        WhiteNote middle = clef == Clef.Treble ? new WhiteNote(1, 5) : new WhiteNote(3, 3);
        int dist = middle.Dist(bottom) + middle.Dist(top);
        if (dist >= 0) {
            return 1;
        }
        return 2;
    }

    private static boolean NotesOverlap(NoteData[] notedata, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (notedata[i].leftside) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getStartTime() {
        return this.starttime;
    }

    public int getEndTime() {
        return this.endtime;
    }

    public Clef getClef() {
        return this.clef;
    }

    public boolean getHasTwoStems() {
        return this.hastwostems;
    }

    public Stem getStem() {
        if (this.stem1 == null) {
            return this.stem2;
        }
        if (this.stem2 == null) {
            return this.stem1;
        }
        if (this.stem1.getDuration().ordinal() < this.stem2.getDuration().ordinal()) {
            return this.stem1;
        }
        return this.stem2;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int value) {
        this.width = value;
    }

    @Override
    public int getMinWidth() {
        int result = 24;
        if (this.accidsymbols.length > 0) {
            result += this.accidsymbols[0].getMinWidth();
            for (int i = 1; i < this.accidsymbols.length; ++i) {
                AccidSymbol accid = this.accidsymbols[i];
                AccidSymbol prev = this.accidsymbols[i - 1];
                if (accid.getNote().Dist(prev.getNote()) >= 6) continue;
                result += accid.getMinWidth();
            }
        }
        if (this.sheetmusic != null && this.sheetmusic.getShowNoteLetters() != 0) {
            result += 8;
        }
        return result;
    }

    @Override
    public int getAboveStaff() {
        WhiteNote topnote = this.notedata[this.notedata.length - 1].whitenote;
        if (this.stem1 != null) {
            topnote = WhiteNote.Max(topnote, this.stem1.getEnd());
        }
        if (this.stem2 != null) {
            topnote = WhiteNote.Max(topnote, this.stem2.getEnd());
        }
        int dist = topnote.Dist(WhiteNote.Top(this.clef)) * 9 / 2;
        int result = 0;
        if (dist > 0) {
            result = dist;
        }
        for (AccidSymbol symbol : this.accidsymbols) {
            if (symbol.getAboveStaff() <= result) continue;
            result = symbol.getAboveStaff();
        }
        return result;
    }

    @Override
    public int getBelowStaff() {
        WhiteNote bottomnote = this.notedata[0].whitenote;
        if (this.stem1 != null) {
            bottomnote = WhiteNote.Min(bottomnote, this.stem1.getEnd());
        }
        if (this.stem2 != null) {
            bottomnote = WhiteNote.Min(bottomnote, this.stem2.getEnd());
        }
        int dist = WhiteNote.Bottom(this.clef).Dist(bottomnote) * 9 / 2;
        int result = 0;
        if (dist > 0) {
            result = dist;
        }
        for (AccidSymbol symbol : this.accidsymbols) {
            if (symbol.getBelowStaff() <= result) continue;
            result = symbol.getBelowStaff();
        }
        return result;
    }

    private String NoteName(int notenumber, WhiteNote whitenote) {
        if (this.sheetmusic.getShowNoteLetters() == 1) {
            return this.Letter(notenumber, whitenote);
        }
        if (this.sheetmusic.getShowNoteLetters() == 2) {
            String[] fixedDoReMi = new String[]{"La", "Li", "Ti", "Do", "Di", "Re", "Ri", "Mi", "Fa", "Fi", "So", "Si"};
            int notescale = NoteScale.FromNumber(notenumber);
            return fixedDoReMi[notescale];
        }
        if (this.sheetmusic.getShowNoteLetters() == 3) {
            String[] fixedDoReMi = new String[]{"La", "Li", "Ti", "Do", "Di", "Re", "Ri", "Mi", "Fa", "Fi", "So", "Si"};
            int mainscale = this.sheetmusic.getMainKey().Notescale();
            int diff = 3 - mainscale;
            if ((notenumber += diff) < 0) {
                notenumber += 12;
            }
            int notescale = NoteScale.FromNumber(notenumber);
            return fixedDoReMi[notescale];
        }
        if (this.sheetmusic.getShowNoteLetters() == 4) {
            String[] num = new String[]{"10", "11", "12", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
            int notescale = NoteScale.FromNumber(notenumber);
            return num[notescale];
        }
        if (this.sheetmusic.getShowNoteLetters() == 5) {
            String[] num = new String[]{"10", "11", "12", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
            int mainscale = this.sheetmusic.getMainKey().Notescale();
            int diff = 3 - mainscale;
            if ((notenumber += diff) < 0) {
                notenumber += 12;
            }
            int notescale = NoteScale.FromNumber(notenumber);
            return num[notescale];
        }
        return "";
    }

    private String Letter(int notenumber, WhiteNote whitenote) {
        int notescale = NoteScale.FromNumber(notenumber);
        switch (notescale) {
            case 0: {
                return "A";
            }
            case 2: {
                return "B";
            }
            case 3: {
                return "C";
            }
            case 5: {
                return "D";
            }
            case 7: {
                return "E";
            }
            case 8: {
                return "F";
            }
            case 10: {
                return "G";
            }
            case 1: {
                if (whitenote.getLetter() == 0) {
                    return "A#";
                }
                return "Bb";
            }
            case 4: {
                if (whitenote.getLetter() == 2) {
                    return "C#";
                }
                return "Db";
            }
            case 6: {
                if (whitenote.getLetter() == 3) {
                    return "D#";
                }
                return "Eb";
            }
            case 9: {
                if (whitenote.getLetter() == 5) {
                    return "F#";
                }
                return "Gb";
            }
            case 11: {
                if (whitenote.getLetter() == 6) {
                    return "G#";
                }
                return "Ab";
            }
        }
        return "";
    }

    @Override
    public void Draw(Canvas canvas, Paint paint, int ytop) {
        paint.setStyle(Paint.Style.STROKE);
        canvas.translate((float)(this.getWidth() - this.getMinWidth()), 0.0f);
        WhiteNote topstaff = WhiteNote.Top(this.clef);
        int xpos = this.DrawAccid(canvas, paint, ytop);
        canvas.translate((float)xpos, 0.0f);
        this.DrawNotes(canvas, paint, ytop, topstaff);
        if (this.sheetmusic != null && this.sheetmusic.getShowNoteLetters() != 0) {
            this.DrawNoteLetters(canvas, paint, ytop, topstaff);
        }
        if (this.stem1 != null) {
            this.stem1.Draw(canvas, paint, ytop, topstaff);
        }
        if (this.stem2 != null) {
            this.stem2.Draw(canvas, paint, ytop, topstaff);
        }
        canvas.translate((float)(-xpos), 0.0f);
        canvas.translate((float)(-(this.getWidth() - this.getMinWidth())), 0.0f);
    }

    public int DrawAccid(Canvas canvas, Paint paint, int ytop) {
        int xpos = 0;
        AccidSymbol prev = null;
        for (AccidSymbol symbol : this.accidsymbols) {
            if (prev != null && symbol.getNote().Dist(prev.getNote()) < 6) {
                xpos += symbol.getWidth();
            }
            canvas.translate((float)xpos, 0.0f);
            symbol.Draw(canvas, paint, ytop);
            canvas.translate((float)(-xpos), 0.0f);
            prev = symbol;
        }
        if (prev != null) {
            xpos += prev.getWidth();
        }
        return xpos;
    }

    public void DrawNotes(Canvas canvas, Paint paint, int ytop, WhiteNote topstaff) {
        paint.setStrokeWidth(1.0f);
        for (NoteData note : this.notedata) {
            RectF rect;
            int ynote = ytop + topstaff.Dist(note.whitenote) * 9 / 2;
            int xnote = 1;
            if (!note.leftside) {
                xnote += 10;
            }
            canvas.translate((float)(xnote + 5 + 1), (float)(ynote - 2 + 4));
            canvas.rotate(-45.0f);
            if (this.sheetmusic != null) {
                paint.setColor(this.sheetmusic.NoteColor(note.number));
            } else {
                paint.setColor(-16777216);
            }
            if (note.duration == NoteDuration.Whole || note.duration == NoteDuration.Half || note.duration == NoteDuration.DottedHalf) {
                rect = new RectF(-5.0f, -4.0f, 5.0f, 4.0f);
                canvas.drawOval(rect, paint);
                rect = new RectF(-5.0f, -3.0f, 5.0f, 4.0f);
                canvas.drawOval(rect, paint);
                rect = new RectF(-5.0f, -3.0f, 5.0f, 3.0f);
                canvas.drawOval(rect, paint);
            } else {
                paint.setStyle(Paint.Style.FILL);
                rect = new RectF(-5.0f, -4.0f, 5.0f, 4.0f);
                canvas.drawOval(rect, paint);
                paint.setStyle(Paint.Style.STROKE);
            }
            paint.setColor(-16777216);
            canvas.rotate(45.0f);
            canvas.translate((float)(-(xnote + 5 + 1)), (float)(-(ynote - 2 + 4)));
            if (note.duration == NoteDuration.DottedHalf || note.duration == NoteDuration.DottedQuarter || note.duration == NoteDuration.DottedEighth) {
                rect = new RectF((float)(xnote + 10 + 2), (float)(ynote + 2), (float)(xnote + 10 + 2 + 4), (float)(ynote + 2 + 4));
                paint.setStyle(Paint.Style.FILL);
                canvas.drawOval(rect, paint);
                paint.setStyle(Paint.Style.STROKE);
            }
            WhiteNote top = topstaff.Add(1);
            int dist = note.whitenote.Dist(top);
            int y = ytop - 2;
            if (dist >= 2) {
                for (int i = 2; i <= dist; i += 2) {
                    canvas.drawLine((float)(xnote - 1), (float)(y -= 9), (float)(xnote + 10 + 1), (float)y, paint);
                }
            }
            WhiteNote bottom = top.Add(-8);
            y = ytop + 36 - 1;
            dist = bottom.Dist(note.whitenote);
            if (dist < 2) continue;
            for (int i = 2; i <= dist; i += 2) {
                canvas.drawLine((float)(xnote - 1), (float)(y += 9), (float)(xnote + 10 + 1), (float)y, paint);
            }
        }
    }

    public void DrawNoteLetters(Canvas canvas, Paint paint, int ytop, WhiteNote topstaff) {
        boolean overlap = ChordSymbol.NotesOverlap(this.notedata, 0, this.notedata.length);
        paint.setStrokeWidth(1.0f);
        for (NoteData note : this.notedata) {
            if (!note.leftside) continue;
            int ynote = ytop + topstaff.Dist(note.whitenote) * 9 / 2;
            int xnote = 15;
            if (note.duration == NoteDuration.DottedHalf || note.duration == NoteDuration.DottedQuarter || note.duration == NoteDuration.DottedEighth || overlap) {
                xnote += 5;
            }
            canvas.drawText(this.NoteName(note.number, note.whitenote), (float)xnote, (float)(ynote + 4), paint);
        }
    }

    public static boolean CanCreateBeam(ChordSymbol[] chords, TimeSignature time, boolean startQuarter) {
        int beat;
        boolean correctTime;
        int numChords = chords.length;
        Stem firstStem = chords[0].getStem();
        Stem lastStem = chords[chords.length - 1].getStem();
        if (firstStem == null || lastStem == null) {
            return false;
        }
        int measure = chords[0].getStartTime() / time.getMeasure();
        NoteDuration dur = firstStem.getDuration();
        NoteDuration dur2 = lastStem.getDuration();
        boolean dotted8_to_16 = false;
        if (chords.length == 2 && dur == NoteDuration.DottedEighth && dur2 == NoteDuration.Sixteenth) {
            dotted8_to_16 = true;
        }
        if (dur == NoteDuration.Whole || dur == NoteDuration.Half || dur == NoteDuration.DottedHalf || dur == NoteDuration.Quarter || dur == NoteDuration.DottedQuarter || dur == NoteDuration.DottedEighth && !dotted8_to_16) {
            return false;
        }
        if (numChords == 6) {
            if (dur != NoteDuration.Eighth) {
                return false;
            }
            boolean bl = correctTime = time.getNumerator() == 3 && time.getDenominator() == 4 || time.getNumerator() == 6 && time.getDenominator() == 8 || time.getNumerator() == 6 && time.getDenominator() == 4;
            if (!correctTime) {
                return false;
            }
            if (time.getNumerator() == 6 && time.getDenominator() == 4) {
                beat = time.getQuarter() * 3;
                if (chords[0].getStartTime() % beat > time.getQuarter() / 6) {
                    return false;
                }
            }
        } else if (numChords == 4) {
            if (time.getNumerator() == 3 && time.getDenominator() == 8) {
                return false;
            }
            boolean bl = correctTime = time.getNumerator() == 2 || time.getNumerator() == 4 || time.getNumerator() == 8;
            if (!correctTime && dur != NoteDuration.Sixteenth) {
                return false;
            }
            beat = time.getQuarter();
            if (dur == NoteDuration.Eighth) {
                beat = time.getQuarter() * 2;
            } else if (dur == NoteDuration.ThirtySecond) {
                beat = time.getQuarter() / 2;
            }
            if (chords[0].getStartTime() % beat > time.getQuarter() / 6) {
                return false;
            }
        } else if (numChords == 3) {
            boolean valid;
            boolean bl = valid = dur == NoteDuration.Triplet || dur == NoteDuration.Eighth && time.getNumerator() == 12 && time.getDenominator() == 8;
            if (!valid) {
                return false;
            }
            beat = time.getQuarter();
            if (time.getNumerator() == 12 && time.getDenominator() == 8) {
                beat = time.getQuarter() / 2 * 3;
            }
            if (chords[0].getStartTime() % beat > time.getQuarter() / 6) {
                return false;
            }
        } else if (numChords == 2 && startQuarter) {
            int beat2 = time.getQuarter();
            if (chords[0].getStartTime() % beat2 > time.getQuarter() / 6) {
                return false;
            }
        }
        for (ChordSymbol chord : chords) {
            if (chord.getStartTime() / time.getMeasure() != measure) {
                return false;
            }
            if (chord.getStem() == null) {
                return false;
            }
            if (chord.getStem().getDuration() != dur && !dotted8_to_16) {
                return false;
            }
            if (!chord.getStem().IsBeam()) continue;
            return false;
        }
        boolean hasTwoStems = false;
        int direction = 1;
        for (ChordSymbol chord : chords) {
            if (!chord.getHasTwoStems()) continue;
            if (hasTwoStems && chord.getStem().getDirection() != direction) {
                return false;
            }
            hasTwoStems = true;
            direction = chord.getStem().getDirection();
        }
        if (!hasTwoStems) {
            WhiteNote note1 = firstStem.getDirection() == 1 ? firstStem.getTop() : firstStem.getBottom();
            WhiteNote note2 = lastStem.getDirection() == 1 ? lastStem.getTop() : lastStem.getBottom();
            direction = ChordSymbol.StemDirection(note1, note2, chords[0].getClef());
        }
        return !(direction == 1 ? Math.abs(firstStem.getTop().Dist(lastStem.getTop())) >= 11 : Math.abs(firstStem.getBottom().Dist(lastStem.getBottom())) >= 11);
    }

    /*
     * WARNING - void declaration
     */
    public static void CreateBeam(ChordSymbol[] chords, int spacing) {
        void var5_10;
        Stem firstStem = chords[0].getStem();
        Stem lastStem = chords[chords.length - 1].getStem();
        int newdirection = -1;
        for (ChordSymbol chord : chords) {
            if (!chord.getHasTwoStems()) continue;
            newdirection = chord.getStem().getDirection();
            break;
        }
        if (newdirection == -1) {
            WhiteNote whiteNote = firstStem.getDirection() == 1 ? firstStem.getTop() : firstStem.getBottom();
            WhiteNote note2 = lastStem.getDirection() == 1 ? lastStem.getTop() : lastStem.getBottom();
            newdirection = ChordSymbol.StemDirection(whiteNote, note2, chords[0].getClef());
        }
        for (ChordSymbol chord : chords) {
            chord.getStem().setDirection(newdirection);
        }
        if (chords.length == 2) {
            ChordSymbol.BringStemsCloser(chords);
        } else {
            ChordSymbol.LineUpStemEnds(chords);
        }
        firstStem.SetPair(lastStem, spacing);
        boolean bl = true;
        while (var5_10 < chords.length) {
            chords[var5_10].getStem().setReceiver(true);
            ++var5_10;
        }
    }

    static void BringStemsCloser(ChordSymbol[] chords) {
        Stem firstStem = chords[0].getStem();
        Stem lastStem = chords[1].getStem();
        if (firstStem.getDuration() == NoteDuration.DottedEighth && lastStem.getDuration() == NoteDuration.Sixteenth) {
            if (firstStem.getDirection() == 1) {
                firstStem.setEnd(firstStem.getEnd().Add(2));
            } else {
                firstStem.setEnd(firstStem.getEnd().Add(-2));
            }
        }
        int distance = Math.abs(firstStem.getEnd().Dist(lastStem.getEnd()));
        if (firstStem.getDirection() == 1) {
            if (WhiteNote.Max(firstStem.getEnd(), lastStem.getEnd()) == firstStem.getEnd()) {
                lastStem.setEnd(lastStem.getEnd().Add(distance / 2));
            } else {
                firstStem.setEnd(firstStem.getEnd().Add(distance / 2));
            }
        } else if (WhiteNote.Min(firstStem.getEnd(), lastStem.getEnd()) == firstStem.getEnd()) {
            lastStem.setEnd(lastStem.getEnd().Add(-distance / 2));
        } else {
            firstStem.setEnd(firstStem.getEnd().Add(-distance / 2));
        }
    }

    static void LineUpStemEnds(ChordSymbol[] chords) {
        Stem firstStem = chords[0].getStem();
        Stem lastStem = chords[chords.length - 1].getStem();
        Stem middleStem = chords[1].getStem();
        if (firstStem.getDirection() == 1) {
            WhiteNote top = firstStem.getEnd();
            for (ChordSymbol chord : chords) {
                top = WhiteNote.Max(top, chord.getStem().getEnd());
            }
            if (top == firstStem.getEnd() && top.Dist(lastStem.getEnd()) >= 2) {
                firstStem.setEnd(top);
                middleStem.setEnd(top.Add(-1));
                lastStem.setEnd(top.Add(-2));
            } else if (top == lastStem.getEnd() && top.Dist(firstStem.getEnd()) >= 2) {
                firstStem.setEnd(top.Add(-2));
                middleStem.setEnd(top.Add(-1));
                lastStem.setEnd(top);
            } else {
                firstStem.setEnd(top);
                middleStem.setEnd(top);
                lastStem.setEnd(top);
            }
        } else {
            WhiteNote bottom = firstStem.getEnd();
            for (ChordSymbol chord : chords) {
                bottom = WhiteNote.Min(bottom, chord.getStem().getEnd());
            }
            if (bottom == firstStem.getEnd() && lastStem.getEnd().Dist(bottom) >= 2) {
                middleStem.setEnd(bottom.Add(1));
                lastStem.setEnd(bottom.Add(2));
            } else if (bottom == lastStem.getEnd() && firstStem.getEnd().Dist(bottom) >= 2) {
                middleStem.setEnd(bottom.Add(1));
                firstStem.setEnd(bottom.Add(2));
            } else {
                firstStem.setEnd(bottom);
                middleStem.setEnd(bottom);
                lastStem.setEnd(bottom);
            }
        }
        for (int i = 1; i < chords.length - 1; ++i) {
            Stem stem = chords[i].getStem();
            stem.setEnd(middleStem.getEnd());
        }
    }

    public String toString() {
        String result = String.format("ChordSymbol clef=%1$s start=%2$s end=%3$s width=%4$s hastwostems=%5$s ", new Object[]{this.clef, this.getStartTime(), this.getEndTime(), this.getWidth(), this.hastwostems});
        for (AccidSymbol symbol : this.accidsymbols) {
            result = result + symbol.toString() + " ";
        }
        for (NoteData note : this.notedata) {
            result = result + String.format("Note whitenote=%1$s duration=%2$s leftside=%3$s ", new Object[]{note.whitenote, note.duration, note.leftside});
        }
        if (this.stem1 != null) {
            result = result + this.stem1.toString() + " ";
        }
        if (this.stem2 != null) {
            result = result + this.stem2.toString() + " ";
        }
        return result;
    }
}

