/*
 * Decompiled with CFR 0.152.
 */
package com.heytap.msp.push.mode;

import android.text.TextUtils;
import com.heytap.mcssdk.utils.LogUtil;
import org.json.JSONObject;

public class MessageStat {
    private static final String GLOBAL_ID = "globalID";
    private static final String TASK_ID = "taskID";
    private static final String APP_PACKAGE = "appPackage";
    private static final String EVENT_ID = "eventID";
    private static final String PROPERTY = "property";
    private static final String MESSAGE_TYPE = "messageType";
    private static final String EVENT_TIME = "eventTime";
    private static final String STATISTICS_EXTRA = "statistics_extra";
    private static final String DATA_EXTRA = "data_extra";
    private int mType = 4096;
    private String mAppPackage;
    private String mEventId;
    private String mGlobalId;
    private String mTaskID;
    private String mProperty;
    private long mEventTime = System.currentTimeMillis();
    private String mStatisticsExtra;
    private String mDataExtra;

    public MessageStat() {
    }

    public MessageStat(String pkg, String eventId) {
        this(4096, pkg, null, null, eventId, "");
    }

    public MessageStat(String pkg, String eventId, String property) {
        this(4096, pkg, null, null, eventId, property);
    }

    public MessageStat(int type, String pkg, String eventId, String property) {
        this(type, pkg, null, null, eventId, property);
    }

    public MessageStat(int type, String pkg, String globalId, String taskId, String eventId, String property) {
        this(type, pkg, globalId, taskId, eventId, property, "", "");
    }

    public MessageStat(int type, String pkg, String globalId, String taskId, String eventId, String property, String statisticsExtra, String dataExtra) {
        this.setType(type);
        this.setAppPackage(pkg);
        this.setGlobalId(globalId);
        this.setTaskID(taskId);
        this.setEventId(eventId);
        this.setProperty(property);
        this.setStatisticsExtra(statisticsExtra);
        this.setDataExtra(dataExtra);
    }

    public String getStatisticsExtra() {
        return this.mStatisticsExtra;
    }

    public void setStatisticsExtra(String mStatisticsExtra) {
        this.mStatisticsExtra = mStatisticsExtra;
    }

    public String getDataExtra() {
        return this.mDataExtra;
    }

    public void setDataExtra(String mDataExtra) {
        this.mDataExtra = mDataExtra;
    }

    public String getTaskID() {
        return this.mTaskID;
    }

    public void setTaskID(String taskID) {
        this.mTaskID = taskID;
    }

    public void setTaskID(int taskID) {
        this.mTaskID = taskID + "";
    }

    public String getAppPackage() {
        return this.mAppPackage;
    }

    public void setAppPackage(String appPackage) {
        this.mAppPackage = appPackage;
    }

    public int getType() {
        return this.mType;
    }

    public void setType(int type) {
        this.mType = type;
    }

    public String getGlobalId() {
        return this.mGlobalId;
    }

    public void setGlobalId(String globalId) {
        this.mGlobalId = globalId;
    }

    public String getEventId() {
        return this.mEventId;
    }

    public void setEventId(String eventId) {
        this.mEventId = eventId;
    }

    public String getProperty() {
        return this.mProperty;
    }

    public void setProperty(String property) {
        this.mProperty = property;
    }

    public long getEventTime() {
        return this.mEventTime;
    }

    public void setEventTime(long eventTime) {
        this.mEventTime = eventTime;
    }

    public String toJsonObject() {
        JSONObject json = new JSONObject();
        try {
            json.putOpt(MESSAGE_TYPE, (Object)this.mType);
            json.putOpt(EVENT_ID, (Object)this.mEventId);
            json.putOpt(APP_PACKAGE, (Object)this.mAppPackage);
            json.putOpt(EVENT_TIME, (Object)this.mEventTime);
            if (!TextUtils.isEmpty((CharSequence)this.mGlobalId)) {
                json.putOpt(GLOBAL_ID, (Object)this.mGlobalId);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mTaskID)) {
                json.putOpt(TASK_ID, (Object)this.mTaskID);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mProperty)) {
                json.putOpt(PROPERTY, (Object)this.mProperty);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mStatisticsExtra)) {
                json.putOpt(STATISTICS_EXTRA, (Object)this.mStatisticsExtra);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mDataExtra)) {
                json.putOpt(DATA_EXTRA, (Object)this.mDataExtra);
            }
        }
        catch (Exception e) {
            LogUtil.e(e.getLocalizedMessage());
        }
        return json.toString();
    }

    public static MessageStat parse(String content) {
        MessageStat stat = new MessageStat();
        try {
            JSONObject json = new JSONObject(content);
            stat.setType(json.optInt(MESSAGE_TYPE, 0));
            stat.setAppPackage(json.optString(APP_PACKAGE));
            stat.setEventId(json.optString(EVENT_ID));
            stat.setGlobalId(json.optString(GLOBAL_ID, ""));
            stat.setTaskID(json.optString(TASK_ID, ""));
            stat.setProperty(json.optString(PROPERTY, ""));
            stat.setEventTime(json.optLong(EVENT_TIME, System.currentTimeMillis()));
            stat.setStatisticsExtra(json.optString(STATISTICS_EXTRA));
            stat.setDataExtra(json.optString(DATA_EXTRA));
        }
        catch (Exception e) {
            LogUtil.e(e.getLocalizedMessage());
            return null;
        }
        return stat;
    }
}

