/*
 * Decompiled with CFR 0.152.
 */
package cn.rongcloud.rtc.audioroute;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.RequiresPermission;
import cn.rongcloud.rtc.api.RCRTCAudioRouteManager;
import cn.rongcloud.rtc.api.RCRTCEngine;
import cn.rongcloud.rtc.api.callback.IRCRTCAudioRouteListener;
import cn.rongcloud.rtc.audioroute.AudioControllerWrapper;
import cn.rongcloud.rtc.audioroute.IRouteState;
import cn.rongcloud.rtc.audioroute.RCAudioRouteChangeListener;
import cn.rongcloud.rtc.audioroute.RCAudioRouteType;
import cn.rongcloud.rtc.audioroute.StateManager;
import cn.rongcloud.rtc.center.stream.RCMicOutputStreamImpl;
import cn.rongcloud.rtc.core.ThreadUtils;
import cn.rongcloud.rtc.utils.FinLog;
import cn.rongcloud.rtc.utils.ReportUtil;
import io.rong.common.SystemUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class RTCAudioRouteManagerImpl
extends RCRTCAudioRouteManager {
    private static final String TAG = "AudioRouteManager";
    IRCRTCAudioRouteListener mAudioRouteListener;
    RCAudioRouteChangeListener mInternalListener;
    AudioControllerWrapper mAudioControllerWrapper;
    BroadcastReceiver mHeadsetReceiver;
    BroadcastReceiver mBtHeadsetReceiver;
    Context mContext;
    StateManager mStateManager;
    IRouteState mCurrentState;
    IRouteState mIdleState = new IdleState();
    IRouteState mHeadSetState = new HeadSetState();
    IRouteState mBtHeadSetState = new BtHeadSetState();
    boolean mUserSpeakerSet = true;
    private boolean initFlag = false;
    private static volatile RTCAudioRouteManagerImpl INSTANCE = null;
    Handler mHandler = null;
    Handler mainThreadHandler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RTCAudioRouteManagerImpl getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<RTCAudioRouteManagerImpl> clazz = RTCAudioRouteManagerImpl.class;
        synchronized (RTCAudioRouteManagerImpl.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new RTCAudioRouteManagerImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private RTCAudioRouteManagerImpl() {
        Looper handle = Looper.myLooper();
        if (handle != null) {
            this.mHandler = new Handler(handle);
        } else {
            handle = Looper.getMainLooper();
            if (handle != null) {
                this.mHandler = new Handler(handle);
            } else {
                this.mHandler = null;
                ReportUtil.appError(ReportUtil.TAG.AUDIO_ROUTE, "code|msg", -1, "handler is null");
                return;
            }
        }
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void init(final Context context) {
        if (!context.getApplicationInfo().packageName.equals(SystemUtils.getCurrentProcessName((Context)context.getApplicationContext()))) {
            ReportUtil.appStatus(ReportUtil.TAG.AUDIO_ROUTE, "status|reason", "return", "ipc not allow init");
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (RTCAudioRouteManagerImpl.this.initFlag) {
                    ReportUtil.appError(ReportUtil.TAG.AUDIO_ROUTE, -1, "init already");
                    return;
                }
                RTCAudioRouteManagerImpl.this.initFlag = true;
                ReportUtil.appTask(ReportUtil.TAG.AUDIO_ROUTE, "init", context == null ? "null" : "");
                if (context == null) {
                    throw new IllegalArgumentException("The context not allowed to be null");
                }
                RCMicOutputStreamImpl stream = (RCMicOutputStreamImpl)RCRTCEngine.getInstance().getDefaultAudioStream();
                if (stream != null) {
                    RTCAudioRouteManagerImpl.this.mInternalListener = stream.getAudioRouteChangeListener();
                } else {
                    FinLog.w(RTCAudioRouteManagerImpl.TAG, "RCRTCEngine.getInstance().getDefaultAudioStream() is null for login failed");
                }
                RTCAudioRouteManagerImpl.this.mContext = context;
                RTCAudioRouteManagerImpl.this.mAudioControllerWrapper = new AudioControllerWrapper(RTCAudioRouteManagerImpl.this.mContext);
                RTCAudioRouteManagerImpl.this.mStateManager = new StateManager();
                RTCAudioRouteManagerImpl.this.mStateManager.add(RTCAudioRouteManagerImpl.this.mIdleState);
                RTCAudioRouteManagerImpl.this.mHeadsetReceiver = new HeadsetBroadcastReceiver();
                RTCAudioRouteManagerImpl.this.mBtHeadsetReceiver = new BtHeadsetBroadcastReceiver();
                RTCAudioRouteManagerImpl.this.mContext.registerReceiver(RTCAudioRouteManagerImpl.this.mHeadsetReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
                IntentFilter btIntentFilter = new IntentFilter();
                btIntentFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
                btIntentFilter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
                btIntentFilter.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
                btIntentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
                btIntentFilter.addAction("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED");
                RTCAudioRouteManagerImpl.this.mContext.registerReceiver(RTCAudioRouteManagerImpl.this.mBtHeadsetReceiver, btIntentFilter);
                try {
                    RTCAudioRouteManagerImpl.this.resetAudioRouteStateInternal();
                }
                catch (Exception e) {
                    ReportUtil.appError(ReportUtil.TAG.AUDIO_ROUTE, "desc", "has been unInit");
                    e.printStackTrace();
                }
                ReportUtil.appRes(ReportUtil.TAG.AUDIO_ROUTE, "init", "success");
            }
        });
    }

    @Override
    public void resetAudioRouteState() {
        if (Thread.currentThread() == this.mHandler.getLooper().getThread()) {
            this.resetAudioRouteStateInternal();
        } else {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    RTCAudioRouteManagerImpl.this.resetAudioRouteStateInternal();
                }
            });
        }
    }

    private void resetAudioRouteStateInternal() {
        ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_RESET, "", new Object[0]);
        this.checkInit();
        this.mStateManager.remove(this.mHeadSetState);
        this.mStateManager.remove(this.mBtHeadSetState);
        this.mStateManager.removeAndOffer(this.mIdleState);
        if (this.mAudioControllerWrapper.isWiredHeadsetOn()) {
            ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_RESET, "isWiredHeadsetOn", new Object[0]);
            this.mStateManager.removeAndOffer(this.mHeadSetState);
        }
        if (this.mAudioControllerWrapper.isBluetoothHeadSet()) {
            ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_RESET, "hasBluetooth", new Object[0]);
            this.mStateManager.removeAndOffer(this.mBtHeadSetState);
        }
        this.mUserSpeakerSet = this.mAudioControllerWrapper.isSpeakerphoneOn();
        ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_RESET, "speakerOn", this.mUserSpeakerSet);
        this.stateOperation();
        ReportUtil.libRes(ReportUtil.TAG.AUDIO_ROUTE_RESET, "reset", "finish");
    }

    @Override
    public boolean hasHeadSet() {
        return ThreadUtils.invokeAtFrontUninterruptibly(this.mHandler, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                RTCAudioRouteManagerImpl.this.checkInit();
                boolean wiredHeadsetOn = RTCAudioRouteManagerImpl.this.mAudioControllerWrapper.mAudioManager.isWiredHeadsetOn();
                ReportUtil.appOperate(ReportUtil.TAG.AUDIO_DEVICE_STATUS, "hasHeadSet", wiredHeadsetOn);
                return wiredHeadsetOn;
            }
        });
    }

    @Override
    public boolean hasBluetoothA2dpConnected() {
        int a2dp;
        boolean bool = false;
        AudioControllerWrapper audioControllerWrapper = this.mAudioControllerWrapper;
        if (audioControllerWrapper == null) {
            return false;
        }
        BluetoothAdapter mAdapter = audioControllerWrapper.getBluetoothAdapter();
        if (mAdapter != null && mAdapter.isEnabled() && (a2dp = mAdapter.getProfileConnectionState(1)) == 2) {
            bool = true;
        }
        ReportUtil.appOperate(ReportUtil.TAG.AUDIO_DEVICE_STATUS, "hasBluetooth", bool);
        return bool;
    }

    private void stateOperation() {
        IRouteState tmpState = this.mStateManager.peekLast();
        if (this.mCurrentState != null && tmpState != this.mCurrentState) {
            this.mCurrentState.cancelState();
            this.mCurrentState = tmpState;
            this.mCurrentState.recoverState();
            this.onAudioRouteChanged(this.mCurrentState.getType());
        } else if (this.mCurrentState == null) {
            this.mCurrentState = this.mIdleState;
            this.onAudioRouteChanged(this.mCurrentState.getType());
        }
    }

    private void onAudioRouteChanged(final RCAudioRouteType type) {
        ReportUtil.appOperate(ReportUtil.TAG.AUDIO_ROUTE_TYPE, "routeType", new Object[]{type});
        final IRCRTCAudioRouteListener listener = this.mAudioRouteListener;
        if (listener != null && this.mainThreadHandler != null) {
            this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    listener.onRouteChanged(type);
                }
            });
        }
        if (this.mInternalListener != null) {
            this.mInternalListener.onAudioRouteChanged(type);
        }
    }

    @Override
    public void setOnAudioRouteChangedListener(final IRCRTCAudioRouteListener listener) {
        ReportUtil.appStatus(ReportUtil.TAG.AUDIO_ROUTE, "listener", listener == null ? "null" : "");
        this.mAudioRouteListener = listener;
        if (listener != null && this.mainThreadHandler != null) {
            this.mainThreadHandler.removeCallbacksAndMessages((Object)this);
            this.mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (null != RTCAudioRouteManagerImpl.this.mCurrentState) {
                        listener.onRouteChanged(RTCAudioRouteManagerImpl.this.mCurrentState.getType());
                    }
                }
            });
        }
    }

    @Override
    public boolean hasInit() {
        return this.initFlag;
    }

    @Override
    public void unInit() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (!RTCAudioRouteManagerImpl.this.initFlag) {
                    ReportUtil.appError(ReportUtil.TAG.AUDIO_ROUTE, "task", "has not init");
                    return;
                }
                RTCAudioRouteManagerImpl.this.initFlag = false;
                ReportUtil.appOperate(ReportUtil.TAG.AUDIO_ROUTE, "task", "unInit");
                if (RTCAudioRouteManagerImpl.this.mCurrentState != null) {
                    RTCAudioRouteManagerImpl.this.mCurrentState.cancelState();
                }
                RTCAudioRouteManagerImpl.this.mContext.unregisterReceiver(RTCAudioRouteManagerImpl.this.mHeadsetReceiver);
                RTCAudioRouteManagerImpl.this.mContext.unregisterReceiver(RTCAudioRouteManagerImpl.this.mBtHeadsetReceiver);
                if (RTCAudioRouteManagerImpl.this.mainThreadHandler != null) {
                    RTCAudioRouteManagerImpl.this.mainThreadHandler.removeCallbacksAndMessages((Object)this);
                }
                RTCAudioRouteManagerImpl.this.mAudioRouteListener = null;
                RTCAudioRouteManagerImpl.this.mCurrentState = null;
                RTCAudioRouteManagerImpl.this.mContext = null;
                RTCAudioRouteManagerImpl.this.mHandler.removeCallbacksAndMessages((Object)"TOKEN_RETRY_OPEN_SCO");
                RTCAudioRouteManagerImpl.this.mInternalListener = null;
            }
        });
    }

    public void setSpeakerphoneOn(final boolean on) {
        if (Thread.currentThread() == this.mHandler.getLooper().getThread()) {
            this.setSpeakerphoneOnInternal(on);
        } else {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    RTCAudioRouteManagerImpl.this.setSpeakerphoneOnInternal(on);
                }
            });
        }
    }

    private void setSpeakerphoneOnInternal(boolean on) {
        ReportUtil.appOperate(ReportUtil.TAG.AUDIO_ROUTE, "task|speakerOn", "setSpeakerphoneOn", on);
        this.checkInit();
        this.mUserSpeakerSet = on;
        if (this.mCurrentState != null) {
            this.mCurrentState.setSpeakerphoneOn(on);
        }
    }

    private void checkInit() {
        if (!this.initFlag) {
            ReportUtil.libError(ReportUtil.TAG.AUDIO_ROUTE, "desc", "not init");
            throw new RuntimeException("the audio route manager not init");
        }
    }

    private class BtHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private static final long RETRY_OPEN_SCO_DURING = 2000L;
        private static final int MAX_RETRY_OPEN_SCO_TIMES = 5;
        public static final String TOKEN_RETRY_OPEN_SCO = "TOKEN_RETRY_OPEN_SCO";
        private final AtomicInteger retryOpenScoTimes = new AtomicInteger(5);

        private BtHeadsetBroadcastReceiver() {
        }

        private void internaProcess(Context context, Intent intent) {
            String action = intent.getAction();
            Log.d((String)RTCAudioRouteManagerImpl.TAG, (String)("internaProcess : action = " + action));
            if (null == action) {
                return;
            }
            if (!"android.media.ACTION_SCO_AUDIO_STATE_UPDATED".equals(action) && !"android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED".equals(action)) {
                this.retryOpenScoTimes.set(5);
                Handler handler = RTCAudioRouteManagerImpl.this.mHandler;
                if (handler != null) {
                    handler.removeCallbacksAndMessages((Object)TOKEN_RETRY_OPEN_SCO);
                }
            }
            int curState = 0;
            int preState = 0;
            if (action.equalsIgnoreCase("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                curState = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -99);
                preState = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", -99);
                if (2 == curState && RTCAudioRouteManagerImpl.this.mAudioControllerWrapper.isBluetoothHeadSet()) {
                    RTCAudioRouteManagerImpl.this.mStateManager.removeAndOffer(RTCAudioRouteManagerImpl.this.mBtHeadSetState);
                    Handler handler = RTCAudioRouteManagerImpl.this.mHandler;
                    if (handler != null && handler.getLooper().getThread().isAlive()) {
                        handler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                if (RTCAudioRouteManagerImpl.this.mCurrentState == RTCAudioRouteManagerImpl.this.mBtHeadSetState && RTCAudioRouteManagerImpl.this.hasInit()) {
                                    RTCAudioRouteManagerImpl.this.mAudioControllerWrapper.setSco(true, true, false);
                                }
                            }
                        }, 3000L);
                    }
                    ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_BT_CHANGE, "task|curconnectionstate|preconnectionstate", "removeAndOffer", curState, preState);
                } else if (0 == curState) {
                    RTCAudioRouteManagerImpl.this.mStateManager.remove(RTCAudioRouteManagerImpl.this.mBtHeadSetState);
                    ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_BT_CHANGE, "task|curconnectionstate|preconnectionstate", "remove", curState, preState);
                }
            } else if (!action.equalsIgnoreCase("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                if (action.equalsIgnoreCase("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                    curState = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -99);
                    preState = intent.getIntExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", -99);
                    if (RTCAudioRouteManagerImpl.this.mCurrentState == RTCAudioRouteManagerImpl.this.mBtHeadSetState && 1 != curState) {
                        int times;
                        ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_BT_CHANGE, "task|curconnectionstate|preconnectionstate", "Sco reconnect", curState, preState);
                        Handler handler = RTCAudioRouteManagerImpl.this.mHandler;
                        boolean hasMessage = false;
                        if (handler != null) {
                            hasMessage = handler.hasMessages(0, (Object)TOKEN_RETRY_OPEN_SCO);
                        }
                        if (hasMessage) {
                            handler.removeCallbacksAndMessages((Object)TOKEN_RETRY_OPEN_SCO);
                            times = this.retryOpenScoTimes.get() + 1;
                        } else {
                            times = this.retryOpenScoTimes.getAndDecrement();
                        }
                        if (times > 0) {
                            if (handler != null) {
                                handler.postAtTime(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (RTCAudioRouteManagerImpl.this.mCurrentState == RTCAudioRouteManagerImpl.this.mBtHeadSetState) {
                                            ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_BT_CHANGE, "task|times", "try open sco", times);
                                            RTCAudioRouteManagerImpl.this.mAudioControllerWrapper.setSco(true, true);
                                        }
                                    }
                                }, (Object)TOKEN_RETRY_OPEN_SCO, SystemClock.uptimeMillis() + (times == 5 ? 0L : 2000L));
                            }
                        } else {
                            IRouteState fromState;
                            RTCAudioRouteManagerImpl.this.mStateManager.remove(RTCAudioRouteManagerImpl.this.mBtHeadSetState);
                            ReportUtil.libError(ReportUtil.TAG.AUDIO_ROUTE_BT_CHANGE, "desc", "open sco failed");
                            IRCRTCAudioRouteListener audioRouteListener = RTCAudioRouteManagerImpl.this.mAudioRouteListener;
                            if (audioRouteListener != null && (fromState = RTCAudioRouteManagerImpl.this.mStateManager.peekLast()) != null) {
                                ReportUtil.libStatus(ReportUtil.TAG.AUDIO_ROUTE_BT_CHANGE, "task|fromType|toType|", new Object[]{"BTSwitchFailed", fromState.getType(), RTCAudioRouteManagerImpl.this.mBtHeadSetState.getType()});
                                audioRouteListener.onRouteSwitchFailed(fromState.getType(), RTCAudioRouteManagerImpl.this.mBtHeadSetState.getType());
                            }
                        }
                    } else if (1 == curState && RTCAudioRouteManagerImpl.this.mAudioControllerWrapper.getScoOn()) {
                        ReportUtil.libStatus(ReportUtil.TAG.AUDIO_ROUTE_BT_CHANGE, "desc", "sco start success");
                        Handler handler = RTCAudioRouteManagerImpl.this.mHandler;
                        if (handler != null) {
                            handler.removeCallbacksAndMessages((Object)TOKEN_RETRY_OPEN_SCO);
                        }
                    }
                } else if (action.equalsIgnoreCase("android.bluetooth.adapter.action.STATE_CHANGED")) {
                    AudioControllerWrapper audioController = RTCAudioRouteManagerImpl.this.mAudioControllerWrapper;
                    if (audioController == null) {
                        return;
                    }
                    int bluetoothConnectionState = audioController.getBluetoothAdapter().getProfileConnectionState(1);
                    if (bluetoothConnectionState == 0) {
                        RTCAudioRouteManagerImpl.this.mStateManager.remove(RTCAudioRouteManagerImpl.this.mBtHeadSetState);
                    }
                } else if (action.equalsIgnoreCase("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED")) {
                    curState = intent.getIntExtra("android.bluetooth.adapter.extra.CONNECTION_STATE", -99);
                    preState = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE", -99);
                    if (2 == curState && RTCAudioRouteManagerImpl.this.mAudioControllerWrapper.isBluetoothHeadSet()) {
                        RTCAudioRouteManagerImpl.this.mStateManager.removeAndOffer(RTCAudioRouteManagerImpl.this.mBtHeadSetState);
                        BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                        BluetoothClass bluetoothClass = bluetoothDevice.getBluetoothClass();
                        boolean hasAudioService = bluetoothClass.hasService(0x200000);
                        boolean hasTelService = bluetoothClass.hasService(0x400000);
                        ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_BT_CHANGE, "task|curconnectionstate|preconnectionstate", "adapter removeAndOffer", curState, preState);
                    } else if (0 == curState) {
                        RTCAudioRouteManagerImpl.this.mStateManager.remove(RTCAudioRouteManagerImpl.this.mBtHeadSetState);
                        ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_BT_CHANGE, "task|curconnectionstate|preconnectionstate", "adapter remove", curState, preState);
                    }
                }
            }
        }

        public void onReceive(final Context context, final Intent intent) {
            if (RTCAudioRouteManagerImpl.this.mHandler == null) {
                return;
            }
            RTCAudioRouteManagerImpl.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    BtHeadsetBroadcastReceiver.this.internaProcess(context, intent);
                    RTCAudioRouteManagerImpl.this.stateOperation();
                }
            });
        }
    }

    private class HeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private HeadsetBroadcastReceiver() {
        }

        private void internaProcess(Context context, Intent intent) {
            if ("android.intent.action.HEADSET_PLUG".equalsIgnoreCase(intent.getAction()) && intent.hasExtra("state")) {
                int state = intent.getIntExtra("state", -1);
                if (state == 1) {
                    int microphone = intent.getIntExtra("microphone", -1);
                    ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_HEADSET_CHANGE, "task|connectionstate|micstate", "removeAndOffer", state, microphone);
                    RTCAudioRouteManagerImpl.this.mStateManager.removeAndOffer(RTCAudioRouteManagerImpl.this.mHeadSetState);
                } else if (state == 0) {
                    ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_HEADSET_CHANGE, "task|connectionstate", "remove", state);
                    RTCAudioRouteManagerImpl.this.mStateManager.remove(RTCAudioRouteManagerImpl.this.mHeadSetState);
                } else {
                    ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_HEADSET_CHANGE, "task|connectionstate", "HeadsetBroadcastReceiver", state);
                }
            }
        }

        public void onReceive(final Context context, final Intent intent) {
            if (null == RTCAudioRouteManagerImpl.this.mHandler) {
                return;
            }
            RTCAudioRouteManagerImpl.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    HeadsetBroadcastReceiver.this.internaProcess(context, intent);
                    RTCAudioRouteManagerImpl.this.stateOperation();
                }
            });
        }
    }

    class BtHeadSetState
    implements IRouteState {
        BtHeadSetState() {
        }

        @Override
        public void setSpeakerphoneOn(boolean on) {
            ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_STATE, "task|state", "setSpeakerphoneOn", "BtHeadSetState");
        }

        @Override
        public void recoverState() {
            ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_STATE, "task|state", "recoverState", "BtHeadSetState");
            if (null != RTCAudioRouteManagerImpl.this.mAudioControllerWrapper) {
                RTCAudioRouteManagerImpl.this.mAudioControllerWrapper.setSpeakerphoneOn(false);
                RTCAudioRouteManagerImpl.this.mAudioControllerWrapper.setSco(true, false);
            }
        }

        @Override
        public void cancelState() {
            ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_STATE, "task|state", "cancelState", "BtHeadSetState");
            if (null != RTCAudioRouteManagerImpl.this.mAudioControllerWrapper) {
                RTCAudioRouteManagerImpl.this.mAudioControllerWrapper.setSco(false, false);
            }
        }

        @Override
        public RCAudioRouteType getType() {
            return RCAudioRouteType.HEADSET_BLUETOOTH;
        }
    }

    class HeadSetState
    implements IRouteState {
        HeadSetState() {
        }

        @Override
        public void setSpeakerphoneOn(boolean on) {
            ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_STATE, "task|state", "setSpeakerphoneOn", "HeadSetState");
        }

        @Override
        public void recoverState() {
            if (null != RTCAudioRouteManagerImpl.this.mAudioControllerWrapper) {
                ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_STATE, "task|state", "recoverState", "HeadSetState");
                RTCAudioRouteManagerImpl.this.mAudioControllerWrapper.setSpeakerphoneOn(false);
            }
        }

        @Override
        public void cancelState() {
            ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_STATE, "task|state", "cancelState", "HeadSetState");
        }

        @Override
        public RCAudioRouteType getType() {
            return RCAudioRouteType.HEADSET;
        }
    }

    class IdleState
    implements IRouteState {
        IdleState() {
        }

        @Override
        public void setSpeakerphoneOn(boolean on) {
            if (null != RTCAudioRouteManagerImpl.this.mAudioControllerWrapper) {
                ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_STATE, "task|state|isSpeaker", "setSpeakerphoneOn", "IdleState", on);
                RTCAudioRouteManagerImpl.this.mAudioControllerWrapper.setSpeakerphoneOn(on);
                RTCAudioRouteManagerImpl.this.onAudioRouteChanged(on ? RCAudioRouteType.SPEAKER_PHONE : RCAudioRouteType.EARPIECE);
            }
        }

        @Override
        public void recoverState() {
            if (null != RTCAudioRouteManagerImpl.this.mAudioControllerWrapper) {
                ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_STATE, "task|state", "recoverState", "IdleState");
                if (RTCAudioRouteManagerImpl.this.mHandler != null) {
                    RTCAudioRouteManagerImpl.this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            RTCAudioRouteManagerImpl.this.mAudioControllerWrapper.setSpeakerphoneOn(RTCAudioRouteManagerImpl.this.mUserSpeakerSet);
                        }
                    }, 50L);
                }
            }
        }

        @Override
        public void cancelState() {
            ReportUtil.libTask(ReportUtil.TAG.AUDIO_ROUTE_STATE, "task|state", "cancelState", "IdleState");
        }

        @Override
        public RCAudioRouteType getType() {
            if (RTCAudioRouteManagerImpl.this.mUserSpeakerSet) {
                return RCAudioRouteType.SPEAKER_PHONE;
            }
            return RCAudioRouteType.EARPIECE;
        }
    }
}

