/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.appfram.storage;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.appfram.storage.IWXStorage;
import com.taobao.weex.appfram.storage.IWXStorageAdapter;
import com.taobao.weex.appfram.storage.StorageResultHandler;
import com.taobao.weex.bridge.JSCallback;
import java.util.Map;

public class WXStorageModule
extends WXSDKEngine.DestroyableModule
implements IWXStorage {
    IWXStorageAdapter mStorageAdapter;

    private IWXStorageAdapter ability() {
        if (this.mStorageAdapter != null) {
            return this.mStorageAdapter;
        }
        this.mStorageAdapter = WXSDKEngine.getIWXStorageAdapter();
        return this.mStorageAdapter;
    }

    @Override
    @JSMethod(uiThread=false)
    public void setItem(String key, String value, final @Nullable JSCallback callback) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            StorageResultHandler.handleInvalidParam(callback);
            return;
        }
        IWXStorageAdapter adapter = this.ability();
        if (adapter == null) {
            StorageResultHandler.handleNoHandlerError(callback);
            return;
        }
        adapter.setItem(key, value, new IWXStorageAdapter.OnResultReceivedListener(){

            @Override
            public void onReceived(Map<String, Object> data) {
                if (callback != null) {
                    callback.invoke(data);
                }
            }
        });
    }

    @Override
    @JSMethod(uiThread=false)
    public void getItem(String key, final @Nullable JSCallback callback) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            StorageResultHandler.handleInvalidParam(callback);
            return;
        }
        IWXStorageAdapter adapter = this.ability();
        if (adapter == null) {
            StorageResultHandler.handleNoHandlerError(callback);
            return;
        }
        adapter.getItem(key, new IWXStorageAdapter.OnResultReceivedListener(){

            @Override
            public void onReceived(Map<String, Object> data) {
                if (callback != null) {
                    callback.invoke(data);
                }
            }
        });
    }

    @Override
    @JSMethod(uiThread=false)
    public void removeItem(String key, final @Nullable JSCallback callback) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            StorageResultHandler.handleInvalidParam(callback);
            return;
        }
        IWXStorageAdapter adapter = this.ability();
        if (adapter == null) {
            StorageResultHandler.handleNoHandlerError(callback);
            return;
        }
        adapter.removeItem(key, new IWXStorageAdapter.OnResultReceivedListener(){

            @Override
            public void onReceived(Map<String, Object> data) {
                if (callback != null) {
                    callback.invoke(data);
                }
            }
        });
    }

    @Override
    @JSMethod(uiThread=false)
    public void length(final @Nullable JSCallback callback) {
        IWXStorageAdapter adapter = this.ability();
        if (adapter == null) {
            StorageResultHandler.handleNoHandlerError(callback);
            return;
        }
        adapter.length(new IWXStorageAdapter.OnResultReceivedListener(){

            @Override
            public void onReceived(Map<String, Object> data) {
                if (callback != null) {
                    callback.invoke(data);
                }
            }
        });
    }

    @Override
    @JSMethod(uiThread=false)
    public void getAllKeys(final @Nullable JSCallback callback) {
        IWXStorageAdapter adapter = this.ability();
        if (adapter == null) {
            StorageResultHandler.handleNoHandlerError(callback);
            return;
        }
        adapter.getAllKeys(new IWXStorageAdapter.OnResultReceivedListener(){

            @Override
            public void onReceived(Map<String, Object> data) {
                if (callback != null) {
                    callback.invoke(data);
                }
            }
        });
    }

    @Override
    @JSMethod(uiThread=false)
    public void setItemPersistent(String key, String value, final @Nullable JSCallback callback) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            StorageResultHandler.handleInvalidParam(callback);
            return;
        }
        IWXStorageAdapter adapter = this.ability();
        if (adapter == null) {
            StorageResultHandler.handleNoHandlerError(callback);
            return;
        }
        adapter.setItemPersistent(key, value, new IWXStorageAdapter.OnResultReceivedListener(){

            @Override
            public void onReceived(Map<String, Object> data) {
                if (callback != null) {
                    callback.invoke(data);
                }
            }
        });
    }

    @Override
    public void destroy() {
        IWXStorageAdapter adapter = this.ability();
        if (adapter != null) {
            adapter.close();
        }
    }
}

