/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils.batch;

import com.taobao.weex.utils.batch.BactchExecutor;
import com.taobao.weex.utils.batch.Interceptor;
import java.util.concurrent.CopyOnWriteArrayList;

public class BatchOperationHelper
implements Interceptor {
    private BactchExecutor mExecutor;
    private CopyOnWriteArrayList<Runnable> sRegisterTasks = new CopyOnWriteArrayList();
    private boolean isCollecting = false;

    public BatchOperationHelper(BactchExecutor executor) {
        this.mExecutor = executor;
        executor.setInterceptor(this);
        this.isCollecting = true;
    }

    @Override
    public boolean take(Runnable runnable) {
        if (this.isCollecting) {
            this.sRegisterTasks.add(runnable);
            return true;
        }
        return false;
    }

    public void flush() {
        this.isCollecting = false;
        this.mExecutor.post(new Runnable(){

            @Override
            public void run() {
                for (Runnable item : BatchOperationHelper.this.sRegisterTasks) {
                    item.run();
                    BatchOperationHelper.this.sRegisterTasks.remove(item);
                }
            }
        });
        this.mExecutor.setInterceptor(null);
    }
}

