/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex.adapter.Fresco;

import android.content.res.Resources;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Build;
import com.dcloud.android.annotation.Nullable;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.drawee.drawable.DrawableParent;
import com.facebook.drawee.drawable.ForwardingDrawable;
import com.facebook.drawee.drawable.MatrixDrawable;
import com.facebook.drawee.drawable.Rounded;
import com.facebook.drawee.drawable.RoundedBitmapDrawable;
import com.facebook.drawee.drawable.RoundedColorDrawable;
import com.facebook.drawee.drawable.RoundedCornersDrawable;
import com.facebook.drawee.drawable.RoundedNinePatchDrawable;
import com.facebook.drawee.drawable.ScaleTypeDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.imagepipeline.systrace.FrescoSystrace;

public class DCWrappingUtils {
    private static final String TAG = "WrappingUtils";
    private static final Drawable sEmptyDrawable = new ColorDrawable(0);

    @Nullable
    static Drawable maybeWrapWithScaleType(@Nullable Drawable drawable2, @Nullable ScalingUtils.ScaleType scaleType) {
        return DCWrappingUtils.maybeWrapWithScaleType(drawable2, scaleType, null);
    }

    @Nullable
    static Drawable maybeWrapWithScaleType(@Nullable Drawable drawable2, @Nullable ScalingUtils.ScaleType scaleType, @Nullable PointF focusPoint) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"WrappingUtils#maybeWrapWithScaleType");
        }
        if (drawable2 == null || scaleType == null) {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
            return drawable2;
        }
        ScaleTypeDrawable scaleTypeDrawable = new ScaleTypeDrawable(drawable2, scaleType);
        if (focusPoint != null) {
            scaleTypeDrawable.setFocusPoint(focusPoint);
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        return scaleTypeDrawable;
    }

    @Nullable
    static Drawable maybeWrapWithMatrix(@Nullable Drawable drawable2, @Nullable Matrix matrix) {
        if (drawable2 == null || matrix == null) {
            return drawable2;
        }
        return new MatrixDrawable(drawable2, matrix);
    }

    static ScaleTypeDrawable wrapChildWithScaleType(DrawableParent parent, ScalingUtils.ScaleType scaleType) {
        Drawable child = parent.setDrawable(sEmptyDrawable);
        child = DCWrappingUtils.maybeWrapWithScaleType(child, scaleType);
        parent.setDrawable(child);
        Preconditions.checkNotNull((Object)child, (Object)"Parent has no child drawable!");
        return (ScaleTypeDrawable)child;
    }

    static void updateOverlayColorRounding(DrawableParent parent, @Nullable RoundingParams roundingParams) {
        Drawable child = parent.getDrawable();
        if (roundingParams != null && roundingParams.getRoundingMethod() == RoundingParams.RoundingMethod.OVERLAY_COLOR) {
            if (child instanceof RoundedCornersDrawable) {
                RoundedCornersDrawable roundedCornersDrawable = (RoundedCornersDrawable)child;
                DCWrappingUtils.applyRoundingParams((Rounded)roundedCornersDrawable, roundingParams);
                roundedCornersDrawable.setOverlayColor(roundingParams.getOverlayColor());
            } else {
                child = parent.setDrawable(sEmptyDrawable);
                child = DCWrappingUtils.maybeWrapWithRoundedOverlayColor(child, roundingParams);
                parent.setDrawable(child);
            }
        } else if (child instanceof RoundedCornersDrawable) {
            RoundedCornersDrawable roundedCornersDrawable = (RoundedCornersDrawable)child;
            child = roundedCornersDrawable.setCurrent(sEmptyDrawable);
            parent.setDrawable(child);
            sEmptyDrawable.setCallback(null);
        }
    }

    static void updateLeafRounding(DrawableParent parent, @Nullable RoundingParams roundingParams, Resources resources) {
        parent = DCWrappingUtils.findDrawableParentForLeaf(parent);
        Drawable child = parent.getDrawable();
        if (roundingParams != null && roundingParams.getRoundingMethod() == RoundingParams.RoundingMethod.BITMAP_ONLY) {
            if (child instanceof Rounded) {
                Rounded rounded = (Rounded)child;
                DCWrappingUtils.applyRoundingParams(rounded, roundingParams);
            } else if (child != null) {
                parent.setDrawable(sEmptyDrawable);
                Drawable rounded = DCWrappingUtils.applyLeafRounding(child, roundingParams, resources);
                parent.setDrawable(rounded);
            }
        } else if (child instanceof Rounded) {
            DCWrappingUtils.resetRoundingParams((Rounded)child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Drawable maybeWrapWithRoundedOverlayColor(@Nullable Drawable drawable2, @Nullable RoundingParams roundingParams) {
        try {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"WrappingUtils#maybeWrapWithRoundedOverlayColor");
            }
            if (drawable2 == null || roundingParams == null || roundingParams.getRoundingMethod() != RoundingParams.RoundingMethod.OVERLAY_COLOR) {
                Drawable drawable3 = drawable2;
                return drawable3;
            }
            RoundedCornersDrawable roundedCornersDrawable = new RoundedCornersDrawable(drawable2);
            DCWrappingUtils.applyRoundingParams((Rounded)roundedCornersDrawable, roundingParams);
            roundedCornersDrawable.setOverlayColor(roundingParams.getOverlayColor());
            RoundedCornersDrawable roundedCornersDrawable2 = roundedCornersDrawable;
            return roundedCornersDrawable2;
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Drawable maybeApplyLeafRounding(@Nullable Drawable drawable2, @Nullable RoundingParams roundingParams, Resources resources) {
        try {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"WrappingUtils#maybeApplyLeafRounding");
            }
            if (drawable2 == null || roundingParams == null || roundingParams.getRoundingMethod() != RoundingParams.RoundingMethod.BITMAP_ONLY) {
                Drawable drawable3 = drawable2;
                return drawable3;
            }
            if (drawable2 instanceof ForwardingDrawable) {
                DrawableParent parent = DCWrappingUtils.findDrawableParentForLeaf((DrawableParent)((ForwardingDrawable)drawable2));
                Drawable child = parent.setDrawable(sEmptyDrawable);
                child = DCWrappingUtils.applyLeafRounding(child, roundingParams, resources);
                parent.setDrawable(child);
                Drawable drawable4 = drawable2;
                return drawable4;
            }
            Drawable drawable5 = DCWrappingUtils.applyLeafRounding(drawable2, roundingParams, resources);
            return drawable5;
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    private static Drawable applyLeafRounding(Drawable drawable2, RoundingParams roundingParams, Resources resources) {
        if (drawable2 instanceof BitmapDrawable) {
            BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
            RoundedBitmapDrawable roundedBitmapDrawable = new RoundedBitmapDrawable(resources, bitmapDrawable.getBitmap(), bitmapDrawable.getPaint());
            DCWrappingUtils.applyRoundingParams((Rounded)roundedBitmapDrawable, roundingParams);
            return roundedBitmapDrawable;
        }
        if (drawable2 instanceof NinePatchDrawable) {
            NinePatchDrawable ninePatchDrawableDrawable = (NinePatchDrawable)drawable2;
            RoundedNinePatchDrawable roundedNinePatchDrawable = new RoundedNinePatchDrawable(ninePatchDrawableDrawable);
            DCWrappingUtils.applyRoundingParams((Rounded)roundedNinePatchDrawable, roundingParams);
            return roundedNinePatchDrawable;
        }
        if (drawable2 instanceof ColorDrawable && Build.VERSION.SDK_INT >= 11) {
            RoundedColorDrawable roundedColorDrawable = RoundedColorDrawable.fromColorDrawable((ColorDrawable)((ColorDrawable)drawable2));
            DCWrappingUtils.applyRoundingParams((Rounded)roundedColorDrawable, roundingParams);
            return roundedColorDrawable;
        }
        FLog.w((String)TAG, (String)"Don't know how to round that drawable: %s", (Object[])new Object[]{drawable2});
        return drawable2;
    }

    static void applyRoundingParams(Rounded rounded, RoundingParams roundingParams) {
        rounded.setCircle(roundingParams.getRoundAsCircle());
        rounded.setRadii(roundingParams.getCornersRadii());
        rounded.setBorder(roundingParams.getBorderColor(), roundingParams.getBorderWidth());
        rounded.setPadding(roundingParams.getPadding());
        rounded.setScaleDownInsideBorders(roundingParams.getScaleDownInsideBorders());
    }

    static void resetRoundingParams(Rounded rounded) {
        rounded.setCircle(false);
        rounded.setRadius(0.0f);
        rounded.setBorder(0, 0.0f);
        rounded.setPadding(0.0f);
        rounded.setScaleDownInsideBorders(false);
    }

    static DrawableParent findDrawableParentForLeaf(DrawableParent parent) {
        Drawable child;
        while ((child = parent.getDrawable()) != parent && child instanceof DrawableParent) {
            parent = (DrawableParent)child;
        }
        return parent;
    }
}

