/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.graphics.Paint;
import android.text.Spannable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.DimenRes;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.appcompat.widget.AppCompatEditText;
import com.vanniktech.emoji.EmojiEditable;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiPopup;
import com.vanniktech.emoji.SingleEmojiTrait;
import com.vanniktech.emoji.Utils;
import com.vanniktech.emoji.emoji.Emoji;

public class EmojiEditText
extends AppCompatEditText
implements EmojiEditable {
    private float emojiSize;
    private boolean disableKeyboardInput;

    public EmojiEditText(Context context) {
        this(context, null);
    }

    public EmojiEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.emojiSize = Utils.initTextView((TextView)this, attrs);
    }

    public EmojiEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.emojiSize = Utils.initTextView((TextView)this, attrs);
    }

    @CallSuper
    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        if (this.isInEditMode()) {
            return;
        }
        Paint.FontMetrics fontMetrics = this.getPaint().getFontMetrics();
        float defaultEmojiSize = fontMetrics.descent - fontMetrics.ascent;
        EmojiManager.getInstance().replaceWithImages(this.getContext(), (Spannable)this.getText(), this.emojiSize != 0.0f ? this.emojiSize : defaultEmojiSize);
    }

    @Override
    @CallSuper
    public void backspace() {
        Utils.backspace((EditText)this);
    }

    @Override
    @CallSuper
    public void input(Emoji emoji) {
        Utils.input((EditText)this, emoji);
    }

    @Override
    public final float getEmojiSize() {
        return this.emojiSize;
    }

    @Override
    public final void setEmojiSize(@Px int pixels) {
        this.setEmojiSize(pixels, true);
    }

    @Override
    public final void setEmojiSize(@Px int pixels, boolean shouldInvalidate) {
        this.emojiSize = pixels;
        if (shouldInvalidate) {
            this.setText((CharSequence)this.getText());
        }
    }

    @Override
    public final void setEmojiSizeRes(@DimenRes int res) {
        this.setEmojiSizeRes(res, true);
    }

    @Override
    public final void setEmojiSizeRes(@DimenRes int res, boolean shouldInvalidate) {
        this.setEmojiSize(this.getResources().getDimensionPixelSize(res), shouldInvalidate);
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener l) {
        View.OnFocusChangeListener onFocusChangeListener = this.getOnFocusChangeListener();
        if (onFocusChangeListener instanceof ForceEmojisOnlyFocusChangeListener) {
            ForceEmojisOnlyFocusChangeListener cast = (ForceEmojisOnlyFocusChangeListener)onFocusChangeListener;
            super.setOnFocusChangeListener((View.OnFocusChangeListener)new ForceEmojisOnlyFocusChangeListener(l, cast.emojiPopup));
        } else {
            super.setOnFocusChangeListener(l);
        }
    }

    public boolean isKeyboardInputDisabled() {
        return this.disableKeyboardInput;
    }

    public void disableKeyboardInput(EmojiPopup emojiPopup) {
        this.disableKeyboardInput = true;
        super.setOnFocusChangeListener((View.OnFocusChangeListener)new ForceEmojisOnlyFocusChangeListener(this.getOnFocusChangeListener(), emojiPopup));
    }

    public void enableKeyboardInput() {
        this.disableKeyboardInput = false;
        View.OnFocusChangeListener onFocusChangeListener = this.getOnFocusChangeListener();
        if (onFocusChangeListener instanceof ForceEmojisOnlyFocusChangeListener) {
            ForceEmojisOnlyFocusChangeListener cast = (ForceEmojisOnlyFocusChangeListener)onFocusChangeListener;
            super.setOnFocusChangeListener(cast.onFocusChangeListener);
        }
    }

    public void forceSingleEmoji() {
        SingleEmojiTrait.install((EditText)this);
    }

    static class ForceEmojisOnlyFocusChangeListener
    implements View.OnFocusChangeListener {
        final EmojiPopup emojiPopup;
        @Nullable
        final View.OnFocusChangeListener onFocusChangeListener;

        ForceEmojisOnlyFocusChangeListener(@Nullable View.OnFocusChangeListener onFocusChangeListener, EmojiPopup emojiPopup) {
            this.emojiPopup = emojiPopup;
            this.onFocusChangeListener = onFocusChangeListener;
        }

        public void onFocusChange(View view, boolean hasFocus) {
            if (hasFocus) {
                this.emojiPopup.start();
                this.emojiPopup.show();
            } else {
                this.emojiPopup.dismiss();
            }
            if (this.onFocusChangeListener != null) {
                this.onFocusChangeListener.onFocusChange(view, hasFocus);
            }
        }
    }
}

