/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.videobase;

import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.NonNull;
import com.tencent.liteav.base.annotations.CalledByNative;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.videobase.TXCCloudVideoViewMethodInvoker;
import com.tencent.liteav.videobase.videobase.b;
import com.tencent.liteav.videobase.videobase.c;
import com.tencent.rtmp.ui.TXCloudVideoView;
import java.lang.ref.WeakReference;

@JNINamespace(value="liteav::video")
public class DisplayTarget {
    private static final String TAG = "DisplayTarget";
    private final String mTAG = "DisplayTarget_" + this.hashCode();
    private final CustomHandler mUIHandler = new CustomHandler(Looper.getMainLooper());
    private final a mTargetType;
    private WeakReference<TXCloudVideoView> mTxCloudVideoView;
    private WeakReference<TextureView> mTextureView;
    private WeakReference<SurfaceView> mSurfaceView;
    private Surface mSurface;
    private boolean mIsViewFromTXCloudVideoView = false;

    public DisplayTarget(DisplayTarget displayTarget) {
        this.mTargetType = displayTarget.mTargetType;
        this.mTxCloudVideoView = displayTarget.mTxCloudVideoView;
        this.mTextureView = displayTarget.mTextureView;
        this.mSurfaceView = displayTarget.mSurfaceView;
        this.mSurface = displayTarget.mSurface;
        this.mIsViewFromTXCloudVideoView = displayTarget.mIsViewFromTXCloudVideoView;
    }

    public DisplayTarget(TXCloudVideoView txCloudVideoView) {
        if (txCloudVideoView == null) {
            this.mTargetType = a.d;
            return;
        }
        SurfaceView surfaceView = txCloudVideoView.getSurfaceView();
        Surface surface = txCloudVideoView.getSurface();
        TextureView textureView = TXCCloudVideoViewMethodInvoker.getTextureViewSetByUser(txCloudVideoView);
        if (surfaceView != null) {
            this.mTargetType = a.b;
            this.mSurfaceView = new WeakReference<SurfaceView>(surfaceView);
        } else if (surface != null) {
            this.mTargetType = a.c;
            this.mSurface = surface;
        } else if (textureView != null) {
            this.mTargetType = a.a;
            this.mTextureView = new WeakReference<TextureView>(textureView);
            this.mTxCloudVideoView = new WeakReference<TXCloudVideoView>(txCloudVideoView);
        } else {
            this.mTargetType = a.d;
            this.mTxCloudVideoView = new WeakReference<TXCloudVideoView>(txCloudVideoView);
        }
        this.mIsViewFromTXCloudVideoView = true;
    }

    public DisplayTarget(TextureView textureView) {
        this.mTargetType = a.a;
        this.mTextureView = new WeakReference<TextureView>(textureView);
    }

    public DisplayTarget(SurfaceView surfaceView) {
        this.mTargetType = a.b;
        this.mSurfaceView = new WeakReference<SurfaceView>(surfaceView);
    }

    public DisplayTarget(Surface surface) {
        this.mTargetType = a.c;
        this.mSurface = surface;
    }

    public a getType() {
        return this.mTargetType;
    }

    public SurfaceView getSurfaceView() {
        if (this.mSurfaceView != null) {
            return (SurfaceView)this.mSurfaceView.get();
        }
        return null;
    }

    public TXCloudVideoView getTXCloudVideoView() {
        if (this.mTxCloudVideoView != null) {
            return (TXCloudVideoView)((Object)this.mTxCloudVideoView.get());
        }
        return null;
    }

    public TextureView getTextureView() {
        if (this.mTextureView != null) {
            return (TextureView)this.mTextureView.get();
        }
        return null;
    }

    public Surface getSurface() {
        return this.mSurface;
    }

    @CalledByNative
    public void hideAll() {
        if (!this.mIsViewFromTXCloudVideoView) {
            DisplayTarget displayTarget = this;
            displayTarget.setVisibility((View)displayTarget.getTextureView(), 8);
            DisplayTarget displayTarget2 = this;
            displayTarget2.setVisibility((View)displayTarget2.getSurfaceView(), 8);
        }
    }

    @CalledByNative
    public void showAll() {
        DisplayTarget displayTarget = this;
        displayTarget.setVisibility((View)displayTarget.getTextureView(), 0);
        DisplayTarget displayTarget2 = this;
        displayTarget2.setVisibility((View)displayTarget2.getSurfaceView(), 0);
        if (this.mTxCloudVideoView != null) {
            DisplayTarget displayTarget3 = this;
            displayTarget3.requestLayout((View)displayTarget3.mTxCloudVideoView.get());
        }
        DisplayTarget displayTarget4 = this;
        displayTarget4.requestLayout((View)displayTarget4.getTextureView());
        DisplayTarget displayTarget5 = this;
        displayTarget5.requestLayout((View)displayTarget5.getSurfaceView());
    }

    @NonNull
    public Size getSize() {
        int n2 = 0;
        int n3 = 0;
        View view = null;
        if (this.mTargetType == a.b && this.mSurfaceView != null) {
            view = (View)this.mSurfaceView.get();
        } else if (this.mTargetType == a.a && this.mTextureView != null) {
            view = (View)this.mTextureView.get();
        } else if (this.mTargetType == a.d && this.mTxCloudVideoView != null) {
            view = (View)this.mTxCloudVideoView.get();
        }
        if (view != null) {
            n2 = view.getWidth();
            n3 = view.getHeight();
        }
        return new Size(n2, n3);
    }

    @NonNull
    public String toString() {
        return "DisplayTarget{mTargetType=" + (Object)((Object)this.mTargetType) + ", mTXCloudVideoView=" + (Object)((Object)this.getTXCloudVideoView()) + ", mTextureView=" + this.getTextureView() + ", mSurfaceView=" + this.getSurfaceView() + ", mSurface=" + this.mSurface + '}';
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DisplayTarget displayTarget = (DisplayTarget)o2;
        return this.mTargetType == displayTarget.mTargetType && CommonUtil.equals((Object)this.getTXCloudVideoView(), (Object)displayTarget.getTXCloudVideoView()) && CommonUtil.equals(this.getTextureView(), displayTarget.getTextureView()) && CommonUtil.equals(this.getSurfaceView(), displayTarget.getSurfaceView()) && CommonUtil.equals(this.mSurface, displayTarget.mSurface);
    }

    @CalledByNative
    public static DisplayTarget create(Object object) {
        if (object instanceof DisplayTarget) {
            return new DisplayTarget((DisplayTarget)object);
        }
        if (object instanceof TXCloudVideoView) {
            return new DisplayTarget((TXCloudVideoView)((Object)object));
        }
        if (object instanceof TextureView) {
            return new DisplayTarget((TextureView)object);
        }
        if (object instanceof SurfaceView) {
            return new DisplayTarget((SurfaceView)object);
        }
        LiteavLog.w(TAG, "object is unknown. object=".concat(String.valueOf(object)));
        return null;
    }

    private void runOnUIThread(Runnable task) {
        if (Looper.myLooper() == this.mUIHandler.getLooper()) {
            task.run();
            return;
        }
        this.mUIHandler.post(task);
    }

    private void setVisibility(View view, int visible) {
        if (view == null) {
            return;
        }
        this.runOnUIThread(b.a(view, visible));
    }

    private void requestLayout(View view) {
        if (view == null) {
            return;
        }
        View view2 = view;
        view2.getClass();
        this.runOnUIThread(c.a(view2));
    }

    static /* synthetic */ void lambda$setVisibility$0(View view, int visible) {
        view.setVisibility(visible);
    }

    public static enum a {
        a,
        b,
        c,
        d;

    }
}

