/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.annotation.TargetApi;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.common.c;
import com.tencent.ugc.VideoDemuxer;
import com.tencent.ugc.common.MediaExtractorBuilder;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class MediaExtractorWrapper {
    private static final String TAG = "MediaExtractorWrapper";
    private static final int INIT_SAMPLE_SIZE = 0x100000;
    private static final int MAX_SAMPLE_SIZE = 0xA00000;
    private MediaExtractor mVideoExtractor;
    private MediaExtractor mAudioExtractor;
    private MediaFormat mVideoFormat;
    private MediaFormat mAudioFormat;
    private ByteBuffer mVideoBuffer;
    private boolean mIsReachEOF = false;

    public boolean setDataSource(String dataSource) {
        Log.i(TAG, " setDataSource path: ".concat(String.valueOf(dataSource)), new Object[0]);
        if (this.mVideoExtractor != null) {
            this.mVideoExtractor.release();
        }
        if (this.mAudioExtractor != null) {
            this.mAudioExtractor.release();
        }
        this.mVideoExtractor = new MediaExtractorBuilder().setPath(dataSource).build();
        this.mAudioExtractor = new MediaExtractorBuilder().setPath(dataSource).build();
        this.mVideoFormat = MediaExtractorWrapper.selectFormat(this.mVideoExtractor, "video");
        this.mAudioFormat = MediaExtractorWrapper.selectFormat(this.mAudioExtractor, "audio");
        return this.mVideoFormat != null || this.mAudioFormat != null;
    }

    private static MediaFormat selectFormat(MediaExtractor mediaExtractor, String mimetype) {
        if (mediaExtractor == null) {
            return null;
        }
        for (int i2 = 0; i2 < mediaExtractor.getTrackCount(); ++i2) {
            MediaFormat mediaFormat = mediaExtractor.getTrackFormat(i2);
            String string = mediaFormat.getString("mime");
            if (string == null || !string.startsWith(mimetype)) continue;
            Log.i(TAG, "selectFormat ".concat(String.valueOf(mediaFormat)), new Object[0]);
            mediaExtractor.selectTrack(i2);
            return mediaFormat;
        }
        return null;
    }

    public int getWidth() {
        MediaExtractorWrapper mediaExtractorWrapper = this;
        return mediaExtractorWrapper.getIntegerFormatValue(mediaExtractorWrapper.mVideoFormat, "width");
    }

    public int getHeight() {
        MediaExtractorWrapper mediaExtractorWrapper = this;
        return mediaExtractorWrapper.getIntegerFormatValue(mediaExtractorWrapper.mVideoFormat, "height");
    }

    public int getVideoFrameRate() {
        try {
            if (this.mVideoFormat == null) {
                return 20;
            }
            return this.mVideoFormat.getInteger("frame-rate");
        }
        catch (NullPointerException nullPointerException) {
            try {
                return this.mVideoFormat.getInteger("video-framerate");
            }
            catch (NullPointerException nullPointerException2) {
                return 20;
            }
        }
    }

    public int getSampleRate() {
        MediaExtractorWrapper mediaExtractorWrapper = this;
        return mediaExtractorWrapper.getIntegerFormatValue(mediaExtractorWrapper.mAudioFormat, "sample-rate");
    }

    public int getChannelCount() {
        MediaExtractorWrapper mediaExtractorWrapper = this;
        return mediaExtractorWrapper.getIntegerFormatValue(mediaExtractorWrapper.mAudioFormat, "channel-count");
    }

    public int getAudioBitrate() {
        MediaExtractorWrapper mediaExtractorWrapper = this;
        return mediaExtractorWrapper.getIntegerFormatValue(mediaExtractorWrapper.mAudioFormat, "bitrate");
    }

    public long getAudioDuration() {
        MediaExtractorWrapper mediaExtractorWrapper = this;
        return mediaExtractorWrapper.getLongFormatValue(mediaExtractorWrapper.mAudioFormat, "durationUs");
    }

    public int getVideoBitrate() {
        MediaExtractorWrapper mediaExtractorWrapper = this;
        return mediaExtractorWrapper.getIntegerFormatValue(mediaExtractorWrapper.mVideoFormat, "bitrate");
    }

    public long getVideoDuration() {
        MediaExtractorWrapper mediaExtractorWrapper = this;
        return mediaExtractorWrapper.getLongFormatValue(mediaExtractorWrapper.mVideoFormat, "durationUs");
    }

    public String getVideoMimeType() {
        MediaExtractorWrapper mediaExtractorWrapper = this;
        return mediaExtractorWrapper.getStringFormatValue(mediaExtractorWrapper.mVideoFormat, "mime");
    }

    private int getIntegerFormatValue(MediaFormat format, String key) {
        try {
            if (format == null) {
                return 0;
            }
            return format.getInteger(key);
        }
        catch (Exception exception) {
            Log.e(TAG, "getFormatValue key = " + key + " Exception e = " + exception, new Object[0]);
            return 0;
        }
    }

    private long getLongFormatValue(MediaFormat format, String key) {
        try {
            if (format == null) {
                return 0L;
            }
            return format.getLong(key);
        }
        catch (Exception exception) {
            Log.e(TAG, "getFormatValue key = " + key + " Exception e = " + exception, new Object[0]);
            return 0L;
        }
    }

    private String getStringFormatValue(MediaFormat format, String key) {
        try {
            if (format == null) {
                return null;
            }
            return format.getString(key);
        }
        catch (Exception exception) {
            Log.e(TAG, "getFormatValue key = " + key + " Exception e = " + exception, new Object[0]);
            return null;
        }
    }

    public EncodedVideoFrame readVideoSampleData() {
        if (this.mVideoExtractor == null) {
            Log.v(TAG, "readVideoSampleData mVideoExtractor is null", new Object[0]);
            return VideoDemuxer.END_OF_STREAM;
        }
        long l2 = this.mVideoExtractor.getSampleTime();
        if (l2 == -1L || this.mIsReachEOF) {
            Log.i(TAG, "readVideoSampleData end", new Object[0]);
            return VideoDemuxer.END_OF_STREAM;
        }
        EncodedVideoFrame encodedVideoFrame = new EncodedVideoFrame();
        try {
            MediaExtractorWrapper mediaExtractorWrapper = this;
            encodedVideoFrame.data = mediaExtractorWrapper.readData(mediaExtractorWrapper.mVideoExtractor);
        }
        catch (Exception exception) {
            Log.w(TAG, "read sample data failed.", exception);
            this.mIsReachEOF = true;
            return VideoDemuxer.END_OF_STREAM;
        }
        encodedVideoFrame.nalType = c.a;
        if ((this.mVideoExtractor.getSampleFlags() & 1) != 0) {
            encodedVideoFrame.nalType = c.b;
            encodedVideoFrame.videoFormat = this.mVideoFormat;
        }
        encodedVideoFrame.pts = l2 / 1000L;
        encodedVideoFrame.width = this.getWidth();
        encodedVideoFrame.height = this.getHeight();
        this.mIsReachEOF = !this.mVideoExtractor.advance();
        return encodedVideoFrame;
    }

    private ByteBuffer readData(MediaExtractor videoExtractor) {
        if (this.mVideoBuffer == null) {
            this.mVideoBuffer = ByteBuffer.allocateDirect(0x100000);
        }
        int n2 = 0;
        while (n2 == 0) {
            try {
                n2 = videoExtractor.readSampleData(this.mVideoBuffer, 0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.mVideoBuffer.capacity() > 0xA00000) break;
                this.mVideoBuffer = ByteBuffer.allocateDirect(this.mVideoBuffer.capacity() * 2);
                Log.e(TAG, "resize sample buffer size to " + this.mVideoBuffer.capacity(), new Object[0]);
            }
        }
        if (n2 == 0) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
        byteBuffer.put(this.mVideoBuffer);
        byteBuffer.position(0);
        this.mVideoBuffer.position(0);
        return byteBuffer;
    }

    public MediaFormat getVideoFormat() {
        return this.mVideoFormat;
    }

    public MediaFormat getAudioFormat() {
        return this.mAudioFormat;
    }

    public void seekVideo(long time) {
        if (this.mVideoExtractor != null) {
            Log.i(TAG, "seekVideo time = ".concat(String.valueOf(time)), new Object[0]);
            this.mVideoExtractor.seekTo(time, 0);
        }
    }

    public void release() {
        Log.i(TAG, "release", new Object[0]);
        if (this.mVideoExtractor != null) {
            this.mVideoExtractor.release();
            this.mVideoExtractor = null;
        }
        if (this.mAudioExtractor != null) {
            this.mAudioExtractor.release();
            this.mAudioExtractor = null;
        }
    }
}

