/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.os.HandlerThread;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.ugc.UGCFrameQueue;
import com.tencent.ugc.VideoDemuxer;
import com.tencent.ugc.gz;
import com.tencent.ugc.ha;
import com.tencent.ugc.hb;
import com.tencent.ugc.hc;
import com.tencent.ugc.hd;
import com.tencent.ugc.he;
import com.tencent.ugc.hf;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@JNINamespace(value="liteav::ugc")
public class VideoDemuxerFFmpeg
implements UGCFrameQueue.UGCFrameQueueListener,
VideoDemuxer {
    private static final String TAG = "VideoDemuxerFFmpeg";
    private static final int MAX_FRAME_SIZE = 20;
    private static final int OPEN_MEDIA_OUT_TIME = 3000;
    private final UGCFrameQueue<EncodedVideoFrame> mFrameQueue = new UGCFrameQueue();
    private long mNativeHandler;
    private CustomHandler mWorkHandler;
    private AtomicBoolean mOpenSuccess = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open(String path) {
        VideoDemuxerFFmpeg videoDemuxerFFmpeg = this;
        synchronized (videoDemuxerFFmpeg) {
            if (this.mWorkHandler != null) {
                LiteavLog.w(TAG, "demuxer is already open!");
                return false;
            }
            HandlerThread handlerThread = new HandlerThread("ugc-media-list-source");
            handlerThread.start();
            this.mWorkHandler = new CustomHandler(handlerThread.getLooper());
        }
        this.mWorkHandler.runAndWaitDone(gz.a(this, path), 3000L);
        return this.mOpenSuccess.get();
    }

    @Override
    public void close() {
        VideoDemuxerFFmpeg videoDemuxerFFmpeg = this;
        videoDemuxerFFmpeg.runOnWorkThread(ha.a(videoDemuxerFFmpeg));
    }

    private void destroyNativeHandler() {
        if (this.mNativeHandler != 0L) {
            VideoDemuxerFFmpeg.nativeClose(this.mNativeHandler);
            VideoDemuxerFFmpeg.nativeDestroy(this.mNativeHandler);
            this.mNativeHandler = 0L;
        }
    }

    @Override
    public boolean seek(long timeMs) {
        FutureTask futureTask = new FutureTask(hb.a(this, timeMs));
        this.runOnWorkThread(futureTask);
        boolean bl2 = false;
        try {
            bl2 = (Boolean)futureTask.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            LiteavLog.w(TAG, "seek future task exception: ".concat(String.valueOf(exception)));
        }
        return bl2;
    }

    @Override
    public EncodedVideoFrame getNextEncodeVideoFrame() {
        return this.mFrameQueue.dequeue();
    }

    private void getNextEncodeVideoFrameInternal() {
        if (this.mNativeHandler == 0L) {
            this.mFrameQueue.queue(END_OF_STREAM);
            return;
        }
        if (this.mFrameQueue.size() > 20) {
            return;
        }
        EncodedVideoFrame encodedVideoFrame = VideoDemuxerFFmpeg.nativeGetNextEncodeVideoFrame(this.mNativeHandler);
        if (encodedVideoFrame != null && encodedVideoFrame.data != null && encodedVideoFrame.data.remaining() != 0) {
            this.mFrameQueue.queue(encodedVideoFrame);
        } else {
            this.mFrameQueue.queue(END_OF_STREAM);
        }
        if (this.mWorkHandler != null) {
            this.mWorkHandler.removeCallbacks(hc.a(this));
            this.mWorkHandler.post(hd.a(this));
        }
    }

    @Override
    public void onFrameDequeued() {
        VideoDemuxerFFmpeg videoDemuxerFFmpeg = this;
        videoDemuxerFFmpeg.runOnWorkThread(he.a(videoDemuxerFFmpeg));
    }

    public long getFirstFramePtsOfAllStream() {
        if (this.mNativeHandler != 0L) {
            return VideoDemuxerFFmpeg.nativeGetFirstFramePtsOfAllStream(this.mNativeHandler);
        }
        return 0L;
    }

    private void clearFrameQueue() {
        for (EncodedVideoFrame encodedVideoFrame : this.mFrameQueue.dequeueAll()) {
            if (encodedVideoFrame == null) continue;
            encodedVideoFrame.release();
        }
    }

    private void runOnWorkThread(Runnable runnable) {
        CustomHandler customHandler = this.mWorkHandler;
        if (customHandler != null) {
            customHandler.runOrPost(runnable);
        }
    }

    private static native long nativeCreate(VideoDemuxerFFmpeg var0);

    private static native void nativeDestroy(long var0);

    private static native int nativeOpen(long var0, String var2);

    private static native void nativeClose(long var0);

    private static native boolean nativeSeek(long var0, long var2);

    private static native EncodedVideoFrame nativeGetNextEncodeVideoFrame(long var0);

    private static native long nativeGetFirstFramePtsOfAllStream(long var0);

    static /* synthetic */ Boolean lambda$seek$2(VideoDemuxerFFmpeg this_, long timeMs) throws Exception {
        if (this_.mNativeHandler == 0L) {
            return Boolean.FALSE;
        }
        this_.clearFrameQueue();
        boolean bl2 = VideoDemuxerFFmpeg.nativeSeek(this_.mNativeHandler, timeMs);
        this_.getNextEncodeVideoFrameInternal();
        return bl2;
    }

    static /* synthetic */ void lambda$close$1(VideoDemuxerFFmpeg this_) {
        this_.clearFrameQueue();
        this_.mFrameQueue.queue(END_OF_STREAM);
        this_.mFrameQueue.setUGCFrameQueueListener(null);
        this_.destroyNativeHandler();
        this_.mOpenSuccess.set(false);
        if (this_.mWorkHandler != null) {
            this_.mWorkHandler.quitLooper();
            this_.mWorkHandler = null;
        }
    }

    static /* synthetic */ void lambda$open$0(VideoDemuxerFFmpeg this_, String path) {
        this_.mNativeHandler = VideoDemuxerFFmpeg.nativeCreate(this_);
        if (this_.mNativeHandler == 0L) {
            LiteavLog.e(TAG, "create native instance failed.");
            this_.mFrameQueue.queue(END_OF_STREAM);
            return;
        }
        if (VideoDemuxerFFmpeg.nativeOpen(this_.mNativeHandler, path) != 0) {
            LiteavLog.e(TAG, "native FFmpegDemuxerWrapper open failed.");
            this_.destroyNativeHandler();
            this_.mFrameQueue.queue(END_OF_STREAM);
            return;
        }
        this_.mOpenSuccess.set(true);
        this_.mFrameQueue.setUGCFrameQueueListener(this_);
        this_.mFrameQueue.clear();
        VideoDemuxerFFmpeg videoDemuxerFFmpeg = this_;
        videoDemuxerFFmpeg.runOnWorkThread(hf.a(videoDemuxerFFmpeg));
        LiteavLog.i(TAG, "demuxer open success.");
    }

    static /* synthetic */ void access$lambda$0(VideoDemuxerFFmpeg videoDemuxerFFmpeg) {
        videoDemuxerFFmpeg.getNextEncodeVideoFrameInternal();
    }

    static /* synthetic */ void access$lambda$1(VideoDemuxerFFmpeg videoDemuxerFFmpeg) {
        videoDemuxerFFmpeg.getNextEncodeVideoFrameInternal();
    }

    static /* synthetic */ void access$lambda$2(VideoDemuxerFFmpeg videoDemuxerFFmpeg) {
        videoDemuxerFFmpeg.getNextEncodeVideoFrameInternal();
    }

    static /* synthetic */ void access$lambda$3(VideoDemuxerFFmpeg videoDemuxerFFmpeg) {
        videoDemuxerFFmpeg.getNextEncodeVideoFrameInternal();
    }
}

